/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IEmojiListCallback;
import com.yy.appbase.service.IFeatchEmojiListCallback;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.appbase.util.KeyboardHelper;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.emotion.base.EmoticonViewHandler;
import com.yy.hiyo.emotion.base.gif.bean.GifSet;
import com.yy.hiyo.emotion.base.hotemoji.HotEmojiItem;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.data.IIMdata;
import com.yy.im.R;
import com.yy.im.chatim.OfficialContext;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.IMessageOperationListener;
import com.yy.im.module.room.IUserOperationListener;
import com.yy.im.module.room.InputLayout;
import com.yy.im.module.room.callback.IOfficialMsgUiCallback;
import com.yy.im.module.room.data.EmojiTypeData;
import com.yy.im.module.room.sticker.view.WhatsAppStickerPanel;
import com.yy.im.module.room.utils.OfficialAdapterHelper;
import com.yy.im.report.ReportPresenter;
import com.yy.im.ui.widget.SpacesItemDecoration;
import java.util.ArrayList;
import java.util.List;
import me.drakeet.multitype.MultiTypeAdapter;
import net.ihago.im.srv.emoji.FavorItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OfficialMessagePage
extends YYFrameLayout
implements IMessageOperationListener.IMessageDbOperationListener,
InputLayout.IInputLayoutCallback,
EmoticonViewHandler.EmoticonHandlerCallback {
    private static final int MAX_SEND_TEXT_SIZE = 500;
    private static final String TAG = "OfficialMessagePage";
    private static final int MAX_GET_USER_INFO_FAILED_TIMES = 3;
    private IOfficialMsgUiCallback mOfficialMsgUiCallback;
    private IUserOperationListener mIUserOperationListener;
    private CommonStatusLayout mCommonStatusLayout;
    private RecyclerView mRvChat;
    private MultiTypeAdapter mChatMessageAdapter;
    private InputLayout mInputLayout;
    protected View mViewClick;
    private YYTextView mTvUnreadCount;
    private OfficialAdapterHelper mOfficialAdapterHelper = new OfficialAdapterHelper();
    private long mTargetUid;
    private UserInfoKS mMyUserInfo;
    private UserInfoKS mTargetUserInfo;
    private List<UserInfoKS> mCacheUserInfoList;
    private YYImageView mIvXiaolangLogo;
    private YYLinearLayout mLlSignAssistant;
    private int getUserInfoFailedTimes = 0;
    private String mSessionId;
    private KeyboardHelper.OnKeyboardShowListener mOnKeyboardShowListener;
    private boolean mIsKeyboardShowing;
    private List<IIMdata> mList = new ArrayList<IIMdata>();
    private boolean mShouldScroll;
    private int mToPosition;
    private ReportPresenter mReportPresenter;

    public OfficialMessagePage(Context context, UICallBacks callBacks, IOfficialMsgUiCallback iOfficialMsgUiCallback, IUserOperationListener iUserOperationListener, long targetUid, OfficialContext officialContext2) {
        super(context);
        this.mOfficialMsgUiCallback = iOfficialMsgUiCallback;
        this.mIUserOperationListener = iUserOperationListener;
        this.mTargetUid = targetUid;
        this.mSessionId = Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid);
        this.mReportPresenter = new ReportPresenter();
        this.initView(context);
        this.initChatMessage(officialContext2);
        this.initUserInfo();
    }

    private void initView(Context context) {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_official_message_room, (ViewGroup)this, true);
        this.mRvChat = (RecyclerView)this.findViewById(R.id.rv_chat);
        this.findViewById(R.id.iv_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OfficialMessagePage.this.mOfficialMsgUiCallback.onBackButtonPressed(v);
            }
        });
        this.mInputLayout = (InputLayout)this.findViewById(R.id.input_layout);
        this.mIvXiaolangLogo = (YYImageView)this.findViewById(R.id.iv_xiaolang);
        this.mLlSignAssistant = (YYLinearLayout)this.findViewById(R.id.ll_sign_assistant);
        this.mInputLayout.hideGiftBtn();
        this.mInputLayout.hideGameIcon();
        this.mInputLayout.hideInteractiveAndDressUpEmoticon();
        this.mInputLayout.setInputLayoutCallback(this);
        this.mInputLayout.getEmoticonHandler().addEmoticonHandlerCallback((EmoticonViewHandler.EmoticonHandlerCallback)this);
        this.mViewClick = this.findViewById(R.id.view_click);
        this.mViewClick.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OfficialMessagePage.this.mInputLayout.getEmoticonHandler().hideEmoticonView();
                OfficialMessagePage.this.mInputLayout.getEmoticonHandler().hideSoftKeyboard();
                OfficialMessagePage.this.mViewClick.setVisibility(8);
                OfficialMessagePage.this.scrollChatRecyclerViewToBottom(false);
            }
        });
        if (context instanceof Activity) {
            this.mOnKeyboardShowListener = new KeyboardHelper.OnKeyboardShowListener((View)this){

                public void onShow(boolean isShowing, int keyboardHeight) {
                    OfficialMessagePage.this.mIsKeyboardShowing = isShowing;
                    if (isShowing) {
                        OfficialMessagePage.this.mInputLayout.getEmoticonHandler().hideEmoticonView();
                        OfficialMessagePage.this.mViewClick.setVisibility(0);
                        OfficialMessagePage.this.scrollChatRecyclerViewToBottom(false);
                    } else if (OfficialMessagePage.this.mInputLayout.getEmoticonHandler().isEmoticonViewVisible()) {
                        OfficialMessagePage.this.mViewClick.setVisibility(0);
                        OfficialMessagePage.this.scrollChatRecyclerViewToBottom(false);
                    } else {
                        OfficialMessagePage.this.mViewClick.setVisibility(8);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OfficialMessagePage.this.scrollChatRecyclerViewToBottom(false);
                            }
                        }, (long)10L);
                    }
                    OfficialMessagePage.this.mInputLayout.onKeyboardShown(isShowing);
                }
            };
            KeyboardHelper.watchKeyboardStatus((View)this, (KeyboardHelper.OnKeyboardShowListener)this.mOnKeyboardShowListener);
        }
        View inputUpLine = this.findViewById(R.id.im_input_line);
        inputUpLine.setVisibility(8);
        inputUpLine.setVisibility(0);
        this.findViewById(R.id.fl_root).setBackgroundResource(R.color.white);
        if (this.mTargetUid == 14L) {
            this.mIvXiaolangLogo.setVisibility(8);
            this.mLlSignAssistant.setVisibility(0);
        } else {
            this.mIvXiaolangLogo.setVisibility(0);
            this.mLlSignAssistant.setVisibility(8);
        }
    }

    private void initChatMessage(OfficialContext officialContext2) {
        this.mChatMessageAdapter = new MultiTypeAdapter(this.mList);
        this.mOfficialAdapterHelper.registerHolder(this.mChatMessageAdapter, officialContext2);
        this.mRvChat.addItemDecoration((RecyclerView.ItemDecoration)new SpacesItemDecoration(ResolutionUtils.dip2Px((float)5.0f)));
        this.mRvChat.setItemAnimator(null);
        this.mRvChat.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 1, false));
        this.mRvChat.setAdapter((RecyclerView.Adapter)this.mChatMessageAdapter);
        this.onReceiveMessage();
    }

    public List<IIMdata> getMsgData() {
        return this.mList;
    }

    private void initUserInfo() {
        ArrayList<Long> uidList = new ArrayList<Long>(2);
        uidList.add(AccountUtil.getUid());
        uidList.add(this.mTargetUid);
        MLog.info((Object)TAG, (String)("initUserInfo targetUid: " + this.mTargetUid + ", isAI: " + SystemUtils.isAI((long)this.mTargetUid)), (Object[])new Object[0]);
        this.mIUserOperationListener.requestUserInfo(uidList, new OnKSProfileListCallback(){

            public void onUISuccess(List<UserInfoKS> list) {
                if (list == null) {
                    return;
                }
                OfficialMessagePage.this.mCacheUserInfoList = list;
                for (UserInfoKS bean : list) {
                    if (bean.uid == AccountUtil.getUid()) {
                        OfficialMessagePage.this.mMyUserInfo = bean;
                        continue;
                    }
                    if (bean.uid != OfficialMessagePage.this.mTargetUid) continue;
                    OfficialMessagePage.this.mTargetUserInfo = bean;
                }
                OfficialMessagePage.this.onUserInfoUpdate();
            }

            public void onError(String reason, long code) {
                if (++OfficialMessagePage.this.getUserInfoFailedTimes < 3) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            OfficialMessagePage.this.initUserInfo();
                        }
                    }, (long)3000L);
                } else if (code == -1L) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.check_network_and_retry), (int)0);
                } else {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.data_error), (int)0);
                }
            }
        });
    }

    private void onUserInfoUpdate() {
        if (this.mChatMessageAdapter != null) {
            this.mChatMessageAdapter.notifyDataSetChanged();
        }
    }

    public void onSendingMessage(ImMessageDBBean imMessage) {
        if (imMessage.getContentType() == 2 && this.getChatMessageDataIndexByTag(imMessage.getTag()) >= 0) {
            this.onUpdateMessage(imMessage);
            return;
        }
        if (this.getChatMessageDataIndexByClientSendTime(imMessage.getClientSendTime()) >= 0) {
            MLog.warn((Object)TAG, (String)"this id of the message has bean added :%d", (Object[])new Object[]{imMessage.getClientSendTime()});
            return;
        }
        ChatMessageData chatMessageData = new ChatMessageData(imMessage);
        this.mList.add(chatMessageData);
        this.mChatMessageAdapter.notifyDataSetChanged();
        this.scrollChatRecyclerViewToBottom(false);
    }

    public void onSendingImageMsg(ChatMessageData data2) {
        if (this.getChatMessageDataIndexByTag(data2.message.getTag()) >= 0) {
            MLog.warn((Object)TAG, (String)"the tag of message has bean added :%d", (Object[])new Object[]{data2.message.getTag()});
            return;
        }
        this.mList.add(data2);
        this.scrollChatRecyclerViewToBottom(false);
    }

    public void onUpdateMessage(ImMessageDBBean imMessage) {
        int index = -1;
        if (imMessage.getContentType() == 2) {
            if (imMessage.getToUserId() != this.mTargetUid) {
                return;
            }
            index = this.getChatMessageDataIndexByTag(imMessage.getTag());
        } else {
            index = this.getChatMessageDataIndexByClientSendTime(imMessage.getClientSendTime());
        }
        if (index > -1) {
            IIMdata data2 = this.mList.get(index);
            if (data2 != null && data2.getMessageDBBean() == imMessage) {
                this.mChatMessageAdapter.notifyItemChanged(index);
            } else {
                this.mList.remove(index);
                ChatMessageData chatMessageData = new ChatMessageData(imMessage);
                this.mList.add(index, chatMessageData);
                this.mChatMessageAdapter.notifyDataSetChanged();
            }
        }
    }

    public void onReceiveMessage() {
        this.mOfficialMsgUiCallback.onLoadHistoryMessageData(this.mSessionId, this);
    }

    public void notifyChatMessageDataDelete(ChatMessageData item) {
        int index = this.mList.indexOf(item);
        if (index >= 0) {
            this.mList.remove(index);
            this.mChatMessageAdapter.notifyItemRemoved(index);
        }
    }

    private int getChatMessageDataIndexByClientSendTime(long clientTime) {
        int index = -1;
        for (int i = 0; i < this.mList.size(); ++i) {
            IIMdata data2 = this.mList.get(i);
            if (!(data2 instanceof ChatMessageData) || ((ChatMessageData)data2).message.getClientSendTime() != clientTime) continue;
            index = i;
            break;
        }
        return index;
    }

    private int getChatMessageDataIndexByTag(String tag) {
        if (tag == null || tag.length() <= 0) {
            return -1;
        }
        int index = -1;
        for (int i = 0; i < this.mList.size(); ++i) {
            IIMdata data2 = this.mList.get(i);
            if (!(data2 instanceof ChatMessageData) || !tag.equals(((ChatMessageData)data2).message.getTag())) continue;
            index = i;
            break;
        }
        return index;
    }

    public boolean onBackPressed() {
        return false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mOnKeyboardShowListener != null) {
            KeyboardHelper.unwatchKeyboardStatus((View)this, (KeyboardHelper.OnKeyboardShowListener)this.mOnKeyboardShowListener);
        }
    }

    @Override
    public void onQuerySuccess(List<ImMessageDBBean> messageList) {
    }

    @Override
    public void onQueryHistorySuccess(List<ChatMessageData> dbList) {
        boolean scrollToBottom = true;
        if (dbList != null && dbList.size() > 0 && this.mList.size() > 0) {
            ImMessageDBBean dbMsg = dbList.get((int)(dbList.size() - 1)).message;
            ImMessageDBBean adapterMsg = ((ChatMessageData)this.mList.get((int)(this.mList.size() - 1))).message;
            if (dbMsg != null && adapterMsg != null && dbMsg.getSendTime() == adapterMsg.getSendTime()) {
                scrollToBottom = false;
            }
        }
        this.mList.clear();
        if (dbList != null) {
            this.mList.addAll(dbList);
        }
        this.mChatMessageAdapter.notifyDataSetChanged();
        if (scrollToBottom) {
            this.scrollChatRecyclerViewToBottom(false);
        }
    }

    @Override
    public void onAddMatchTimeMessage(ChatMessageData message) {
    }

    @Override
    public void sendMessage(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        if (content.length() <= 500) {
            if (this.mOfficialMsgUiCallback != null) {
                this.mOfficialMsgUiCallback.sendTextMsg(content, this.mTargetUid, this.mTargetUserInfo == null ? null : this.mTargetUserInfo.avatar, this.mTargetUserInfo == null ? null : this.mTargetUserInfo.nick);
            }
            this.mInputLayout.setText("");
            this.scrollChatRecyclerViewToBottom(false);
        } else {
            ToastUtils.showToast((Context)this.getContext(), (String)ResourceUtils.getString((int)R.string.chat_text_too_long_tips), (int)0);
        }
    }

    @Override
    public void selectPhoto() {
        this.mInputLayout.getEmoticonHandler().hideSoftKeyboard();
        this.mInputLayout.getEmoticonHandler().hideEmoticonView();
        this.mViewClick.setVisibility(8);
        if (this.mOfficialMsgUiCallback != null) {
            this.mOfficialMsgUiCallback.onSelectedImageButtonClick();
        }
    }

    @Override
    public void onEditTextClick() {
    }

    public void onEmoticonPanelShow(View emoticonView) {
        boolean isShow = this.mIsKeyboardShowing;
        if (!isShow) {
            this.mViewClick.setVisibility(0);
        }
        this.scrollChatRecyclerViewToBottom(false);
    }

    public void onEmoticonPanelHide(View emoticonView) {
        this.mViewClick.setVisibility(8);
        this.scrollChatRecyclerViewToBottom(false);
    }

    public void beforeEmoticonShow() {
    }

    public void beforeInputShow() {
    }

    @Override
    public void hideFastInput() {
    }

    @Override
    public void clickEmoji(EmojiTypeData data2) {
    }

    @Override
    public void clickGift() {
    }

    @Override
    public void clickGif(GifSet gifSet) {
        if (this.mOfficialMsgUiCallback != null) {
            this.mOfficialMsgUiCallback.onClickGif(gifSet);
        }
    }

    private void scrollChatRecyclerViewToBottom(boolean animate) {
        if (this.mChatMessageAdapter == null || this.mChatMessageAdapter.getItemCount() <= 0 || this.mRvChat == null) {
            return;
        }
        this.moveToPosition(this.mChatMessageAdapter.getItemCount() - 1, animate);
    }

    private void moveToPosition(int position, boolean animate) {
        if (this.mRvChat == null) {
            return;
        }
        int firstItem = this.mRvChat.getChildLayoutPosition(this.mRvChat.getChildAt(0));
        int lastItem = this.mRvChat.getChildLayoutPosition(this.mRvChat.getChildAt(this.mRvChat.getChildCount() - 1));
        if (position < firstItem) {
            if (animate) {
                this.mRvChat.smoothScrollToPosition(position);
            } else {
                this.mRvChat.scrollToPosition(position);
            }
        } else if (position <= lastItem) {
            int movePosition = position - firstItem;
            if (movePosition >= 0 && movePosition < this.mRvChat.getChildCount()) {
                int top = this.mRvChat.getChildAt(movePosition).getTop();
                if (animate) {
                    this.mRvChat.smoothScrollBy(0, top);
                } else {
                    this.mRvChat.scrollBy(0, top);
                }
            }
        } else {
            if (animate) {
                this.mRvChat.smoothScrollToPosition(position);
            } else {
                this.mRvChat.scrollToPosition(position);
            }
            this.mShouldScroll = true;
            this.mToPosition = position;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (OfficialMessagePage.this.mShouldScroll) {
                    OfficialMessagePage.this.mShouldScroll = false;
                    OfficialMessagePage.this.moveToPosition(OfficialMessagePage.this.mToPosition, false);
                }
            }
        }, (long)100L);
    }

    @Override
    public void openEmojiEditPage() {
    }

    @Override
    public void fetchAllEmoji(boolean fromCache, IFeatchEmojiListCallback callback) {
    }

    @Override
    public void openHagoAlbum(IEmojiListCallback callback) {
    }

    @Override
    public View getBigFacePage(Context context) {
        return null;
    }

    @Override
    public void clickCustomEmojiItem(@NotNull FavorItem entity) {
    }

    @Override
    public void clickCustomEmojiItem(@NotNull HotEmojiItem entity) {
    }

    @Override
    public boolean hasCustomEmoji() {
        return false;
    }

    @Override
    @Nullable
    public void createRecordView() {
    }

    @Override
    public WhatsAppStickerPanel getWhatsAppPage(Context context) {
        return null;
    }

    @Override
    public void clickGameIcon() {
    }

    @Override
    public void onGamePanelShowOrHide(boolean show) {
    }
}

