/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Build;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;

public class ImSlidingAnimatorGuide {
    public static final String TAG = "ImSlidingAnimatorGuide";
    private boolean isNewGuideShowing = false;
    private ViewStub mNewGuideViewStub;
    private RecycleImageView mFingerView;
    private View mGuideView;
    private ObjectAnimator mAnimator;
    private View mContentView;
    private View mSeeMoreView;
    private View mDrawerView;
    private DrawerLayout mDrawerLayout;
    private RecyclerView mDrawerChildView;
    private int mStartMatgin;
    private int mDrawerViewStartMargin;
    private int mSeeMoreMargin;
    private RelativeLayout.LayoutParams mSeeMoreLP;
    private FrameLayout.LayoutParams drawerLP;
    private Animator.AnimatorListener mSimpleAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            ImSlidingAnimatorGuide.this.removeGuideAndStopAnim();
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public ImSlidingAnimatorGuide(View rootView) {
        this.mContentView = rootView;
    }

    public void createGuideLayout(DrawerLayout drawerLayout, View drawerView, RecyclerView drawerChildView, View seeMoreView, int seeMoreMargin) {
        if (this.mContentView == null) {
            return;
        }
        this.mDrawerLayout = drawerLayout;
        this.mDrawerView = drawerView;
        this.mDrawerChildView = drawerChildView;
        this.mSeeMoreView = seeMoreView;
        this.mSeeMoreMargin = seeMoreMargin;
        if (this.mNewGuideViewStub == null) {
            return;
        }
        this.mGuideView = this.mNewGuideViewStub.inflate();
        if (this.mGuideView == null) {
            return;
        }
        this.mGuideView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImSlidingAnimatorGuide.this.removeGuideAndStopAnim();
            }
        });
        this.mStartMatgin = ResolutionUtils.dip2Px((float)10.0f);
        this.mDrawerViewStartMargin = ResolutionUtils.dip2Px((float)250.0f) - this.mStartMatgin;
        this.resetDrawerViewLayoutParams(this.mDrawerViewStartMargin);
        this.resetSeeMoreViewLayoutParams(this.mStartMatgin);
        this.playGuideAnim();
    }

    private void playGuideAnim() {
        if (this.mFingerView == null) {
            return;
        }
        this.isNewGuideShowing = true;
        long duration = 3000L;
        this.mDrawerLayout.postDelayed(new Runnable(){

            @Override
            public void run() {
                ImSlidingAnimatorGuide.this.isNewGuideShowing = false;
            }
        }, 3000L);
        this.mDrawerLayout.openDrawer(this.mDrawerView, false);
        this.mFingerView.post(new Runnable(){

            @Override
            public void run() {
                int moveDistance = ResolutionUtils.dip2Px((float)80.0f);
                if (LanguageUtils.isRtl()) {
                    ImSlidingAnimatorGuide.this.mAnimator = ObjectAnimator.ofFloat((Object)ImSlidingAnimatorGuide.this.mFingerView, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f, moveDistance, 0.0f, moveDistance, 0.0f});
                } else {
                    ImSlidingAnimatorGuide.this.mAnimator = ObjectAnimator.ofFloat((Object)ImSlidingAnimatorGuide.this.mFingerView, (Property)View.TRANSLATION_X, (float[])new float[]{0.0f, -moveDistance, 0.0f, -moveDistance, 0.0f});
                }
                ImSlidingAnimatorGuide.this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                ImSlidingAnimatorGuide.this.mAnimator.setDuration(3000L);
                ImSlidingAnimatorGuide.this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        float animatedValue = ((Float)animation.getAnimatedValue()).floatValue() / 4.0f;
                        if (LanguageUtils.isRtl()) {
                            animatedValue = -animatedValue;
                        }
                        ImSlidingAnimatorGuide.this.resetDrawerViewLayoutParams((int)((float)ImSlidingAnimatorGuide.this.mDrawerViewStartMargin + animatedValue));
                        ImSlidingAnimatorGuide.this.resetSeeMoreViewLayoutParams(-((int)animatedValue) + ImSlidingAnimatorGuide.this.mStartMatgin);
                    }
                });
                ImSlidingAnimatorGuide.this.mAnimator.addListener(ImSlidingAnimatorGuide.this.mSimpleAnimatorListener);
                ImSlidingAnimatorGuide.this.mAnimator.addListener(ImSlidingAnimatorGuide.this.mSimpleAnimatorListener);
                ImSlidingAnimatorGuide.this.mAnimator.start();
            }
        });
    }

    public void removeGuideAndStopAnim() {
        if (this.mAnimator != null) {
            this.mAnimator.cancel();
            this.mAnimator = null;
        }
        if (this.mContentView != null && this.mGuideView != null) {
            ((ViewGroup)this.mContentView).removeView(this.mGuideView);
        }
        this.isNewGuideShowing = false;
        this.resetDrawerViewLayoutParams(0);
        this.resetSeeMoreViewLayoutParams(0);
        this.mDrawerLayout.closeDrawer(this.mDrawerView, false);
    }

    public void resetDrawerViewLayoutParams(int leftMargin) {
        if (this.drawerLP == null) {
            this.drawerLP = (FrameLayout.LayoutParams)this.mDrawerChildView.getLayoutParams();
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.drawerLP.setMarginStart(leftMargin);
        } else {
            this.drawerLP.leftMargin = leftMargin;
        }
        this.mDrawerChildView.setLayoutParams((ViewGroup.LayoutParams)this.drawerLP);
    }

    private void resetSeeMoreViewLayoutParams(int offset) {
        if (this.mSeeMoreLP == null) {
            this.mSeeMoreLP = (RelativeLayout.LayoutParams)this.mSeeMoreView.getLayoutParams();
        }
        if (Build.VERSION.SDK_INT >= 17) {
            this.mSeeMoreLP.setMarginEnd(this.mSeeMoreMargin + offset);
        } else {
            this.mSeeMoreLP.rightMargin = this.mSeeMoreMargin + offset;
        }
        this.mSeeMoreView.setLayoutParams((ViewGroup.LayoutParams)this.mSeeMoreLP);
    }

    public boolean getIsNewGuideShowing() {
        return this.isNewGuideShowing;
    }
}

