/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindow;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.appbase.ui.widget.waveview.WaveView;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.MikeDeviceFilterUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import com.yy.hiyo.relation.base.follow.view.IFollowStatusListener;
import com.yy.im.R;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class IMTitleLayout
extends YYConstraintLayout {
    private HeadFrameImageView mIvMyAvatar;
    private YYTextView mTvMyUserName;
    private HeadFrameImageView mIvTargetUserAvatar;
    private YYTextView mTvTargetUserName;
    private YYTextView mTvBgScore;
    private YYTextView mTvLeftScore;
    private YYTextView mTvRightScore;
    private YYImageView mIvBack;
    private YYImageView mIvVoice;
    private YYImageView mIvMyVoiceStatus;
    private YYImageView mIvTargetVoiceStatus;
    private WaveView mWvLeft;
    private WaveView mWvRight;
    private BubblePopupWindow mMicTipsPop;
    private FollowView mFollowView;
    private boolean mIsVoiceOpen = false;
    private boolean mIsTargetVoiceOpen = false;
    private long mTargetUserUid = 0L;
    private IMicButtonClickListener mIMicButtonClickListener;

    public IMTitleLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public IMTitleLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public IMTitleLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        IMTitleLayout.inflate((Context)context, (int)R.layout.layout_a_im_title, (ViewGroup)this);
        this.setClipChildren(false);
        this.setPadding(0, 0, 0, 0);
        this.mIvMyAvatar = (HeadFrameImageView)this.findViewById(R.id.iv_left_header);
        this.mTvMyUserName = (YYTextView)this.findViewById(R.id.tv_left_name);
        this.mTvMyUserName.setSingleLine();
        this.mIvTargetUserAvatar = (HeadFrameImageView)this.findViewById(R.id.iv_right_header);
        this.mTvTargetUserName = (YYTextView)this.findViewById(R.id.tv_right_name);
        this.mTvTargetUserName.setSingleLine();
        this.mIvBack = (YYImageView)this.findViewById(R.id.iv_back);
        this.mIvVoice = (YYImageView)this.findViewById(R.id.iv_voice);
        this.mIvMyVoiceStatus = (YYImageView)this.findViewById(R.id.iv_left_voice);
        this.mIvTargetVoiceStatus = (YYImageView)this.findViewById(R.id.iv_right_voice);
        this.mWvLeft = (WaveView)this.findViewById(R.id.wv_left_header);
        this.mWvRight = (WaveView)this.findViewById(R.id.wv_right_header);
        this.mFollowView = (FollowView)this.findViewById(R.id.follow_view);
        this.mTvBgScore = (YYTextView)this.findViewById(R.id.tv_score_bg);
        this.mTvLeftScore = (YYTextView)this.findViewById(R.id.tv_score_left);
        this.mTvRightScore = (YYTextView)this.findViewById(R.id.tv_score_right);
        FontUtils.setFontType((TextView)this.mTvLeftScore, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.CaptainAmerica));
        FontUtils.setFontType((TextView)this.mTvRightScore, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.CaptainAmerica));
        this.mFollowView.setBoldStyle();
        this.mIvVoice.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MikeDeviceFilterUtils.needClickDelay()) {
                    return;
                }
                IMTitleLayout.this.hideMicOpenTips();
                if (IMTitleLayout.this.mIsVoiceOpen) {
                    IMTitleLayout.this.mIsVoiceOpen = false;
                } else {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "open_voice").put("act_uid", String.valueOf(IMTitleLayout.this.mTargetUserUid)));
                    IMTitleLayout.this.mIsVoiceOpen = true;
                }
                if (IMTitleLayout.this.mIMicButtonClickListener != null) {
                    IMTitleLayout.this.mIMicButtonClickListener.onSwitch(v, IMTitleLayout.this.mIsVoiceOpen);
                }
            }
        });
        int tmp = ResourceUtils.getDimen((int)R.dimen.im_root_avatar_size) / 2;
        this.mWvLeft.setDuration(5000L);
        this.mWvLeft.setStyle(Paint.Style.FILL);
        this.mWvLeft.setColor(ResourceUtils.getColor((int)R.color.wave_color));
        this.mWvLeft.setInterpolator((Interpolator)new LinearOutSlowInInterpolator());
        this.mWvLeft.setInitialRadius((float)tmp);
        this.mWvRight.setDuration(5000L);
        this.mWvRight.setStyle(Paint.Style.FILL);
        this.mWvRight.setColor(ResourceUtils.getColor((int)R.color.wave_color));
        this.mWvRight.setInterpolator((Interpolator)new LinearOutSlowInInterpolator());
        this.mWvRight.setInitialRadius((float)tmp);
        this.updateScore(0, 0);
    }

    public void updateMyHeadFrame(String headFrameUrl) {
        if (this.mIvMyAvatar != null) {
            this.mIvMyAvatar.setHeadFrame(headFrameUrl);
        }
    }

    public void updateOtherHeadFrame(String headFrameUrl) {
        if (this.mIvTargetUserAvatar != null) {
            this.mIvTargetUserAvatar.setHeadFrame(headFrameUrl);
        }
    }

    public Point getMyHeadFrameLocation() {
        return this.getTargetViewPoint(this.mIvMyAvatar);
    }

    public Point getOtherHeadFrameLocation() {
        return this.getTargetViewPoint(this.mIvTargetUserAvatar);
    }

    @NonNull
    private Point getTargetViewPoint(HeadFrameImageView mIvMyAvatar) {
        int[] location = new int[2];
        mIvMyAvatar.getLocationInWindow(location);
        int width = mIvMyAvatar.getWidth();
        int hight = mIvMyAvatar.getHeight();
        ScreenWrapperUtils.INSTANCE.paraseLocationInWindow(location);
        location[0] = location[0] + width / 2;
        location[1] = location[1] + hight / 2;
        return new Point(location[0], location[1]);
    }

    public void setOnBackButtonClickListener(View.OnClickListener listener) {
        this.mIvBack.setOnClickListener(listener);
    }

    public void setOnMyAvatarClickListener(View.OnClickListener listener) {
        this.mIvMyAvatar.setOnClickListener(listener);
    }

    public void setOnTargetUserAvatarClickListener(View.OnClickListener listener) {
        this.mIvTargetUserAvatar.setOnClickListener(listener);
    }

    public void setMicButtonClickListener(IMicButtonClickListener listener) {
        this.mIMicButtonClickListener = listener;
    }

    public void addFollowStatusListener(IFollowStatusListener listener) {
        this.mFollowView.setFollowStatusListener(listener);
    }

    public void setClickInterceptor(IFollowClickInterceptor listener) {
        this.mFollowView.setClickInterceptor(listener);
    }

    public void startLeftWaveView() {
        if (this.mWvLeft != null) {
            this.mWvLeft.start();
        }
    }

    public void startRightWaveView() {
        if (this.mWvRight != null) {
            this.mWvRight.start();
        }
    }

    public void stopLeftWaveView() {
        if (this.mWvLeft != null) {
            this.mWvLeft.stop();
        }
    }

    public void stopRightWaveView() {
        if (this.mWvRight != null) {
            this.mWvRight.stop();
        }
    }

    public void updateScore(int myScore, int hisScore) {
        if (myScore <= 0 && hisScore <= 0) {
            this.mTvBgScore.setBackgroundResource(R.drawable.bg_im_score_draw);
            this.mTvLeftScore.setText((CharSequence)"0");
            this.mTvRightScore.setText((CharSequence)"0");
        } else {
            this.mTvLeftScore.setText((CharSequence)(myScore + ""));
            this.mTvRightScore.setText((CharSequence)(hisScore + ""));
            if (myScore == hisScore) {
                this.mTvBgScore.setBackgroundResource(R.drawable.bg_im_score_draw);
            } else if (myScore > hisScore) {
                this.mTvBgScore.setBackgroundResource(R.drawable.bg_im_score_win);
            } else if (myScore < hisScore) {
                this.mTvBgScore.setBackgroundResource(R.drawable.bg_im_score_lose);
            }
        }
    }

    public void updateUserInfo(UserInfoKS myInfo, UserInfoKS targetUserInfo) {
        if (myInfo != null) {
            this.mTvMyUserName.setText((CharSequence)myInfo.nick);
            this.showAvatar((RecycleImageView)this.mIvMyAvatar.getCircleImageView(), myInfo);
        } else {
            this.mTvMyUserName.setText((CharSequence)"");
        }
        if (targetUserInfo != null) {
            this.mTargetUserUid = targetUserInfo.uid;
            this.mTvTargetUserName.setText((CharSequence)targetUserInfo.nick);
            this.showAvatar((RecycleImageView)this.mIvTargetUserAvatar.getCircleImageView(), targetUserInfo);
            this.mFollowView.bindFollowStatus(this.mTargetUserUid);
        } else {
            this.mTvTargetUserName.setText((CharSequence)"");
        }
    }

    public void updateMyVoiceStatus(int status) {
        this.updateMicStatus(this.mIvMyVoiceStatus, status);
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.i((String)"FTVoice", (String)("updateMyVoiceStatus status = " + status), (Object[])new Object[0]);
        }
        if (status == 0) {
            this.mIsVoiceOpen = false;
            this.mIvVoice.setImageResource(R.drawable.btn_mic_close);
            this.stopLeftWaveView();
        } else if (status == 3) {
            this.stopLeftWaveView();
        } else if (status == 1) {
            this.mIsVoiceOpen = true;
            this.mIvVoice.setImageResource(R.drawable.btn_mic_open);
        } else if (status == 2) {
            if (RuntimeContext.sIsDebuggable) {
                FeatureLog.i((String)"FTVoice", (String)("updateMyVoiceStatus mIsVoiceOpen = " + this.mIsVoiceOpen), (Object[])new Object[0]);
            }
            if (this.mIsVoiceOpen) {
                this.startLeftWaveView();
            }
        }
    }

    public void updateTargetVoiceStatus(int status) {
        this.updateMicStatus(this.mIvTargetVoiceStatus, status);
        if (status == 0) {
            this.mIsTargetVoiceOpen = false;
            this.stopRightWaveView();
        } else if (status == 3) {
            this.stopRightWaveView();
        } else if (status == 1) {
            this.mIsTargetVoiceOpen = true;
        } else if (status == 2 && this.mIsVoiceOpen && this.mIsTargetVoiceOpen) {
            this.startRightWaveView();
        }
    }

    private void updateMicStatus(YYImageView view, int status) {
        switch (status) {
            case 0: {
                view.setBackgroundResource(R.drawable.small_mic_close);
                view.setTag(R.id.voice_status, (Object)0);
                break;
            }
            case 1: {
                view.setBackgroundResource(R.drawable.small_mic_speaking);
                view.setTag(R.id.voice_status, (Object)1);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Object obj = view.getTag(R.id.voice_status);
                if (obj instanceof Integer && (Integer)obj == 1) {
                    view.setBackgroundResource(R.drawable.small_mic_speaking);
                    break;
                }
                view.setBackgroundResource(R.drawable.small_mic_close);
                break;
            }
        }
    }

    void showAvatar(RecycleImageView imageView, UserInfoKS bean) {
        if (bean == null) {
            imageView.setImageResource(R.drawable.icon_avatar_default_female);
        } else {
            int defaultAvatar = bean.sex == UserInfoKS.MALE ? R.drawable.icon_avatar_default_male : R.drawable.icon_avatar_default_female;
            ImageLoader.loadImage((ImageView)imageView, (String)(bean.avatar + YYImageUtils.getThumbnailPostfix((int)75)), (int)defaultAvatar, (int)defaultAvatar);
        }
    }

    public void hideMicOpenTips() {
        if (this.mMicTipsPop != null) {
            this.mMicTipsPop.dismiss();
        }
    }

    protected void onDetachedFromWindow() {
        this.mFollowView.removeBinding();
        super.onDetachedFromWindow();
    }

    public boolean isMicTipsShowing() {
        return this.mMicTipsPop != null && this.mMicTipsPop.isShowing();
    }

    public static interface IMicButtonClickListener {
        public void onSwitch(View var1, boolean var2);
    }
}

