/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import android.text.TextUtils;
import androidx.databinding.BaseObservable;
import androidx.databinding.Bindable;
import com.yy.appbase.R;
import com.yy.appbase.data.UserOnlineDBBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.user.UserBBSMedalInfo;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.relation.base.friend.data.FriendInfo;
import com.yy.im.BR;
import com.yy.im.model.IContact;
import java.util.Collection;
import java.util.List;
import net.ihago.medal.srv.mgr.MedalInfo;

public class UserInfoViewItem
extends BaseObservable
implements IContact {
    private String avatarUrl;
    private String nick;
    private long uid;
    private int sex;
    private String bbsLogo;
    private String city;
    private String birthday;
    private boolean isNew;
    private UserOnlineDBBean userOnlineDBBean;

    public UserInfoViewItem(FriendInfo friend) {
        UserInfoKS info = friend.getUserInfo();
        this.avatarUrl = info.avatar;
        this.nick = info.nick;
        this.uid = info.uid;
        this.sex = info.sex;
        this.isNew = friend.isNew();
        this.birthday = info.birthday;
        this.city = info.hideLocation == 0L ? (!TextUtils.isEmpty((CharSequence)info.lastLoginLocation) ? info.lastLoginLocation : ResourceUtils.getString((int)R.string.profile_no_location)) : "";
        Kvo.addKvoBinding((KvoSource)UserBBSMedalInfo.info((long)this.uid), (Object)this, (String)"onUserBBSMedal");
    }

    public UserInfoViewItem(long uid, String nick) {
        this.avatarUrl = "";
        this.nick = nick;
        this.uid = uid;
        this.sex = 0;
        this.isNew = false;
        this.birthday = "";
        this.city = ResourceUtils.getString((int)R.string.profile_no_location);
        Kvo.addKvoBinding((KvoSource)UserBBSMedalInfo.info((long)this.uid), (Object)this, (String)"onUserBBSMedal");
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getCity() {
        return this.city;
    }

    public String getBirthday() {
        return this.birthday;
    }

    @KvoMethodAnnotation(name="medalInfoList", sourceClass=UserBBSMedalInfo.class, thread=1)
    public void onUserBBSMedal(KvoEventIntent kvoEvent) {
        List medalInfoList = (List)kvoEvent.newValue();
        this.setBbsLogo(FP.empty((Collection)medalInfoList) ? "" : ((MedalInfo)medalInfoList.get((int)0)).url);
    }

    @Bindable
    public String getBbsLogo() {
        return this.bbsLogo;
    }

    public void setBbsLogo(String bbsLogo) {
        this.bbsLogo = bbsLogo;
        this.notifyPropertyChanged(BR.bbsLogo);
    }

    @Bindable
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        this.notifyPropertyChanged(BR.avatarUrl);
    }

    @Bindable
    public String getNick() {
        return this.nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
        this.notifyPropertyChanged(BR.nick);
    }

    @Bindable
    public long getUid() {
        return this.uid;
    }

    public void setUid(long uid) {
        this.uid = uid;
        this.notifyPropertyChanged(BR.uid);
    }

    @Override
    public int getListViewType() {
        return 0;
    }

    public int getSex() {
        return this.sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    @Bindable
    public UserOnlineDBBean getUserOnlineDBBean() {
        return this.userOnlineDBBean;
    }

    public void setUserOnlineDBBean(UserOnlineDBBean userOnlineDBBean) {
        this.userOnlineDBBean = userOnlineDBBean;
    }
}

