/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import android.graphics.drawable.Drawable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.span.ChainSpan;
import com.yy.appbase.span.MarginInfo;
import com.yy.appbase.span.TextSpan;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.blacklist.IBlacklistService;
import com.yy.hiyo.relation.base.blacklist.data.BlacklistInfo;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftBroResult;
import com.yy.im.R;
import com.yy.im.interfaces.ISingleChatDataChange;
import com.yy.im.model.ChatSession;
import com.yy.im.module.room.utils.IMItemUtils;
import com.yy.im.viewmodel.ChatSessionViewModel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;

public class SingleChatSession
extends ChatSession<ImMessageDBBean> {
    private static final String TAG = "SingleChatSession";
    private RelationInfo mRelation;
    private BlacklistInfo mBlacklistInfo;
    private WeakReference<ISingleChatDataChange> relationShipChange;
    private volatile boolean binded = false;
    private int strategyType = 0;
    private int newGuideStrategyType = 0;
    private static final String IMAGE_THUMBNAIL = YYImageUtils.getThumbnailPostfix((int)75);
    private static final int GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)25.0f);

    public SingleChatSession(ImMessageDBBean mLastMessage) {
        super(0, mLastMessage);
        long targetUid = this.getTargetUid();
        UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(targetUid);
        this.mRelation = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(userInfo.uid);
        this.mBlacklistInfo = ((IBlacklistService)ServiceManagerProxy.getServiceManager().getService(IBlacklistService.class)).isInBlacklist(userInfo.uid);
        this.setUserInfo(userInfo);
    }

    public void bindData(ISingleChatDataChange relationShipChange) {
        if (this.binded) {
            return;
        }
        this.binded = true;
        this.relationShipChange = new WeakReference<ISingleChatDataChange>(relationShipChange);
        if (this.userInfo != null) {
            Kvo.addKvoBinding((KvoSource)this.userInfo, (Object)this, (String)"onUserInfoLoaded");
        }
        Kvo.autoBindingTo((KvoSource)this.mRelation, (Object)this);
        Kvo.autoBindingTo((KvoSource)this.mBlacklistInfo, (Object)this);
    }

    @KvoMethodAnnotation(name="finishAll", sourceClass=UserInfoKS.class, thread=1)
    public void onUserInfoLoaded(KvoEventIntent event) {
        this.setTitle(this.getUserInfo().nick);
        this.setDefaultAvatar(AvatarUtils.getDefaultAvatar((int)this.getUserInfo().sex));
        ArrayList<String> urls = new ArrayList<String>(1);
        urls.add(this.getUserInfo().avatar);
        this.setAvatarUrls(urls);
        if (this.relationShipChange != null && this.relationShipChange.get() != null) {
            ((ISingleChatDataChange)this.relationShipChange.get()).onUserInfoChange(this, this.getUserInfo());
        }
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    public void updateFollowStatus(KvoEventIntent event) {
        RelationInfo relationInfo = (RelationInfo)event.source();
        if (this.relationShipChange != null && this.relationShipChange.get() != null) {
            ((ISingleChatDataChange)this.relationShipChange.get()).onFollowStatusChange(this, relationInfo);
            ((ISingleChatDataChange)this.relationShipChange.get()).onRelationChange(this, relationInfo, (Relation)event.oldValue());
        }
    }

    @KvoMethodAnnotation(name="inBlacklist", thread=1, sourceClass=BlacklistInfo.class)
    public void updateBlack(KvoEventIntent event) {
        if (this.relationShipChange != null && this.relationShipChange.get() != null) {
            ((ISingleChatDataChange)this.relationShipChange.get()).onBlackChange(this, (BlacklistInfo)event.source());
        }
    }

    @Override
    public void initial() {
        String newContent;
        ImageSpan span;
        Drawable drawable2;
        String replace;
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        this.setSessionId(msg.getSessionId());
        String content = msg.getContent();
        if (msg.getFromType() == 6 || msg.getFromType() == 7) {
            content = msg.getReserve1();
        }
        this.setAvatarType(0);
        this.setSubTitle((CharSequence)EmojiManager.INSTANCE.getExpressionString(content));
        if (msg.getContentType() == 2) {
            content = ResourceUtils.getString((int)R.string.img_tag);
            msg.setContent(content);
            this.setSubTitle(content);
        } else if (msg.getContentType() == 6) {
            GameMessageModel model2;
            if (msg.getExtObj() instanceof Map && (model2 = (GameMessageModel)JsonParser.parseJsonObject((String)JsonParser.toJson((Object)msg.getExtObj()), GameMessageModel.class)) != null && !TextUtils.isEmpty((CharSequence)model2.getGameName())) {
                msg.setExtObj((Object)model2);
            }
            if (msg.getExtObj() instanceof GameMessageModel) {
                content = ResourceUtils.getString((int)(msg.isSendByMe() ? R.string.game_invite_tips : R.string.invite_game), (Object[])new Object[]{((GameMessageModel)msg.getExtObj()).getGameName()});
                replace = "[img]";
                SpannableString spannableString = new SpannableString((CharSequence)(replace + " " + content));
                drawable2 = ResourceUtils.getDrawable((int)R.drawable.icon_game_invite);
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                span = new ImageSpan(drawable2);
                spannableString.setSpan((Object)span, 0, replace.length(), 17);
                msg.setContent(content);
                this.setSubTitle((CharSequence)spannableString);
            }
        } else if (msg.getContentType() == 11) {
            if (msg.getExtObj() instanceof GiftBroResult) {
                GiftBroResult result = (GiftBroResult)msg.getExtObj();
                this.bindGiftMsg(result.getGiftInfo() == null ? "" : result.getGiftInfo().getStaticIcon(), result.getGiftBroInfo().getPropsCount());
            } else {
                MLog.info((Object)TAG, (String)"bindGiftMsg GiftBroResult is null ", (Object[])new Object[0]);
                this.bindGiftMsg(msg.getReserve1(), StringUtils.safeParseInt((String)msg.getReserve2()));
            }
        }
        if (msg.getMsgType() == 5) {
            replace = "[img]";
            SpannableString str = new SpannableString((CharSequence)(replace + " " + ResourceUtils.getString((int)R.string.like_profile_msg)));
            drawable2 = ResourceUtils.getDrawable((int)R.drawable.icon_favor_little);
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            span = new ImageSpan(drawable2);
            str.setSpan((Object)span, 0, replace.length(), 17);
            this.setSubTitle((CharSequence)str);
        } else if (msg.getMsgType() == 30) {
            newContent = "[" + ResourceUtils.getString((int)R.string.title_room_list_title) + "]";
            this.setSubTitle(newContent);
        } else if (msg.getMsgType() == 23) {
            newContent = "base".equals(msg.getReserve3()) ? ResourceUtils.getString((int)R.string.subtitle_im_session_invitation_base_mode) : ("radio".equals(msg.getReserve3()) ? ResourceUtils.getString((int)R.string.subtitle_im_session_invitation_live_mode) : ("multivideo".equals(msg.getReserve3()) || "chat".equals(msg.getReserve3()) ? ResourceUtils.getString((int)R.string.subtitle_im_session_invitation_voice_mode) : "[" + ResourceUtils.getString((int)R.string.title_room_list_title) + "]"));
            this.setSubTitle(newContent);
        } else if (msg.getMsgType() == 35) {
            newContent = "[" + ResourceUtils.getString((int)R.string.title_im_list_show) + "]";
            this.setSubTitle(newContent);
        } else if (msg.getMsgType() == 41) {
            content = ResourceUtils.getString((int)R.string.title_audio_voice_tag);
            msg.setContent(content);
            this.setSubTitle(content);
        } else if (msg.getMsgType() == 43) {
            content = ResourceUtils.getString((int)R.string.title_big_emoji_tag);
            msg.setContent(content);
            this.setSubTitle(content);
        } else if (msg.getMsgType() == 59) {
            content = msg.getReserve1();
            this.setSubTitle(content);
        } else if (msg.getMsgType() == 57 || msg.getMsgType() == 68) {
            content = "";
            this.setSubTitle(content);
        } else if (msg.getMsgType() == 69) {
            content = this.getLikePostContent(msg);
            msg.setContent(content);
            this.setSubTitle(content);
        } else if (msg.getMsgType() == 72) {
            newContent = ResourceUtils.getString((int)R.string.im_game_card_outside);
            this.setSubTitle(newContent);
        } else if (msg.getMsgType() == 73) {
            newContent = ResourceUtils.getString((int)R.string.im_invite_enter_team_up_room_outside);
            this.setSubTitle(newContent);
        } else if (msg.getMsgType() == 74) {
            newContent = ResourceUtils.getString((int)R.string.im_create_team_up_channel_tips);
            this.setSubTitle(newContent);
        } else if (msg.getMsgType() == 78) {
            newContent = ResourceUtils.getString((int)R.string.im_hago_official_tip_content);
            this.setSubTitle(newContent);
        } else if (msg.getMsgType() == 75) {
            newContent = IMItemUtils.INSTANCE.getGiftWallTitle(msg);
            this.setSubTitle(newContent);
        }
        this.setTimeStr(msg.getSendTime());
        this.setPresentationTime(msg.getSendTime());
        long targetUid = this.getTargetUid();
        this.setUid(targetUid);
        if (ChatSessionViewModel.mCurrentChatUid != targetUid) {
            if (!msg.isSendByMe() && msg.getMsgType() != 69) {
                this.setUnReadCounts(this.getUnReadCounts() + 1);
            }
        } else if (this.getUnReadCounts() != 0) {
            this.setUnReadCounts(0);
        }
        if (msg.getExtObj() instanceof Boolean && ((Boolean)msg.getExtObj()).booleanValue()) {
            this.setUnReadCounts(0);
        }
        this.setStrategyType(msg.getStrategyType());
        this.setNewGuideStrategyType(msg.getNewGuideStrategyType());
    }

    public void bindGiftMsg(String iconUrl, int count) {
        ChainSpan.of().append((CharSequence)ResourceUtils.getString((int)R.string.summary_im_send_gift, (Object[])new Object[]{String.valueOf(count)}), new Object[]{TextSpan.of().size(13).color(ResourceUtils.getColor((int)R.color.grey_999999)).build()}).replaceImage("[gift]", iconUrl + IMAGE_THUMBNAIL, GIFT_ICON_SIZE, GIFT_ICON_SIZE, R.drawable.icon_gift_box, MarginInfo.of()).onUpdate((Callback)new Callback<Spannable>(){

            public void onResponse(Spannable data2) {
                SingleChatSession.this.setSubTitle((CharSequence)data2);
            }
        }).build();
    }

    public long getTargetUid() {
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        return msg.isSendByMe() ? msg.getToUserId() : msg.getUid();
    }

    public boolean isLastMsgSpecial() {
        ImMessageDBBean msg = (ImMessageDBBean)this.getLastMessage();
        if (msg != null) {
            return msg.getContentType() == 6;
        }
        return false;
    }

    @Override
    public void unbind() {
        if (this.userInfo != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.userInfo, (Object)this);
            this.userInfo = null;
        }
        if (this.mRelation != null) {
            Kvo.autoUnbindingFrom((KvoSource)this.mRelation, (Object)this);
            Kvo.autoUnbindingFrom((KvoSource)this.mBlacklistInfo, (Object)this);
        }
        this.relationShipChange = null;
        this.binded = false;
    }

    public int getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(int type) {
        this.strategyType = type;
    }

    public int getNewGuideStrategyType() {
        return this.newGuideStrategyType;
    }

    public void setNewGuideStrategyType(int type) {
        this.newGuideStrategyType = type;
    }

    private String getLikePostContent(ImMessageDBBean msg) {
        boolean postOwner = msg.getToUserId() == AccountUtil.getUid();
        String receiverNick = msg.getReserve2();
        if (receiverNick.length() > 12) {
            receiverNick = receiverNick.substring(0, 12);
        }
        String content = "";
        content = postOwner ? ResourceUtils.getString((int)R.string.tips_im_post_liked_by_other, (Object[])new Object[]{""}) : ResourceUtils.getString((int)R.string.tips_im_like_other_post, (Object[])new Object[]{receiverNick});
        return content;
    }
}

