/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.gift.free;

import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.im.gift.free.IImFreeGiftCallback;
import com.yy.im.gift.free.ImFreeGiftNotifyInfo;
import net.ihago.money.api.pay.IMGiftIssueNotify;
import net.ihago.money.api.pay.MoneyPayPush;
import net.ihago.money.api.pay.Uri;

public class ImFreeGiftPresenter {
    private static final String TAG = "ImFreeGiftPresenter";
    private static final String SP_KEY_IM_FREE_GIFT_ID = "SP_KEY_IM_FREE_GIFT_ID";
    private static final String SP_KEY_IM_FREE_GIFT_NUM = "SP_KEY_IM_FREE_GIFT_NUM";
    private static final String SP_KEY_IM_FREE_GIFT_ICON = "SP_KEY_IM_FREE_GIFT_ICON";
    private IImFreeGiftCallback mGiftCallback;
    private IProtoNotify<MoneyPayPush> mBroNotify = new IProtoNotify<MoneyPayPush>(){

        public String serviceName() {
            return "net.ihago.money.api.pay";
        }

        public void onNotify(@NonNull MoneyPayPush push) {
            if (push.uri == Uri.kUriIMGiftIssueNotify) {
                IMGiftIssueNotify notify2 = push.im_gift_notify;
                MLog.info((Object)ImFreeGiftPresenter.TAG, (String)"IMGiftIssueNotify uid: %d, propId: %d, num: %d, iconUrl: %s", (Object[])new Object[]{notify2.uid, notify2.prop_id, notify2.issue_num, notify2.iconURL});
                if (notify2.uid == AccountUtil.getUid() && notify2.issue_num > 0) {
                    ImFreeGiftPresenter.this.save(FP.orInt((Long)notify2.prop_id), notify2.issue_num, notify2.iconURL);
                    ImFreeGiftPresenter.this.refreshGiftList();
                }
            }
        }
    };

    public ImFreeGiftPresenter() {
        ProtoManager.getInstance().registerNotify(this.mBroNotify);
        this.check();
    }

    public void setGiftCallback(IImFreeGiftCallback mGiftCallback) {
        this.mGiftCallback = mGiftCallback;
    }

    public ImFreeGiftNotifyInfo getFreeGift() {
        int giftId = SettingFlags.getIntValue((String)SP_KEY_IM_FREE_GIFT_ID);
        int num = SettingFlags.getIntValue((String)SP_KEY_IM_FREE_GIFT_NUM);
        String iconUrl = SettingFlags.getStringValue((String)SP_KEY_IM_FREE_GIFT_ICON);
        if (giftId > 0 && num > 0) {
            return new ImFreeGiftNotifyInfo(giftId, num, iconUrl);
        }
        return null;
    }

    public void clearFreeGift() {
        SettingFlags.removeKey((String)SP_KEY_IM_FREE_GIFT_ID);
        SettingFlags.removeKey((String)SP_KEY_IM_FREE_GIFT_NUM);
        SettingFlags.removeKey((String)SP_KEY_IM_FREE_GIFT_ICON);
    }

    private void save(int giftId, int num, String iconUrl) {
        SettingFlags.setIntValue((String)SP_KEY_IM_FREE_GIFT_ID, (int)giftId);
        SettingFlags.setIntValue((String)SP_KEY_IM_FREE_GIFT_NUM, (int)num);
        SettingFlags.setStringValue((String)SP_KEY_IM_FREE_GIFT_ICON, (String)iconUrl);
        if (this.mGiftCallback != null) {
            this.mGiftCallback.onShowFreeGift(new ImFreeGiftNotifyInfo(giftId, num, iconUrl));
        }
    }

    private void refreshGiftList() {
        if (ServiceManagerProxy.getServiceManager() != null) {
            ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).loadGiftList("", AccountUtil.getUid(), GiftChannel.IM_GIFT_CHANNEL.getChannel(), true, null);
            ((IGiftService)ServiceManagerProxy.getServiceManager().getService(IGiftService.class)).loadPackageList(GiftChannel.IM_GIFT_CHANNEL.getChannel(), AccountUtil.getUid(), null);
        }
    }

    private void check() {
        ImFreeGiftNotifyInfo info = this.getFreeGift();
        if (this.mGiftCallback != null) {
            this.mGiftCallback.onShowFreeGift(info);
        }
    }
}

