/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.findfriend.v1.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.im.R;
import com.yy.im.findfriend.v1.bean.IconData;

public class IconView
extends YYLinearLayout {
    private boolean supportText = false;
    private static int DEFAULT_ICON_SIZE = 48;
    private static int DEFAULT_TEXT_SIZE = 11;
    private RecycleImageView mImageView;
    private YYTextView mTextView;

    public IconView(Context context) {
        super(context);
        this.onCreateView();
    }

    public IconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onCreateView();
    }

    public IconView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.onCreateView();
    }

    private void onCreateView() {
        this.setOrientation(1);
        this.setGravity(1);
        this.mImageView = new RecycleImageView(this.getContext());
        int size = ResolutionUtils.dip2Px((float)DEFAULT_ICON_SIZE);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(size, size);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)lp);
        if (this.supportText) {
            this.mTextView = new YYTextView(this.getContext());
            this.mTextView.setTextColor(ResourceUtils.getColor((int)R.color.txt_color_three));
            this.mTextView.setTextSize((float)DEFAULT_TEXT_SIZE);
            LinearLayout.LayoutParams lpTv = new LinearLayout.LayoutParams(-2, -2);
            ViewGroup.MarginLayoutParams lpMargin = new ViewGroup.MarginLayoutParams((ViewGroup.MarginLayoutParams)lpTv);
            lpMargin.topMargin = ResolutionUtils.dip2Px((float)10.0f);
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)lpMargin);
        }
    }

    public void setData(IconData data2) {
        if (this.mImageView != null && data2 != null) {
            ImageLoader.loadBitmap((ImageView)this.mImageView, (String)data2.getImgUrl(), (int)data2.getDrawableRes());
        }
    }
}

