/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.cim;

import android.util.Log;
import com.hummer.im.model.chat.Content;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import org.json.JSONException;
import org.json.JSONObject;

public class CIMMsgItem
extends Content {
    private static final String TAG = "MsgItem";
    public static final int ContentType = 10000;
    private JSONObject mHagoMsg;

    public CIMMsgItem(long pushId, long innerType, String msg) {
        try {
            this.mHagoMsg = JsonParser.obtainJSONObject();
            this.mHagoMsg.put("pushid", pushId);
            this.mHagoMsg.put("innertype", innerType);
            this.mHagoMsg.put("msg", (Object)msg);
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            e.printStackTrace();
        }
    }

    public CIMMsgItem() {
    }

    public CIMMsgItem(JSONObject jsonObject) {
        this.mHagoMsg = jsonObject;
    }

    public long getPushId() {
        try {
            String id2 = this.mHagoMsg.optString("pushid", "0");
            return Long.parseLong(id2);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return 0L;
        }
    }

    public long getInnerType() {
        try {
            return this.mHagoMsg.getLong("innertype");
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)("ex:" + e.getMessage()), (Throwable)e, (Object[])new Object[0]);
            return 0L;
        }
    }

    public String getMsg() {
        try {
            return this.mHagoMsg.getString("msg");
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)("ex:" + e.getMessage()), (Throwable)e, (Object[])new Object[0]);
            return "";
        }
    }

    public static void registerCodecs() {
        Content.Codec codec = new Content.Codec(){

            public int type() {
                return 10000;
            }

            public Class<? extends Content> contentClass() {
                return CIMMsgItem.class;
            }

            public Content makeChatContent(byte[] data2) {
                Log.i((String)CIMMsgItem.TAG, (String)"makeChatContent");
                try {
                    JSONObject hagoMsg = JsonParser.obtainJSONObject((String)new String(data2));
                    return new CIMMsgItem(hagoMsg);
                }
                catch (Throwable e) {
                    Log.i((String)CIMMsgItem.TAG, (String)("create MsgItem: Failed parsing - " + e.getMessage()), (Throwable)e);
                    MLog.error((Object)CIMMsgItem.TAG, (String)("create MsgItem: Failed parsing - " + e.getMessage()), (Throwable)e, (Object[])new Object[0]);
                    return null;
                }
            }

            public Content makeChatContent(String data2) {
                return new CIMMsgItem();
            }

            public byte[] makePBBytes(Content content) {
                try {
                    CIMMsgItem msgItem = (CIMMsgItem)content;
                    byte[] ret = msgItem.mHagoMsg.toString().getBytes();
                    return ret;
                }
                catch (Exception e) {
                    MLog.error((Object)CIMMsgItem.TAG, (String)("parse MsgItem: Failed parsing - " + e.getMessage()), (Throwable)e, (Object[])new Object[0]);
                    return null;
                }
            }

            public String makeDBString(Content content) {
                return "";
            }

            public String toString() {
                return "CIMMsgItem";
            }
        };
        MLog.info((Object)TAG, (String)("register codecs: " + codec + "for type: " + codec.type()), (Object[])new Object[0]);
        CIMMsgItem.registerCodec((Content.Codec)codec);
    }

    public String toString() {
        return "HagoMsgItem:" + this.mHagoMsg;
    }
}

