/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.web;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.IMsgReqCallback;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.im.base.SendImMsgRes;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import ikxd.msg.MsgInnerType;

public class SendImMsgJsEvent
implements JsEvent {
    private static final String TAG = "SendImMsgJsEvent";
    private final JsEventControllerCallback mControllerCallback;

    public SendImMsgJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.IM.sendImMsg;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"jsCall param: %s", (Object[])new Object[]{param});
        }
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            this.callbackErr(callback, 0, "paramJson is null");
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SendImMsgJsEvent.this.sendMsgAsync(param, callback);
            }
        });
    }

    private void sendMsgAsync(@NonNull String paramJson, final @Nullable IJsEventCallback callback) {
        SendMsgParam param = null;
        try {
            param = (SendMsgParam)JsonParser.parseJsonObject((String)paramJson, SendMsgParam.class);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"param is illegal", (Throwable)e, (Object[])new Object[0]);
            this.callbackErr(callback, 0, "paramJson is illegal errorMsg: " + e.getMessage());
            return;
        }
        if (param != null) {
            long fromUid = param.fromUid <= 0L ? AccountUtil.getUid() : param.fromUid;
            ImMsgReqParam.Builder reqParam = ImMsgReqParam.newBuilder().fromUid(fromUid).toUid(param.toUid).msgType(param.msgType).innerType(param.msgInnertype).msg(param.msg).pushTitle(param.pushTitle).pushContent(param.pushContent).pushPayload(param.pushPayload).nopush(param.nopush);
            if (param.extend != null) {
                reqParam.putExtend("jsExtend", (Object)param.extend);
            }
            Pair pair = null;
            if (param.msgInnertype == (long)MsgInnerType.kMsgInnerIMTxtPic.getValue()) {
                pair = ImDataFactory.INSTANCE.getTxtPicMsg(reqParam.build());
            } else if (param.msgInnertype == (long)MsgInnerType.kMsgInnerBigEmoji.getValue()) {
                pair = ImDataFactory.INSTANCE.getBigEmojiMsg(param.toUid, "");
            }
            IMsgReqCallback<SendImMsgRes> reqCallback = new IMsgReqCallback<SendImMsgRes>(){

                public void onSucceed(SendImMsgRes message) {
                    MLog.info((Object)SendImMsgJsEvent.TAG, (String)"sendMsgAsync onSucceed message: %s", (Object[])new Object[]{message});
                    if (message != null && callback != null) {
                        JsonStringBuilder builder = JsonStringBuilder.newBuilder().put("send_time", (Object)message.sendTime);
                        callback.callJs((IJsParam)BaseJsParam.dataParam((String)builder.buildJson()));
                    }
                }

                public void onFailed(long code, String reason) {
                    MLog.error((Object)SendImMsgJsEvent.TAG, (String)"sendMsgAsync onFailed code: %d, reason: %s", (Object[])new Object[]{code, reason});
                    SendImMsgJsEvent.this.callbackErr(callback, 0, "send msg fail, code: " + code + " , reason: " + reason);
                }
            };
            if (ServiceManagerProxy.getServiceManager() != null) {
                if (pair != null) {
                    ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMToDbMsg(reqParam.build(), (ImMessageDBBean)pair.second, (IMsgReqCallback)reqCallback);
                } else {
                    ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(reqParam.build(), (IMsgReqCallback)reqCallback);
                }
            }
        } else {
            this.callbackErr(callback, 0, "paramJson is illegal");
        }
    }

    private void callbackErr(@Nullable IJsEventCallback callback, int code, String msg) {
        if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)code, (String)msg);
            callback.callJs((IJsParam)err);
        }
    }

    private static class SendMsgParam {
        @SerializedName(value="fromUid")
        long fromUid;
        @SerializedName(value="toUid")
        long toUid;
        @SerializedName(value="msg")
        String msg;
        @SerializedName(value="msgType")
        long msgType;
        @SerializedName(value="msgInnertype")
        long msgInnertype;
        @SerializedName(value="pushTitle")
        String pushTitle = "";
        @SerializedName(value="pushContent")
        String pushContent = "";
        @SerializedName(value="pushPayload")
        String pushPayload = "";
        @SerializedName(value="nopush")
        boolean nopush;
        @SerializedName(value="extend")
        String extend;

        private SendMsgParam() {
        }
    }
}

