/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget.joinedchannel;

import androidx.recyclerview.widget.DiffUtil;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.JoinedChannelInfo;
import java.util.List;

public class JoinedChannelDiffCallback
extends DiffUtil.Callback {
    private List<JoinedChannelInfo> mOldData;
    private List<JoinedChannelInfo> mNewData;

    public JoinedChannelDiffCallback(List<JoinedChannelInfo> oldData, List<JoinedChannelInfo> newData) {
        this.mOldData = oldData;
        this.mNewData = newData;
    }

    public int getOldListSize() {
        return this.mOldData == null ? 0 : this.mOldData.size();
    }

    public int getNewListSize() {
        return this.mNewData == null ? 0 : this.mNewData.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        JoinedChannelInfo oldItem = this.mOldData.get(oldItemPosition);
        JoinedChannelInfo newItem = this.mNewData.get(newItemPosition);
        return StringUtils.equal((String)oldItem.cid, (String)newItem.cid);
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        JoinedChannelInfo oldItem = this.mOldData.get(oldItemPosition);
        JoinedChannelInfo newItem = this.mNewData.get(newItemPosition);
        if (!StringUtils.equal((String)oldItem.avatar, (String)newItem.avatar)) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.backgroundColor, (String)newItem.backgroundColor)) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.name, (String)newItem.name)) {
            return false;
        }
        if (oldItem.gender != newItem.gender) {
            return false;
        }
        return oldItem.unreadCount == newItem.unreadCount;
    }
}

