/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.im.R;
import com.yy.im.ui.widget.NewGameCountdownBgView;

public class NewGameCountdownView
extends YYFrameLayout {
    private static final int MAX_TIME = 30;
    private ICountdownFinishListener mCountdownFinishListener;
    private NewGameCountdownBgView mGameCountdownBgView;
    private YYTextView numberTv;
    private AnimationSet animationSet;
    private int mState = 1;
    private boolean mIsCountdown = false;
    private Runnable countdownRunnable = new Runnable(){

        @Override
        public void run() {
            if (!NewGameCountdownView.this.mIsCountdown) {
                return;
            }
            NewGameCountdownView.this.mGameCountdownBgView.startCountdown();
            String text = String.valueOf((int)(NewGameCountdownView.this.getMax() - (float)NewGameCountdownView.this.getProgress()));
            NewGameCountdownView.this.numberTv.setText((CharSequence)text);
            NewGameCountdownView.this.numberTv.startAnimation((Animation)NewGameCountdownView.this.animationSet);
            if ((float)NewGameCountdownView.this.getProgress() >= NewGameCountdownView.this.getMax()) {
                if (NewGameCountdownView.this.mCountdownFinishListener != null) {
                    NewGameCountdownView.this.mCountdownFinishListener.countdownFinish();
                }
            } else {
                NewGameCountdownView.this.postDelayed(this, 1000L);
            }
        }
    };

    public NewGameCountdownView(Context context) {
        this(context, null);
    }

    public NewGameCountdownView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NewGameCountdownView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.im_game_countdown_layout_new, (ViewGroup)this);
        this.mGameCountdownBgView = (NewGameCountdownBgView)this.findViewById(R.id.game_countdown_bg);
        this.numberTv = (YYTextView)this.findViewById(R.id.number);
        FontUtils.setFontType((TextView)this.numberTv, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.animationSet = (AnimationSet)AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.game_countdown_number_anim);
    }

    public void setCountdownFinishListener(ICountdownFinishListener countdownFinishListener) {
        this.mCountdownFinishListener = countdownFinishListener;
    }

    private int getProgress() {
        return this.mGameCountdownBgView.getProgress();
    }

    private float getMax() {
        return 30.0f;
    }

    public void startCountdown() {
        this.mIsCountdown = true;
        String text = String.valueOf((int)(this.getMax() - (float)this.getProgress()));
        this.numberTv.setText((CharSequence)text);
        this.removeCallbacks(this.countdownRunnable);
        this.post(this.countdownRunnable);
    }

    public void setBackgroundColor(int color2) {
        if (this.mGameCountdownBgView != null) {
            this.mGameCountdownBgView.setBackgroundColor(color2);
        }
    }

    public void destroy() {
        this.mIsCountdown = false;
        this.removeCallbacks(this.countdownRunnable);
        this.mGameCountdownBgView.destroy();
    }

    public void stopCountDown() {
        this.removeCallbacks(this.countdownRunnable);
        this.mGameCountdownBgView.stopCountDown();
    }

    public void setState(int state2) {
        this.mState = state2;
    }

    public void setStartTime(long startTime) {
        this.mGameCountdownBgView.setStartTime(this.mState, startTime);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public static interface ICountdownFinishListener {
        public void countdownFinish();
    }
}

