/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.databinding.BindingAdapter;
import androidx.databinding.InverseBindingAdapter;
import androidx.databinding.InverseBindingListener;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.im.R;
import java.util.ArrayList;
import java.util.List;

public class MutipleAvatarView
extends YYRelativeLayout {
    public static final int TYPE_SINGLE_AVATAR = 0;
    public static final int TYPE_SINGLE_LOCAL_AVATAR = 1;
    public static final int TYPE_MUTIPLE_AVATAR = 2;
    public List<String> mAvatars = new ArrayList<String>();
    private int mLocalResBg;
    private int bgColor;
    private int type;

    public MutipleAvatarView(Context context) {
        super(context);
    }

    public MutipleAvatarView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MutipleAvatarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setmAvatars(List<String> mAvatars) {
        this.mAvatars = mAvatars;
        this.setmAvatars(mAvatars, this.bgColor, this.mLocalResBg, this.type);
    }

    public void setmAvatars(List<String> mAvatar, int bgDrawable, int defaultImg, int type) {
        this.mAvatars = mAvatar;
        this.mLocalResBg = defaultImg;
        this.bgColor = bgDrawable;
        this.type = type;
        this.removeAllViews();
        int width = this.getWidth();
        int high = this.getHeight();
        if (type == 0) {
            CircleImageView imageView = this.generateView(width, high, FP.empty(this.mAvatars) ? "" : this.mAvatars.get(0));
            imageView.setBorderWidth(ResolutionUtils.dip2Px((float)0.5f));
            imageView.setBorderColor(ResourceUtils.getColor((int)R.color.color_e1e1e1));
            this.addView((View)imageView);
        } else if (type == 1) {
            CircleImageView imageView = this.generateView(width, high, "");
            imageView.setBorderWidth(ResolutionUtils.dip2Px((float)0.5f));
            imageView.setBorderColor(ResourceUtils.getColor((int)R.color.color_e1e1e1));
            this.addView((View)imageView);
        } else if (type == 2) {
            CircleImageView imageView = new CircleImageView(this.getContext());
            imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, high));
            ImageLoader.loadImage((ImageView)imageView, (String)"", (int)this.bgColor);
            imageView.setBorderWidth(ResolutionUtils.dip2Px((float)0.5f));
            imageView.setBorderColor(ResourceUtils.getColor((int)R.color.color_e1e1e1));
            this.addView((View)imageView);
            int size = ResolutionUtils.dip2Px((float)17.0f);
            int margin = ResolutionUtils.dip2Px((float)7.0f);
            String avatar = null;
            for (int i = 0; i < 4; ++i) {
                avatar = this.mAvatars.size() > i ? this.mAvatars.get(i) : "";
                CircleImageView v = this.generateView(size, size, avatar);
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(size, size);
                if (i == 0) {
                    lp.leftMargin = margin;
                    lp.topMargin = margin;
                } else if (i == 1) {
                    lp.topMargin = margin;
                    lp.rightMargin = margin;
                    lp.addRule(Build.VERSION.SDK_INT >= 17 ? 21 : (LanguageUtils.isLtr() ? 11 : 9));
                } else if (i == 2) {
                    lp.bottomMargin = margin;
                    lp.addRule(12);
                    lp.leftMargin = margin;
                } else {
                    lp.bottomMargin = margin;
                    lp.rightMargin = margin;
                    lp.addRule(12);
                    lp.addRule(Build.VERSION.SDK_INT >= 17 ? 21 : (LanguageUtils.isLtr() ? 11 : 9));
                }
                this.addView((View)v, (ViewGroup.LayoutParams)lp);
            }
        }
    }

    private void notifyDataChange() {
        this.removeAllViews();
        int width = this.getWidth();
        int high = this.getHeight();
        if (this.bgColor != 0) {
            CircleImageView imageView = new CircleImageView(this.getContext());
            imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, high));
            ImageLoader.loadImage((ImageView)imageView, (String)"", (int)this.bgColor);
            this.addView((View)imageView);
            int size = ResolutionUtils.dip2Px((float)17.0f);
            int margin = ResolutionUtils.dip2Px((float)7.0f);
            String avatar = null;
            for (int i = 0; i < 4; ++i) {
                avatar = this.mAvatars.size() > i ? this.mAvatars.get(i) : "";
                CircleImageView v = this.generateView(size, size, avatar);
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(size, size);
                if (i == 0) {
                    lp.leftMargin = margin;
                    lp.topMargin = margin;
                } else if (i == 1) {
                    lp.topMargin = margin;
                    lp.rightMargin = margin;
                    lp.addRule(Build.VERSION.SDK_INT >= 17 ? 21 : (LanguageUtils.isLtr() ? 11 : 9));
                } else if (i == 2) {
                    lp.bottomMargin = margin;
                    lp.addRule(12);
                    lp.leftMargin = margin;
                } else {
                    lp.bottomMargin = margin;
                    lp.rightMargin = margin;
                    lp.addRule(12);
                    lp.addRule(Build.VERSION.SDK_INT >= 17 ? 21 : (LanguageUtils.isLtr() ? 11 : 9));
                }
                this.addView((View)v, (ViewGroup.LayoutParams)lp);
            }
        } else if (this.mAvatars == null || this.mAvatars.isEmpty()) {
            this.addView((View)this.generateView(width, high, ""));
        } else if (this.mAvatars.size() == 1) {
            this.addView((View)this.generateView(width, high, this.mAvatars.get(0)));
        }
    }

    private CircleImageView generateView(int width, int high, String url) {
        CircleImageView imageView = new CircleImageView(this.getContext());
        imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(width, high));
        if (this.type == 1) {
            ImageLoader.loadImage((ImageView)imageView, (int)this.mLocalResBg);
        } else {
            if (!StringUtils.isEmpty((String)url)) {
                url = url + YYImageUtils.getThumbnailPostfix((int)75);
            }
            ImageLoader.loadImage((ImageView)imageView, (String)url, (int)this.mLocalResBg);
        }
        return imageView;
    }

    public void setLocalResBg(int mLocalResBg) {
        if (this.mLocalResBg != mLocalResBg) {
            this.mLocalResBg = mLocalResBg;
            this.setmAvatars(this.mAvatars, this.bgColor, mLocalResBg, this.type);
        }
    }

    public int getLocalResBg() {
        return this.mLocalResBg;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public int getType() {
        return this.type;
    }

    public void setBgColor(int bgColor) {
        if (this.bgColor != bgColor) {
            this.bgColor = bgColor;
            this.setmAvatars(this.mAvatars, bgColor, this.mLocalResBg, this.type);
        }
    }

    public void setType(int type) {
        if (this.type != type) {
            this.type = type;
            this.setmAvatars(this.mAvatars, this.bgColor, this.mLocalResBg, type);
        }
    }

    @InverseBindingAdapter(attribute="avatars")
    public static List<String> getAvatars(MutipleAvatarView view) {
        return view.mAvatars;
    }

    @BindingAdapter(value={"avatarsAttrChanged"})
    public static void setListener(MutipleAvatarView view, InverseBindingListener listener) {
        listener.onChange();
    }

    @InverseBindingAdapter(attribute="defaultAvatar")
    public static int getAvatarsChange(MutipleAvatarView view) {
        return view.getLocalResBg();
    }

    @BindingAdapter(value={"defaultAvatarAttrChanged"})
    public static void setLocalListener(MutipleAvatarView view, InverseBindingListener listener) {
        listener.onChange();
    }

    @InverseBindingAdapter(attribute="avatarType")
    public static int getAvatarTypeChange(MutipleAvatarView view) {
        return view.getType();
    }

    @BindingAdapter(value={"avatarTypeAttrChanged"})
    public static void setavatarTypeListener(MutipleAvatarView view, InverseBindingListener listener) {
        listener.onChange();
    }
}

