/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInviteData;
import com.yy.hiyo.game.base.bean.IndieGameInviteData;
import com.yy.hiyo.game.base.teamgame.TeamModeHelper;
import com.yy.im.R;
import com.yy.im.gift.OnFlashLocationChangeListener;
import com.yy.im.interfaces.IGameInviteListener;
import com.yy.im.module.room.callback.IShrinkGameListener;
import com.yy.im.ui.widget.GameInviteContainer;
import com.yy.im.ui.widget.GameInviteLayout;
import com.yy.im.ui.widget.overScroll.NewGameListLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageGameLayout
extends YYRelativeLayout
implements GameInviteLayout.IExitGameInviteListener,
IGameInviteListener,
View.OnClickListener,
IShrinkGameListener {
    private static final String TAG = "MessageGameLayout";
    private NewGameListLayout mNewGameListLayout;
    private GameInviteLayout mGameInviteLayout;
    private GameInviteContainer mLlGameInvite;
    private View mClickToRetryLayout;
    private YYImageView mLoadingIv;
    private ProgressBar mLoadingPb;
    private boolean mIsLoadingGameList = false;
    private IGameOperateListener mGameOperateListener;
    private IClickToGetGameListListener mClickToGetGameListListener;
    private IShrinkLayoutListener mIShrinkLayoutListener;
    private boolean isViewClickShow = false;
    private OnFlashLocationChangeListener listChangeListener;
    private int[] baseLocation;
    private int[] lastLocation = new int[2];
    private Map<String, Object> mExtendInfo = new HashMap<String, Object>();
    public static final String KEY_ROOM_ID = "roomId";
    public static final String KEY_INFO_PLAYLOAD = "infoPayload";
    public static final String KEY_OTHER_UID = "otherUid";
    public static final String KEY_COIN_GRADE_TYPE = "coinGradeType";
    public static final String KEY_KEY_IS_GOLD = "isGold";
    public static final String KEY_IS_SEND_FROM_OTHER_PLATFORM_SHARE_LANDING_PAGE = "is_send_from_other_platform_share_landing_page";

    public MessageGameLayout(Context context) {
        this(context, null);
    }

    public MessageGameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MessageGameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        MessageGameLayout.inflate((Context)context, (int)R.layout.im_new_message_game_layout, (ViewGroup)this);
        this.mNewGameListLayout = (NewGameListLayout)this.findViewById(R.id.new_game_list_layout);
        this.mLoadingIv = (YYImageView)this.findViewById(R.id.loading_iv);
        this.mLoadingPb = (ProgressBar)this.findViewById(R.id.loading_pb);
        this.mLoadingPb.setIndeterminateDrawable(this.getResources().getDrawable(R.drawable.im_get_game_list_loading_pb));
        this.mClickToRetryLayout = this.findViewById(R.id.game_empty_refresh_layout);
        this.mClickToRetryLayout.setOnClickListener((View.OnClickListener)this);
        this.setClipChildren(false);
    }

    private View getGameListView() {
        return this.mNewGameListLayout;
    }

    public void setIShrinkLayoutListener(IShrinkLayoutListener iShrinkLayoutListener) {
        this.mIShrinkLayoutListener = iShrinkLayoutListener;
    }

    @Override
    public void exitInviteLayout() {
        if (RuntimeContext.sIsForeground) {
            if (this.isViewClickShow) {
                this.mGameInviteLayout.hide(false);
            } else {
                this.mGameInviteLayout.hide(true);
            }
            this.mNewGameListLayout.show(true);
        } else {
            this.mGameInviteLayout.hide(false);
            this.mNewGameListLayout.show(true);
        }
    }

    @Override
    public void sendInvite(GameInfo gameInfo, int rowId, int columnId, int source) {
        if (this.mGameOperateListener != null) {
            if (this.mNewGameListLayout != null) {
                this.mGameOperateListener.sendGameInvite(gameInfo, rowId, columnId, source, this.mNewGameListLayout.isFocusGame(gameInfo));
            } else {
                this.mGameOperateListener.sendGameInvite(gameInfo, rowId, columnId, source, false);
            }
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.listChangeListener != null) {
            this.listChangeListener.onLocationChange(visibility == 0 ? this.lastLocation : this.baseLocation);
        }
        if (this.mLlGameInvite != null) {
            this.mLlGameInvite.setVisibility(visibility);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateLocation(h);
    }

    private void updateLocation(int h) {
        if (this.baseLocation == null) {
            this.baseLocation = this.getViewRightAndBottomPoint((View)this);
            this.baseLocation[0] = 0;
        }
        int[] location = new int[]{0, h + this.baseLocation[1]};
        if (this.listChangeListener != null) {
            MLog.info((Object)TAG, (String)"updateLocation h= %d", (Object[])new Object[]{location[1]});
            this.listChangeListener.onLocationChange(location);
        }
        this.lastLocation = location;
    }

    public void registerLocationChange(OnFlashLocationChangeListener listChangeListener) {
        if (listChangeListener == null) {
            return;
        }
        this.listChangeListener = listChangeListener;
        listChangeListener.onLocationChange(this.lastLocation);
    }

    @NonNull
    private int[] getViewRightAndBottomPoint(View targetView) {
        int[] location = new int[2];
        if (targetView == null) {
            return location;
        }
        targetView.getLocationInWindow(location);
        MLog.info((Object)TAG, (String)"location1 = %d, location2 = %d", (Object[])new Object[]{location[0], location[1]});
        return location;
    }

    public void setGameList(List<GameInfo> gameInfos, String gameId) {
        this.mIsLoadingGameList = false;
        this.mNewGameListLayout.setGameList(gameInfos, gameId, this);
        if (gameInfos == null || gameInfos.size() == 0) {
            this.showGameListEmptyRetryLayout();
        } else {
            this.mClickToRetryLayout.setVisibility(8);
        }
    }

    public void setGameOperateListener(IGameOperateListener gameOperateListener) {
        this.mGameOperateListener = gameOperateListener;
        this.mGameInviteLayout.setGameOperateListener(this.mGameOperateListener);
    }

    public void setClickToGetGameListListener(IClickToGetGameListListener clickToGetGameListListener) {
        this.mClickToGetGameListListener = clickToGetGameListListener;
    }

    public void sendInviteSuccessUI(GameInfo gameInfo, String pkId, String gameModeName) {
        this.canCloseImGameDrawer();
        this.addGameInviteCard(gameInfo, pkId, 1, gameModeName, null);
        this.print("\u53d1\u8d77\u4e00\u4e2a\u6e38\u620f\u9080\u8bf7");
    }

    public void receiveGameInviteUI(GameInfo gameInfo, String pkId, long serverTime, String gameModeName, Map<String, Object> extendInfo) {
        this.addGameInviteCard(gameInfo, pkId, 2, serverTime, gameModeName, extendInfo);
    }

    public void gameInviteInvalidUI(GameInfo gameInfo, String pkId) {
        this.removeGameInviteCard(gameInfo, pkId);
    }

    public void joinOthersGameInviteUI(GameInfo gameInfo, String pkId) {
        this.removeGameInviteCard(gameInfo, pkId);
        this.print("\u63a5\u53d7\u5bf9\u65b9\u7684\u6e38\u620f\u9080\u8bf7");
    }

    public void othersJoinYourGameInviteUI(GameInfo gameInfo, String pkId) {
        this.removeGameInviteCard(gameInfo, pkId);
        this.print("\u5bf9\u65b9\u63a5\u53d7\u4f60\u7684\u6e38\u620f\u9080\u8bf7");
    }

    public void othersDeclineYourGameInviteUI(GameInfo gameInfo, String pkId) {
        this.removeGameInviteCard(gameInfo, pkId);
        this.print("\u5bf9\u65b9\u62d2\u7edd\u4f60\u7684\u6e38\u620f\u9080\u8bf7");
    }

    public void othersCancelGameInviteUI(GameInfo gameInfo, String pkId) {
        this.removeGameInviteCard(gameInfo, pkId);
        this.print("\u5bf9\u65b9\u53d6\u6d88\u4f60\u7684\u6e38\u620f\u9080\u8bf7");
    }

    public void resetGameAcceptError(GameInfo gameInfo, String pkId) {
        this.removeGameInviteCard(gameInfo, pkId);
    }

    private void removeGameInviteCard(GameInfo gameInfo, String pkId) {
        if (TextUtils.isEmpty((CharSequence)pkId)) {
            return;
        }
        if (this.mGameInviteLayout.getVisibility() == 0) {
            this.mGameInviteLayout.popGameInviteCard(gameInfo, pkId, 2);
        }
    }

    private synchronized void addGameInviteCard(GameInfo gameInfo, String pkId, int state2, String gameModeName, Map<String, Object> extendInfo) {
        this.addGameInviteCard(gameInfo, pkId, state2, System.currentTimeMillis(), gameModeName, extendInfo);
    }

    private synchronized void addGameInviteCard(GameInfo gameInfo, String pkId, int state2, long startTime, String gameModeName, Map<String, Object> extendInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)pkId)) {
            return;
        }
        if (this.mGameInviteLayout.isInviteExist(pkId)) {
            return;
        }
        if (extendInfo != null) {
            this.mExtendInfo.putAll(extendInfo);
        }
        if (this.mGameInviteLayout.getVisibility() == 0) {
            this.mGameInviteLayout.pushGameInviteCard(gameInfo, pkId, state2, startTime, gameModeName);
        } else {
            this.mGameInviteLayout.show(gameInfo, pkId, state2, startTime, gameModeName, this.mExtendInfo);
            this.mNewGameListLayout.canCloseImGameDrawer();
        }
    }

    public void exitMessagePage() {
        this.mGameInviteLayout.exitMessagePage();
        this.mGameInviteLayout.setVisibility(8);
        this.mNewGameListLayout.setVisibility(0);
        this.setGameOperateListener(null);
        this.setIShrinkLayoutListener(null);
    }

    public GameInfo getGameInfoByPkId(String pkId) {
        return this.mGameInviteLayout.getGameInfoByPkId(pkId);
    }

    public void startDownloadGame(GameInfo gameInfo, String pkId, boolean isJoinGame) {
        if (gameInfo == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"startDownloadGame gameId=%s, pkId=%s, isJoinGame=%s", (Object[])new Object[]{gameInfo.getGid(), pkId, isJoinGame});
        if (isJoinGame) {
            this.mGameInviteLayout.startDownloadGame(gameInfo, pkId);
        } else {
            this.mNewGameListLayout.startDownloadGame(gameInfo);
        }
    }

    public void gameDownloadFailed(BasicGameInfo gameInfo, String pkId, boolean isJoinGame) {
        if (isJoinGame) {
            this.mGameInviteLayout.gameDownloadFailed(gameInfo, pkId);
        } else {
            this.mNewGameListLayout.gameDownloadFailed(gameInfo);
        }
    }

    public void gameDownloadSucceed(GameInfo gameInfo, String pkId, boolean isJoinGame) {
        if (isJoinGame) {
            this.mGameInviteLayout.gameDownloadSucceed(gameInfo, pkId);
        } else {
            this.mNewGameListLayout.gameDownloadSucceed(gameInfo);
        }
    }

    public void addInviteCard(ArrayList<GameInviteData> inviteList) {
        if (inviteList.size() <= 0) {
            return;
        }
        for (int i = 0; i < inviteList.size(); ++i) {
            GameInviteData data2 = inviteList.get(i);
            HashMap<String, Object> extendInfo = new HashMap<String, Object>();
            if (data2 instanceof IndieGameInviteData) {
                extendInfo.put(KEY_ROOM_ID, ((IndieGameInviteData)data2).getRoomId());
                extendInfo.put(KEY_INFO_PLAYLOAD, ((IndieGameInviteData)data2).getInfoPayload());
            }
            this.addGameInviteCard(data2.mGameInfo, data2.mPkId, data2.mState, data2.mInviteTime, TeamModeHelper.getModeInfoById((GameInfo)data2.mGameInfo, (int)data2.mMultiMode), extendInfo);
        }
    }

    public void setJoinGame(String pkId) {
        this.mGameInviteLayout.setJoinGame(pkId);
    }

    public Map<String, Object> getExtendInfo() {
        return this.mExtendInfo;
    }

    public void onClick(View view) {
        if (view == this.mClickToRetryLayout) {
            if (this.mIsLoadingGameList) {
                return;
            }
            this.mIsLoadingGameList = true;
            this.startLoadGameList();
            if (this.mClickToGetGameListListener != null) {
                this.mClickToGetGameListListener.getGameList();
            }
        }
    }

    private void startLoadGameList() {
        this.mLoadingIv.setVisibility(8);
        this.mLoadingPb.setVisibility(0);
    }

    public void loadGameListFailed() {
        this.mLoadingIv.setVisibility(0);
        this.mLoadingPb.setVisibility(8);
    }

    public void showGameListEmptyRetryLayout() {
        this.mClickToRetryLayout.setVisibility(0);
        this.loadGameListFailed();
    }

    public void setSendingInviteState(GameInfo info, boolean sendingInvite) {
        if (info == null) {
            return;
        }
        this.mNewGameListLayout.setSendingInviteState(info.getGid(), sendingInvite);
    }

    public void sendGameInviteFail(String gameId) {
        this.mNewGameListLayout.setSendingInviteState(gameId, false);
        this.mIsLoadingGameList = false;
        this.print("\u6e38\u620f\u5217\u8868\u52a0\u8f7d\u5931\u8d25");
    }

    public void setViewClickShow(boolean viewClickShow) {
        this.isViewClickShow = viewClickShow;
    }

    @Override
    public void clickToExpand() {
    }

    @Override
    public void clickGame(GameInfo gameInfo) {
        this.sendInvite(gameInfo, -1, -1, -1);
    }

    public void setDrawerGameList(List<GameInfo> gameInfos) {
        if (this.mNewGameListLayout != null) {
            this.mNewGameListLayout.setDrawerGameList(gameInfos);
        }
    }

    public boolean canCloseImGameDrawer() {
        if (this.mNewGameListLayout != null) {
            return this.mNewGameListLayout.canCloseImGameDrawer();
        }
        return false;
    }

    public void setGameInviteLayout(GameInviteLayout gameInviteLayout, GameInviteContainer llGameInvite) {
        this.mGameInviteLayout = gameInviteLayout;
        this.mLlGameInvite = llGameInvite;
        this.mLlGameInvite.setInviteLayoutSizeChangeListener(new InviteLayoutSizeChangeListener(){
            int[] cacheLocation;

            @Override
            public void onSizeChange(int h) {
                if (h > 0) {
                    this.cacheLocation = MessageGameLayout.this.lastLocation;
                    MessageGameLayout.this.updateLocation(h);
                } else {
                    if (this.cacheLocation != null) {
                        MessageGameLayout.access$002(MessageGameLayout.this, this.cacheLocation);
                    }
                    if (MessageGameLayout.this.listChangeListener != null) {
                        MessageGameLayout.this.listChangeListener.onLocationChange(MessageGameLayout.this.lastLocation);
                    }
                }
                MLog.info((Object)MessageGameLayout.TAG, (String)"setGameInviteLayout onSizeChange h =%d", (Object[])new Object[]{h});
            }
        });
        this.mGameInviteLayout.setExitGameInviteListener(this);
    }

    private void print(String content) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)content, (Object[])new Object[0]);
        }
    }

    static /* synthetic */ int[] access$002(MessageGameLayout x0, int[] x1) {
        x0.lastLocation = x1;
        return x1;
    }

    public static interface IShrinkLayoutListener {
        public void show();

        public void hide();
    }

    public static interface IClickToGetGameListListener {
        public void getGameList();
    }

    public static interface InviteLayoutSizeChangeListener {
        public void onSizeChange(int var1);
    }

    public static interface IGameOperateListener {
        public void sendGameInvite(GameInfo var1, int var2, int var3, int var4, boolean var5);

        public void inviteOperate(int var1, boolean var2, GameInfo var3, String var4, boolean var5);

        public void cancelInvite();
    }
}

