/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.im.base.SuggestFriendData;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import com.yy.hiyo.relation.base.follow.view.FollowView;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.im.R;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class SuggestFriendsAdapter
extends RecyclerView.Adapter<SuggestFriendsViewHolder> {
    private List<SuggestFriendData> mDatas;
    private static final String FOLLOW_ENTER_TYPE = String.valueOf(26);
    private static final int ITEM_COUNT_LIMIT = 30;
    private OnItemClickListener mItemClickListener;

    public SuggestFriendsAdapter(List<SuggestFriendData> datas) {
        this.mDatas = datas;
    }

    public int getItemCount() {
        if (this.mDatas == null || this.mDatas.isEmpty()) {
            return 0;
        }
        int count = 0;
        count = this.mDatas.size() > 30 ? 30 : this.mDatas.size();
        return count;
    }

    @NonNull
    public SuggestFriendsViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new SuggestFriendsViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.im_item_suggest_friends, parent, false));
    }

    public void onBindViewHolder(@NonNull SuggestFriendsViewHolder holder, int position) {
        if (this.mDatas.isEmpty()) {
            return;
        }
        this.handleNormalItem(holder, this.mDatas.get(position));
    }

    private void handleNormalItem(SuggestFriendsViewHolder holder, final SuggestFriendData suggestFriendData) {
        FindFriend findFriend = suggestFriendData.mFriend;
        suggestFriendData.fromType = 5;
        holder.tvName.setText((CharSequence)findFriend.getNick());
        holder.ivAvatar.setTag((Object)suggestFriendData);
        long type = findFriend.getType();
        if (type == 0L) {
            holder.ivFb.setImageResource(R.drawable.icon_facebook_little);
        } else if (type == 9L) {
            holder.ivFb.setImageResource(R.drawable.icon_zalo_little);
        } else if (type == 1L) {
            holder.ivFb.setImageResource(R.drawable.icon_contact_little);
        } else if (type == 2L) {
            holder.ivFb.setImageResource(R.drawable.icon_nearby_little);
        }
        if (suggestFriendData.type == 3) {
            holder.tvName.setLines(2);
            ImageLoader.loadImage((ImageView)holder.ivAvatar, (int)R.drawable.icon_suggest_virtual_avatar);
            holder.mFollowView.setVisibility(8);
        } else {
            holder.tvName.setLines(1);
            ImageLoader.loadImage((ImageView)holder.ivAvatar, (String)(findFriend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)findFriend.getSex()));
            holder.mFollowView.setVisibility(0);
            holder.mFollowView.setFollowStatusListener((followStatus, oldStatus) -> holder.mFollowView.setEnabled(!followStatus.isFollow()));
            holder.mFollowView.setClickInterceptor(new IFollowClickInterceptor(){

                public boolean interceptor(RelationInfo followStatus) {
                    if (!followStatus.isFollow()) {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "follow_click").put("follow_enter_type", FOLLOW_ENTER_TYPE));
                    } else {
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "no_follow_click").put("follow_enter_type", FOLLOW_ENTER_TYPE));
                    }
                    return false;
                }
            });
            holder.mFollowView.bindFollowStatus(findFriend.getUid(), FollowerUtils.INSTANCE.enterType2ePath(FOLLOW_ENTER_TYPE));
        }
        holder.view.setOnClickListener(v -> {
            if (suggestFriendData.type == 3 && null != this.mItemClickListener) {
                this.mItemClickListener.onItemClicked(v, suggestFriendData);
            }
        });
        holder.ivAvatar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (suggestFriendData.type == 3) {
                    if (null != SuggestFriendsAdapter.this.mItemClickListener) {
                        SuggestFriendsAdapter.this.mItemClickListener.onItemClicked(v, suggestFriendData);
                    }
                } else {
                    SuggestFriendData friend = (SuggestFriendData)v.getTag();
                    if (friend != null && friend.mFriend != null) {
                        ProfileReportBean bean = new ProfileReportBean();
                        bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getPlayWithFriends()));
                        bean.setUid(Long.valueOf(friend.mFriend.getUid()));
                        bean.setExtObject((Object)friend);
                        bean.setSource(6);
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.OPEN_USER_NEW_PROFILE, (Object)bean));
                    }
                }
            }
        });
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public static interface OnItemClickListener {
        public void onItemClicked(View var1, SuggestFriendData var2);
    }

    class SuggestFriendsViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        public CircleImageView ivAvatar;
        public YYImageView ivFb;
        public YYTextView tvName;
        public FollowView mFollowView;

        SuggestFriendsViewHolder(View itemView) {
            super(itemView);
            this.view = itemView;
            this.ivAvatar = (CircleImageView)this.findViewById(R.id.iv_avatar);
            this.ivFb = (YYImageView)this.findViewById(R.id.iv_fb);
            this.tvName = (YYTextView)this.findViewById(R.id.tv_name);
            this.mFollowView = (FollowView)itemView.findViewById(R.id.follow_view);
            this.mFollowView.setBoldStyle();
        }

        private <T extends View> T findViewById(int id2) {
            View viewById = this.view.findViewById(id2);
            return (T)viewById;
        }
    }
}

