/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.widget.GameDownloadingView;
import com.yy.im.R;
import com.yy.im.interfaces.IGameInviteListener;
import com.yy.im.ui.widget.ClickAndScaleButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImMainGameListAdapter
extends RecyclerView.Adapter<MyViewHolder>
implements View.OnClickListener {
    public static final String TAG = "ImMainGameListAdapter";
    private List<GameInfo> mDatas = new ArrayList<GameInfo>();
    private boolean mIsFocusStyle;
    private int mFocusItemSize;
    private long lastTimeMillis;
    private static final long MIN_CLICK_INTERVAL = 1000L;
    private IGameInviteListener mGameInviteListener;
    private HashMap<String, Boolean> mDownloadingMap;
    private HashMap<String, Boolean> mSendGameInviteMap;

    public ImMainGameListAdapter(List<GameInfo> data2, boolean isFocusStyle) {
        this.mIsFocusStyle = isFocusStyle;
        this.mDownloadingMap = new HashMap();
        this.mSendGameInviteMap = new HashMap();
        if (data2 == null && data2.isEmpty()) {
            return;
        }
        this.mDatas.addAll(data2);
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_new_game_list, viewGroup, false);
        return new MyViewHolder(view);
    }

    public void onBindViewHolder(@NonNull MyViewHolder myViewHolder, int position) {
        GameInfo gameInfo = this.mDatas.get(position);
        if (gameInfo == null) {
            return;
        }
        ImageLoader.loadImage((ImageView)myViewHolder.mGameIcon, (String)gameInfo.getImIconUrl());
        myViewHolder.mTvGameName.setText((CharSequence)gameInfo.getGname());
        this.setLayoutParams(myViewHolder.mLayoutItem, (View)myViewHolder.mRlytGameIcon, myViewHolder.mShadowView);
        myViewHolder.itemView.setTag((Object)position);
        myViewHolder.mRlytGameIcon.setTag((Object)position);
        myViewHolder.mBtnPlayGame.setTag(position);
        myViewHolder.mRlytGameIcon.setOnClickListener((View.OnClickListener)this);
        myViewHolder.mBtnPlayGame.setOnClickListener(this);
        boolean sendingInvite = this.isSendingInvite(gameInfo.getGid());
        if (sendingInvite) {
            myViewHolder.setSendingInvite(gameInfo, sendingInvite);
        } else {
            myViewHolder.setSendingInvite(gameInfo, sendingInvite);
            boolean downloading = this.isDownloading(gameInfo.getGid());
            myViewHolder.setDownloadState(gameInfo, downloading);
        }
        if (position < this.mFocusItemSize) {
            myViewHolder.playScaleAnimation(position > 0 ? 400 * position : 0);
        }
    }

    public void onViewRecycled(@NonNull MyViewHolder holder) {
        int pos;
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        if (holder != null && holder.itemView != null && holder.itemView.getTag() instanceof Integer && (pos = ((Integer)holder.itemView.getTag()).intValue()) < this.mFocusItemSize) {
            holder.clearAnimator();
        }
    }

    public int getItemCount() {
        return this.mDatas == null ? 0 : (this.mDatas.size() > 8 ? 8 : this.mDatas.size());
    }

    public void onClick(final View v) {
        int i = v.getId();
        if (i == R.id.rlyt_game_icon || i == R.id.btn_play_game) {
            GameInfo gameInfo;
            if (!this.isTimeEnabled()) {
                return;
            }
            if (!(v.getTag() instanceof Integer)) {
                MLog.error((Object)TAG, (String)"view tag is not int", (Object[])new Object[0]);
                return;
            }
            int postion = (Integer)v.getTag();
            if (postion < this.mFocusItemSize) {
                this.mFocusItemSize = 0;
            }
            if ((gameInfo = this.mDatas.get(postion)) == null) {
                return;
            }
            MLog.info((Object)TAG, (String)"on pk click! gameId=%s", (Object[])new Object[]{gameInfo.getGid()});
            if (gameInfo.isBetaTest()) {
                TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_beta_test_game), (int)1);
            } else {
                if (gameInfo.isFull()) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                    return;
                }
                if (gameInfo.isFixing()) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                    return;
                }
            }
            if (this.isDownloading(gameInfo.getGid())) {
                return;
            }
            if (this.isSendingInvite(gameInfo.getGid())) {
                return;
            }
            v.setEnabled(false);
            v.postDelayed(new Runnable(){

                @Override
                public void run() {
                    v.setEnabled(true);
                }
            }, 1000L);
            if (this.mGameInviteListener != null) {
                this.mGameInviteListener.sendInvite(gameInfo, postion + 1, 1, 1);
            }
        }
    }

    protected boolean isTimeEnabled() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastTimeMillis > 1000L) {
            this.lastTimeMillis = currentTimeMillis;
            return true;
        }
        return false;
    }

    public void setFocusItemSize(int size) {
        this.mFocusItemSize = size;
    }

    public void updateData(List<GameInfo> data2, boolean isFocusStyle) {
        this.mIsFocusStyle = isFocusStyle;
        if (data2 == null || data2.isEmpty()) {
            return;
        }
        this.mDatas.clear();
        this.mDatas.addAll(data2);
        this.notifyDataSetChanged();
    }

    private void setLayoutParams(RelativeLayout layoutItem, View icon, View shadowView) {
        if (!this.mIsFocusStyle) {
            ViewGroup.LayoutParams layoutItemParam = layoutItem.getLayoutParams();
            layoutItemParam.width = this.dp2Px(100);
            layoutItem.setLayoutParams(layoutItemParam);
            RelativeLayout.LayoutParams iconLayoutParams = (RelativeLayout.LayoutParams)icon.getLayoutParams();
            iconLayoutParams.width = this.dp2Px(100);
            iconLayoutParams.height = this.dp2Px(80);
            iconLayoutParams.bottomMargin = this.dp2Px(12);
            icon.setLayoutParams((ViewGroup.LayoutParams)iconLayoutParams);
            RelativeLayout.LayoutParams shadowLayoutParams = (RelativeLayout.LayoutParams)shadowView.getLayoutParams();
            shadowLayoutParams.width = this.dp2Px(100);
            shadowLayoutParams.height = this.dp2Px(80);
            shadowLayoutParams.topMargin = this.dp2Px(8);
            shadowView.setLayoutParams((ViewGroup.LayoutParams)shadowLayoutParams);
        } else {
            ViewGroup.LayoutParams layoutItemParam = layoutItem.getLayoutParams();
            layoutItemParam.width = this.dp2Px(90);
            layoutItem.setLayoutParams(layoutItemParam);
            RelativeLayout.LayoutParams iconLayoutParams = (RelativeLayout.LayoutParams)icon.getLayoutParams();
            iconLayoutParams.width = this.dp2Px(90);
            iconLayoutParams.height = this.dp2Px(75);
            iconLayoutParams.bottomMargin = this.dp2Px(10);
            icon.setLayoutParams((ViewGroup.LayoutParams)iconLayoutParams);
            RelativeLayout.LayoutParams shadowLayoutParams = (RelativeLayout.LayoutParams)shadowView.getLayoutParams();
            shadowLayoutParams.width = this.dp2Px(90);
            shadowLayoutParams.height = this.dp2Px(75);
            shadowLayoutParams.topMargin = this.dp2Px(6);
            shadowView.setLayoutParams((ViewGroup.LayoutParams)shadowLayoutParams);
        }
    }

    private int dp2Px(int dp) {
        return ResolutionUtils.dip2Px((float)dp);
    }

    public void setGameInviteListener(IGameInviteListener listener) {
        this.mGameInviteListener = listener;
    }

    public void clearAnimator(RecyclerView recyclerView2) {
        if (recyclerView2 != null) {
            this.mFocusItemSize = 0;
            for (int i = 0; i < recyclerView2.getChildCount(); ++i) {
                RecyclerView.ViewHolder childViewHolder = recyclerView2.getChildViewHolder(recyclerView2.getChildAt(i));
                if (!(childViewHolder instanceof MyViewHolder)) continue;
                ((MyViewHolder)childViewHolder).clearAnimator();
            }
        }
    }

    private boolean isDownloading(String gid) {
        boolean ret = false;
        if (this.mDownloadingMap.containsKey(gid) && this.mDownloadingMap.get(gid).booleanValue()) {
            ret = true;
        }
        return ret;
    }

    private boolean isSendingInvite(String gid) {
        boolean ret = false;
        if (this.mSendGameInviteMap.containsKey(gid) && this.mSendGameInviteMap.get(gid).booleanValue()) {
            ret = true;
        }
        return ret;
    }

    public void startDownloadGame(GameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfoIndex(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), true);
        this.notifyItemChanged(index, 1);
    }

    public void gameDownloadFailed(BasicGameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfoIndex(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), false);
        this.notifyItemChanged(index, 1);
    }

    public void gameDownloadSucceed(GameInfo gameInfo) {
        if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid())) {
            return;
        }
        int index = this.getGameInfoIndex(gameInfo.getGid());
        if (index == -1) {
            return;
        }
        this.mDownloadingMap.put(gameInfo.getGid(), false);
        this.notifyItemChanged(index, 1);
    }

    public void setSendingInviteState(String gameId, boolean sendingInvite) {
        if (StringUtils.isEmpty((String)gameId)) {
            return;
        }
        int index = this.getGameInfoIndex(gameId);
        if (index == -1) {
            return;
        }
        this.mSendGameInviteMap.put(gameId, sendingInvite);
        this.notifyItemChanged(index, 1);
    }

    public int getGameInfoIndex(String gid) {
        int index = -1;
        for (int i = 0; i < this.mDatas.size(); ++i) {
            GameInfo gameInfo = this.mDatas.get(i);
            if (gameInfo == null || TextUtils.isEmpty((CharSequence)gameInfo.getGid()) || !gameInfo.getGid().equals(gid)) continue;
            index = i;
            break;
        }
        return index;
    }

    class MyViewHolder
    extends RecyclerView.ViewHolder {
        private RelativeLayout mLayoutItem;
        private View mShadowView;
        private RelativeLayout mRlytGameIcon;
        public RecycleImageView mGameIcon;
        private TextView mTvGameName;
        private ClickAndScaleButton mBtnPlayGame;
        private ProgressBar mProgressBar;
        private GameDownloadingView mDownloadingView;
        public static final int SCALE_DURATION = 800;
        public ObjectAnimator smallAnimator;
        Runnable animatorTask;

        MyViewHolder(View itemView) {
            super(itemView);
            this.animatorTask = new Runnable(){

                @Override
                public void run() {
                    if (MyViewHolder.this.smallAnimator != null && ImMainGameListAdapter.this.mFocusItemSize > 0) {
                        MyViewHolder.this.smallAnimator.start();
                    }
                }
            };
            this.mLayoutItem = (RelativeLayout)itemView.findViewById(R.id.layout_new_game_item);
            this.mShadowView = itemView.findViewById(R.id.view_game_icon_shadow);
            this.mRlytGameIcon = (RelativeLayout)itemView.findViewById(R.id.rlyt_game_icon);
            this.mGameIcon = (RecycleImageView)itemView.findViewById(R.id.rciv_icon);
            this.mTvGameName = (TextView)itemView.findViewById(R.id.tv_game_name);
            this.mBtnPlayGame = (ClickAndScaleButton)itemView.findViewById(R.id.btn_play_game);
            this.mProgressBar = (ProgressBar)itemView.findViewById(R.id.loading_pb);
            this.mDownloadingView = (GameDownloadingView)itemView.findViewById(R.id.game_download_view);
            int width = ResolutionUtils.dip2Px((float)75.0f);
            this.mDownloadingView.setProgressTextSize(10.0f);
            this.mDownloadingView.setProgressSizeTextSize(10.0f);
            this.mDownloadingView.setType(2);
            this.mDownloadingView.setProgressBarWidth(width);
            this.mDownloadingView.setDefaultProgressBarWidth(width);
            this.mDownloadingView.setMarkBackground(-1291845632);
            this.mDownloadingView.setSimpleProgressSize(true);
            this.mDownloadingView.setDefaultLightWidth(ResolutionUtils.dip2Px((float)195.0f));
            this.mProgressBar.setIndeterminateDrawable(ResourceUtils.getDrawable((int)R.drawable.im_send_game_invite_loading_pb));
            Typeface typeface = FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi);
            this.mBtnPlayGame.setTypeface(typeface);
            this.mTvGameName.setTypeface(typeface);
        }

        public void setDownloadState(GameInfo gameInfo, boolean downloading) {
            if (gameInfo.isBetaTest()) {
                int res = R.string.game_card_play;
                this.mBtnPlayGame.setText(downloading ? R.string.short_tip_im_loading : res);
                this.mBtnPlayGame.setDownloading(downloading);
            } else if (gameInfo.isFull()) {
                this.mBtnPlayGame.setText(R.string.btn_full);
                this.mBtnPlayGame.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_btn_im_full));
            } else if (gameInfo.isFixing()) {
                this.mBtnPlayGame.setText(R.string.maintaining);
                this.mBtnPlayGame.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_btn_im_full));
            } else {
                int res = R.string.game_card_play;
                this.mBtnPlayGame.setText(downloading ? R.string.short_tip_im_loading : res);
                this.mBtnPlayGame.setDownloading(downloading);
            }
            this.mDownloadingView.setGameInfo(gameInfo);
        }

        public void setSendingInvite(GameInfo info, boolean sendingInvite) {
            if (info.isBetaTest()) {
                int res = R.string.game_card_play;
                this.mBtnPlayGame.setText(sendingInvite ? "" : ResourceUtils.getString((int)res));
                this.mBtnPlayGame.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_btn_im_game_card_join));
            } else if (info.isFull()) {
                this.mBtnPlayGame.setText(R.string.btn_full);
                this.mBtnPlayGame.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_btn_im_full));
            } else if (info.isFixing()) {
                this.mBtnPlayGame.setText(R.string.maintaining);
                this.mBtnPlayGame.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_btn_im_full));
            } else {
                int res = R.string.game_card_play;
                this.mBtnPlayGame.setText(sendingInvite ? "" : ResourceUtils.getString((int)res));
                this.mBtnPlayGame.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.bg_btn_im_game_card_join));
            }
            this.mProgressBar.setVisibility(sendingInvite ? 0 : 8);
        }

        public void clearAnimator() {
            if (this.smallAnimator != null) {
                this.smallAnimator.end();
                this.smallAnimator = null;
            }
            this.itemView.removeCallbacks(this.animatorTask);
        }

        public void playScaleAnimation(int duration) {
            this.createScaleAnimatorSet();
            this.itemView.postDelayed(this.animatorTask, (long)duration);
        }

        private void createScaleAnimatorSet() {
            if (this.smallAnimator == null) {
                PropertyValuesHolder smallX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 1.1f, 0.9f, 1.0f});
                PropertyValuesHolder smallY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 1.1f, 0.9f, 1.0f});
                this.smallAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this.mBtnPlayGame), (PropertyValuesHolder[])new PropertyValuesHolder[]{smallX, smallY});
                this.smallAnimator.setDuration(800L);
                this.smallAnimator.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        int time = ImMainGameListAdapter.this.mFocusItemSize <= 2 ? 400 : 800;
                        MyViewHolder.this.itemView.postDelayed(MyViewHolder.this.animatorTask, (long)time);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        }
    }
}

