/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.ui.adapter;

import androidx.databinding.ObservableList;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.MutableLiveData;
import com.yy.im.BR;
import com.yy.im.R;
import com.yy.im.model.IContact;
import com.yy.im.model.UserCharViewItem;
import com.yy.im.ui.adapter.DataBindingListAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactAdapter
extends DataBindingListAdapter<IContact> {
    private Map<String, Integer> charPositions = new HashMap<String, Integer>();

    public ContactAdapter(MutableLiveData<List<IContact>> data2) {
        super(data2);
    }

    @Override
    public void initItemWithData(ViewDataBinding binding, IContact iContact, int position) {
        binding.setVariable(BR.data, (Object)iContact);
    }

    public int getPosition(String ch) {
        Integer i = this.charPositions.get(ch);
        if (i == null) {
            return -1;
        }
        return i;
    }

    @Override
    public Map<Integer, Integer> getLayoutIds() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(0, R.layout.im_contact_user_item);
        map.put(1, R.layout.im_contact_title_item);
        map.put(2, R.layout.im_add_friends_entrance);
        map.put(3, R.layout.im_contact_footer);
        map.put(4, R.layout.im_connect_contact_quiz_enter);
        map.put(5, R.layout.im_create_channel_entrance);
        map.put(6, R.layout.im_contact_time_division);
        return map;
    }

    @Override
    public void onDataChange() {
        super.onDataChange();
        this.charPositions.clear();
        ObservableList datas = this.getDatas();
        if (datas != null && !datas.isEmpty()) {
            for (int i = 0; i < datas.size(); ++i) {
                IContact contact = (IContact)datas.get(i);
                if (!(contact instanceof UserCharViewItem)) continue;
                this.charPositions.put(((UserCharViewItem)contact).getTxt(), i);
            }
        }
    }
}

