/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.view.View;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.im.R;
import com.yy.im.localpush.ImLocalPushPresenter;
import com.yy.im.model.ChatSession;
import com.yy.im.model.LikeMeSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.LikeMeSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.act.api.lowactive.VoiceRoom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J,\u0010\u0017\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u00102\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/yy/im/session/presenter/LikeMeSessionPresenter;", "Lcom/yy/im/session/presenter/BaseSessionPresenter;", "()V", "mPresenter", "Lcom/yy/im/localpush/ImLocalPushPresenter;", "mSessionClzConfig", "Lcom/yy/im/session/bean/SessionClzConfig;", "mSessionConfig", "Lcom/yy/im/session/bean/SessionConfig;", "getSessionClzConfig", "getSessionConfig", "getUserUid", "", "temp", "Lcom/yy/im/model/ChatSession;", "handleClickItem", "", "chatSession", "v", "Landroid/view/View;", "position", "", "from", "handleLongClickItem", "notify", "notification", "Lcom/yy/framework/core/Notification;", "onReceiveLikeMessage", "message", "", "showDialogBottom", "session", "start", "environment", "Lcom/yy/framework/core/Environment;", "callback", "Lcom/yy/im/session/ISessionPresenter$ISessionCallback;", "Companion", "im_debug"})
public final class LikeMeSessionPresenter
extends BaseSessionPresenter {
    private final SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private final SessionClzConfig mSessionClzConfig = new SessionClzConfig(16, VoiceRoom.class, LikeMeSession.class);
    private ImLocalPushPresenter mPresenter;
    private static final String TAG = "GamePushSessionPresenter";
    public static final Companion Companion = new Companion(null);

    @Override
    public void notify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        int n = notification.id;
        if (n == NotificationIdDef.LIKE_ME_NEW_MESSAGE) {
            Object message;
            Object object = message = notification.extObj;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"message");
            this.onReceiveLikeMessage(object);
        } else if (n != NotificationIdDef.LIKE_ME_DELETE_MESSAGE) {
            // empty if block
        }
    }

    @Override
    public void start(@NotNull Environment environment, @NotNull ISessionPresenter.ISessionCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        super.start(environment, callback);
        this.mPresenter = callback.getImLocalPushPresenter();
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.LIKE_ME_NEW_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.LIKE_ME_DELETE_MESSAGE, (INotify)this);
    }

    @Override
    @NotNull
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    public long getUserUid(@Nullable ChatSession<?> temp) {
        return 0L;
    }

    @Override
    @NotNull
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    private final void onReceiveLikeMessage(Object message) {
        if (this.mISessionCallback != null && message instanceof VoiceRoom) {
            ChatSession targetSession = this.mISessionCallback.getTargetSession("-9");
            if (targetSession != null) {
                targetSession.update(message);
                this.mISessionCallback.updateNormalSession(targetSession);
            } else {
                this.mISessionCallback.updateNormalSession(new LikeMeSession((VoiceRoom)message));
            }
        }
    }

    public void handleClickItem(@NotNull ChatSession<?> chatSession, @NotNull View v, int position, int from) {
        Intrinsics.checkParameterIsNotNull(chatSession, (String)"chatSession");
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        super.handleClickItem(chatSession, v, position, from);
        chatSession.setUnReadCounts(0);
        chatSession.setExpiredTime(chatSession.getCanShowDuring() + System.currentTimeMillis());
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession(chatSession);
        LikeMeSession likeMeSession = (LikeMeSession)chatSession;
        VoiceRoom voiceRoom = (VoiceRoom)likeMeSession.getLastMessage();
        MsgDispatcher msgDispatcher = MsgDispatcher.getInstance();
        Integer n = voiceRoom.like_num;
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"voiceRoom.like_num");
        msgDispatcher.sendMessage(BaseMsgDef.OPEN_LIKE_ME_LIST, n.intValue());
        Integer n2 = voiceRoom.like_num;
        Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"voiceRoom.like_num");
        LikeMeSessionEventReporter.INSTANCE.reportSessionClick(likeMeSession, n2);
    }

    public void handleLongClickItem(@NotNull ChatSession<?> chatSession, @NotNull View v, int position, int from) {
        Intrinsics.checkParameterIsNotNull(chatSession, (String)"chatSession");
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        this.showDialogBottom(chatSession);
    }

    private final void showDialogBottom(ChatSession<?> session) {
        List buttonList = new ArrayList();
        ChatSession<?> chatSession = session;
        if (chatSession == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.yy.im.model.LikeMeSession");
        }
        LikeMeSession likeMeSession = (LikeMeSession)chatSession;
        ButtonItem deleteButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.button_delete), new ButtonItem.OnClickListener(likeMeSession, session){
            final /* synthetic */ LikeMeSession $likeMeSession;
            final /* synthetic */ ChatSession $session;

            public final void onClick() {
                ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(this.$likeMeSession.getSessionId());
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
                LikeMeSessionEventReporter.INSTANCE.reportSessionDelete((LikeMeSession)this.$session);
            }
            {
                this.$likeMeSession = likeMeSession;
                this.$session = chatSession;
            }
        });
        buttonList.add(deleteButton2);
        this.mDialogLinkManager.showCommonPopupDialog(DialogId.GamePublicSessonButtonDialog, buttonList, true, true);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/im/session/presenter/LikeMeSessionPresenter$Companion;", "", "()V", "TAG", "", "im_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

