/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotifyPushToastInfo;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.im.R;
import com.yy.im.localpush.CommonPushType;
import com.yy.im.model.ChatSession;
import com.yy.im.model.CommonMsgChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CommonMsgPushPresenter
extends BaseSessionPresenter {
    private static final String TAG = "CommonMsgPushPresenter";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(12, ImMessageDBBean.class, CommonMsgChatSession.class);

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_RECEIVE_COMMON_SESSION, (INotify)this);
    }

    @Override
    public void notify(Notification notification) {
        Object message;
        if (notification.id == ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE) {
            List list;
            Object message2 = notification.extObj;
            if (message2 instanceof ImMessageDBBean) {
                this.onReceiveImMessage((ImMessageDBBean)message2);
            } else if (message2 instanceof List && !(list = (List)message2).isEmpty()) {
                for (ImMessageDBBean msg : list) {
                    this.onReceiveImMessage(msg);
                }
            }
        } else if (notification.id == ImNotificationDef.IM_RECEIVE_COMMON_SESSION && (message = notification.extObj) instanceof ImMessageDBBean) {
            this.onReceiveImMessage((ImMessageDBBean)message);
        }
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        chatSession.setUnReadCounts(0);
        CommonMsgChatSession commonMsgChatSession = (CommonMsgChatSession)chatSession;
        ((ImMessageDBBean)commonMsgChatSession.getLastMessage()).setRead(true);
        commonMsgChatSession.updateSubTitle();
        ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession((Object)chatSession);
        String jumpUrl = ((ImMessageDBBean)commonMsgChatSession.getLastMessage()).getReserve1();
        MLog.info((Object)TAG, (String)"handleClickItem to jump Url: %s", (Object[])new Object[]{jumpUrl});
        ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(jumpUrl);
        String type = String.valueOf(CommonPushType.parseCommonTypeByUrl(jumpUrl));
        HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023781").put("function_id", "message_click").put("message_type", type).put("message_id", ((ImMessageDBBean)commonMsgChatSession.getLastMessage()).getReserve3()));
        try {
            SharedPreferences defaultPrf;
            Uri parse = Uri.parse((String)jumpUrl);
            String channelId = parse.getQueryParameter("channelId");
            if (StringUtils.isNotEmpty((String)channelId) && (defaultPrf = SharedPreferencesUtils.getDefaultPrf()) != null) {
                String string2 = defaultPrf.getString("im_recom_channels", "");
                MLog.info((Object)TAG, (String)"channel:%s, cache:%s", (Object[])new Object[]{channelId, string2});
                if (string2.contains(channelId)) {
                    defaultPrf.edit().putString("im_recom_channels", "").apply();
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parse uri exception", (Object[])new Object[0]);
        }
    }

    @Override
    public void handleLongClickItem(ChatSession session, View v, int position, int from) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "1");
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UNREAD_COUNTS_CHANGE));
        });
        ButtonItem ignoreButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_ignore), () -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "2");
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (Object)session.getSessionId()));
        });
        if (session.getUnReadCounts() > 0) {
            buttonList.add(ignoreButton2);
        }
        buttonList.add(deleteButton2);
        this.mDialogLinkManager.showCommonPopupDialog(DialogId.GamePublicSessonButtonDialog, buttonList, true, true);
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    private boolean messageFilter(Object msg) {
        if (msg instanceof ImMessageDBBean) {
            ImMessageDBBean bean = (ImMessageDBBean)msg;
            return bean.getMsgType() != 48;
        }
        return true;
    }

    private void onReceiveImMessage(ImMessageDBBean msg) {
        if (this.messageFilter(msg)) {
            return;
        }
        ImMessageDBBean copy = ImMessageDBBean.copy((ImMessageDBBean)msg);
        if (TextUtils.isEmpty((CharSequence)copy.getSessionId())) {
            return;
        }
        String jumpUrl = msg.getReserve1();
        if (FP.empty((CharSequence)jumpUrl)) {
            MLog.error((Object)TAG, (String)"onReceiveImMessage but jumpUrl is null!!!!", (Object[])new Object[0]);
            return;
        }
        String sessionId2 = copy.getSessionId();
        MLog.info((Object)TAG, (String)"onReceiveImMessage sessionId %s", (Object[])new Object[]{sessionId2});
        ChatSession session = this.getTargetSession(sessionId2);
        if (session == null) {
            session = new CommonMsgChatSession(copy);
            this.mISessionCallback.updateNormalSession(session);
        } else {
            session.update(copy);
            this.mISessionCallback.updateNormalSession(session);
        }
        if (RuntimeContext.sIsForeground && StringUtils.parseBoolean((String)msg.getReserve4(), (boolean)false)) {
            this.showFloatView(msg);
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(session);
    }

    private void showFloatView(ImMessageDBBean msg) {
        MLog.info((Object)TAG, (String)"need showFloatView!!!!", (Object[])new Object[0]);
        Message pushMsg = Message.obtain();
        pushMsg.what = BaseMsgDef.MSG_SHOW_NOTIFY_TOAST;
        NotifyPushToastInfo info = new NotifyPushToastInfo();
        info.setJumpType(10000);
        info.setPushType(10000);
        info.setJumpUri(msg.getReserve1());
        info.setImgUrl(msg.getImageUrl());
        info.setPushTittle(msg.getReserve2());
        info.setPushContent((CharSequence)msg.getContent());
        info.setButtonText(ResourceUtils.getString((int)R.string.im_push_join));
        info.setSource(msg.getSource());
        Bundle bundle = new Bundle();
        bundle.putSerializable("base_toast_info_type", (Serializable)info);
        pushMsg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(pushMsg);
    }
}

