/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.content.Context;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.im.base.ChannelNoticeMessage;
import com.yy.im.R;
import com.yy.im.model.ChannelNoticeEntranceSession;
import com.yy.im.model.ChatSession;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChannelNoticePresenter
extends BaseSessionPresenter {
    private static final String TAG = "ChannelNoticePresenter";
    public static final String DELETE_CHANNEL_NOTICE = "delete_channel_notice";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(6, ChannelNoticeMessage.class, ChannelNoticeEntranceSession.class);
    private Environment environment;

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        this.environment = environment;
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_NOTICE_NEW_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_EXIT_NOTICE_LIST, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_NOTICE_FETCH_MSG, (INotify)this);
    }

    @Override
    public void notify(Notification notification) {
        if (notification.id == NotificationIdDef.CHANNEL_NOTICE_NEW_MSG) {
            this.appendOrUpdateCell(notification.extObj);
        } else if (notification.id == NotificationIdDef.CHANNEL_EXIT_NOTICE_LIST) {
            ChatSession session = this.getTargetSession("-5");
            if (session instanceof ChannelNoticeEntranceSession && this.mISessionCallback != null) {
                FeatureLog.i((String)"FTChannelNotice", (String)"eixt unreadCount:%s", (Object[])new Object[]{session.getUnReadCounts()});
                session.setUnReadCounts(0);
                this.mISessionCallback.updateNormalSession(session);
            }
        } else if (notification.id == NotificationIdDef.CHANNEL_NOTICE_FETCH_MSG) {
            if (this.mISessionCallback == null) {
                return;
            }
            ChannelNoticeMessage lastMsg = (ChannelNoticeMessage)notification.extObj;
            ChatSession session = this.getTargetSession("-5");
            if (session == null) {
                if (lastMsg.getExtCounts() > 0 || !SettingFlags.getBoolean((String)(DELETE_CHANNEL_NOTICE + AccountUtil.getUid()), (boolean)false)) {
                    MLog.info((Object)TAG, (String)"CHANNEL_NOTICE_FETCH_MSG create", (Object[])new Object[0]);
                    session = new ChannelNoticeEntranceSession(lastMsg);
                }
            } else {
                session.update(lastMsg);
            }
            if (session != null) {
                this.mISessionCallback.updateNormalSession(session);
            }
        }
    }

    @Override
    public void handleLongClickItem(ChatSession session, View v, int position, int from) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        ButtonItem stickTopButton = new ButtonItem(ResourceUtils.getString((int)(session.isStickTop() ? R.string.btn_msg_cancel_stick_top : R.string.btn_msg_stick_top)), () -> {
            boolean stickTop = !session.isStickTop();
            session.setStickTop(stickTop);
            session.setPresentationTime(System.currentTimeMillis());
            session.setPresentWeight(stickTop ? 5 : 0);
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).updateSession((Object)session);
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, session.isStickTop() ? "10" : "9");
        });
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "1");
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_EXIT_NOTICE_LIST));
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
            SettingFlags.setBoolean((String)(DELETE_CHANNEL_NOTICE + AccountUtil.getUid()), (boolean)true);
        });
        buttonList.add(deleteButton2);
        buttonList.add(stickTopButton);
        if (this.mEnvironment != null) {
            this.mDialogLinkManager.updateContext((Context)this.mEnvironment.getActivity());
        }
        this.mDialogLinkManager.showCommonPopupDialog(buttonList, true, true);
    }

    private void appendOrUpdateCell(Object channelNoticeMessage) {
        if (this.mISessionCallback == null || !(channelNoticeMessage instanceof ChannelNoticeMessage)) {
            return;
        }
        ChannelNoticeMessage lastMsg = (ChannelNoticeMessage)channelNoticeMessage;
        ChatSession targetSession = this.mISessionCallback.getTargetSession("-5");
        int unread = lastMsg.getExtCounts();
        if (unread == 0) {
            ++unread;
        }
        SettingFlags.setBoolean((String)(DELETE_CHANNEL_NOTICE + AccountUtil.getUid()), (boolean)false);
        if (targetSession != null) {
            lastMsg.setExtCounts(unread + targetSession.getUnReadCounts());
            targetSession.update(lastMsg);
            this.mISessionCallback.updateNormalSession(targetSession);
        } else {
            MLog.info((Object)TAG, (String)"appendOrUpdateCell create", (Object[])new Object[0]);
            lastMsg.setExtCounts(unread);
            targetSession = new ChannelNoticeEntranceSession(lastMsg);
            this.mISessionCallback.updateNormalSession(targetSession);
        }
        ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(targetSession);
    }

    @Override
    public long getUserUid(@NotNull ChatSession temp) {
        return 0L;
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_CHANNEL_NOTICE_PAGE);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.CHANNEL_EXIT_NOTICE_LIST));
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "notice_quick_click"));
    }

    @Override
    @NotNull
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }
}

