/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.session.presenter;

import android.content.SharedPreferences;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import biz.IMSecType;
import com.google.gson.Gson;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.popmenu.ButtonItem;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.LastMsgAndUnreadData;
import com.yy.hiyo.channel.base.bean.MsgSection;
import com.yy.hiyo.channel.base.bean.MyJoinChannelItem;
import com.yy.hiyo.channel.base.bean.plugins.RoomPlugin;
import com.yy.hiyo.channel.base.service.IFamilyLuckyBagService;
import com.yy.hiyo.channel.base.service.ITempChannelChat;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.im.R;
import com.yy.im.model.ChannelEntranceMsg;
import com.yy.im.model.ChannelEntranceSession;
import com.yy.im.model.ChannelNoticeEntranceSession;
import com.yy.im.model.ChatSession;
import com.yy.im.model.SingleChatSession;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.report.ChatSessionEventReporter;
import com.yy.im.session.ISessionPresenter;
import com.yy.im.session.bean.SessionClzConfig;
import com.yy.im.session.bean.SessionConfig;
import com.yy.im.session.presenter.BaseSessionPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.ihago.channel.srv.callact.ActMsg;
import net.ihago.channel.srv.callact.Uri;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class ChannelEntranceSessionPresenter
extends BaseSessionPresenter {
    private static final String TAG = "ChannelEntranceSessionP";
    public static final String LOCAL_DELETE_JOIN_CHANNEL = "local_delete_join_channel";
    private SessionConfig mSessionConfig = new SessionConfig(0, 0);
    private SessionClzConfig mSessionClzConfig = new SessionClzConfig(9, ChannelEntranceMsg.class, ChannelEntranceSession.class);
    private boolean mKeepMonitor = false;
    private final Object listLock = new Object();
    private final Set<ChannelEntranceSession> mShowingJoinChannels = new HashSet<ChannelEntranceSession>();
    private final Set<String> mJoinChannels = new HashSet<String>();
    private boolean mHasUpdateShows = false;
    private boolean mHasPullMyJoinChannel = false;
    private static final long statusUpdateInterval = 30000L;
    private final IFrequencyLimitExecutor statusUpdateExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)30000L, (boolean)false);
    private volatile boolean isPageShow = false;
    private static boolean sUnreadOptSwitch = SettingFlags.getBoolean((String)"chat_session_unread_opt", (boolean)true);
    @Nullable
    private SharedPreferences announcementSp;
    @Nullable
    private SharedPreferences atMeSp;
    private final IChannelCenterService.IControlConfigOrJoinedChannelsListener mChannelListener = new IChannelCenterService.IControlConfigOrJoinedChannelsListener(){

        public void onMyJoinedChannelsListChange() {
            MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"onMyJoinedChannelsListChange", (Object[])new Object[0]);
            ChannelEntranceSessionPresenter.this.pullMyJoinChannels(true);
        }

        public void onControlConfigChange() {
            MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"onControlConfigChange", (Object[])new Object[0]);
        }

        public void onChannelMsgReceiveModeChange(String cid, int mode) {
            MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"onChannelMsgReceiveModeChange cid:%s, mode:%d", (Object[])new Object[]{cid, mode});
        }

        public void onMyJoinedChannelsUnreadNumChange(String cid, LastMsgAndUnreadData data2) {
            if (data2 == null) {
                return;
            }
            MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"onMyJoinedChannelsUnreadNumChange cid:%s, unreadNums:%d", (Object[])new Object[]{cid, data2.unreadMsgNum});
            ChatSession chatSession = ChannelEntranceSessionPresenter.this.updateUnReadMsg(cid, (int)data2.unreadMsgNum, data2.lastMsg, null);
            if (chatSession != null) {
                ChannelEntranceSessionPresenter.this.mISessionCallback.updateChannelSession(chatSession);
            }
            ChannelEntranceSessionPresenter.this.updateChannelStatus();
        }

        public void onMyJoinedChannelsUnreadNumChange(HashMap<String, LastMsgAndUnreadData> unreadNums) {
            MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"onMyJoinedChannelsUnreadNumChange unreadNums:%s", (Object[])new Object[]{unreadNums});
            Set<String> strings = unreadNums.keySet();
            if (FP.empty(strings)) {
                return;
            }
            ArrayList<Object> sessions = new ArrayList<Object>();
            for (String cid : strings) {
                LastMsgAndUnreadData itemData = unreadNums.get(cid);
                if (itemData == null) continue;
                if (itemData.lastMsg != null && !itemData.lastMsg.isValid()) {
                    ChannelEntranceSessionPresenter.this.handleInvalidMsg(cid, itemData);
                    continue;
                }
                long aLong = itemData.unreadMsgNum;
                int unRead = 0;
                unRead = (int)aLong;
                ChatSession chatSession = ChannelEntranceSessionPresenter.this.updateUnReadMsg(cid, unRead, itemData.lastMsg, null);
                if (chatSession != null) {
                    sessions.add(chatSession);
                }
                if (!SystemUtils.isShowEnvSetting() || itemData.unreadMsgNum <= 0L) continue;
                MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"onMyJoinedChannelsUnreadNumChange cid:%s, %d", (Object[])new Object[]{cid, unRead});
            }
            if (!FP.empty(sessions)) {
                ChannelEntranceSessionPresenter.this.mISessionCallback.updateChannelSessions(sessions);
            }
            ChannelEntranceSessionPresenter.this.updateChannelStatus();
        }
    };

    private void handleInvalidMsg(String cid, LastMsgAndUnreadData itemData) {
        ChatSession<?> chatSession;
        MLog.info((Object)TAG, (String)"handle invalid msg", (Object[])new Object[0]);
        ChatSession targetSession = this.getTargetSession(cid);
        if (targetSession == null) {
            return;
        }
        MyJoinChannelItem joinChannelItem = ((ChannelEntranceMsg)((ChannelEntranceSession)targetSession).getLastMessage()).getMyJoinChannelItem();
        if (joinChannelItem == null) {
            return;
        }
        long aLong = itemData.unreadMsgNum;
        int unRead = (int)aLong;
        MLog.info((Object)TAG, (String)("handle invalid msg: joinchannel item type " + cid + " " + joinChannelItem.getLastMsgType()), (Object[])new Object[0]);
        if (this.shouldUpdateUnReadMsg(joinChannelItem) && (chatSession = this.updateUnReadMsg(cid, unRead, itemData.lastMsg, joinChannelItem)) != null) {
            ArrayList<Object> sessions = new ArrayList<Object>();
            sessions.add(chatSession);
            this.mISessionCallback.updateChannelSessions(sessions);
        }
    }

    private boolean shouldUpdateUnReadMsg(MyJoinChannelItem joinChannelItem) {
        return joinChannelItem.getLastMsgType() == IMSecType.IST_SET_BULLETIN.getValue();
    }

    private IChannelCenterService getChannelService() {
        return (IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class);
    }

    private void pullMyJoinChannels(boolean forceRefresh) {
        this.getChannelService().getMyJoinedChannels(new IChannelCenterService.IGetMyJoinedChannelsCallBack(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(ArrayList<MyJoinChannelItem> groupSummays) {
                HashSet<String> joinchannels = new HashSet<String>();
                MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"pullMyJoinChannels:%s", (Object[])new Object[]{groupSummays});
                if (groupSummays != null && !groupSummays.isEmpty()) {
                    ArrayList<Object> updates = new ArrayList<Object>();
                    for (MyJoinChannelItem joinChannelItem : groupSummays) {
                        if (joinChannelItem == null || !sUnreadOptSwitch && FP.empty((CharSequence)joinChannelItem.getLastStorageMsgTips()) || joinChannelItem.version == 0 && joinChannelItem.getLastMsgTips().equals(ResourceUtils.getString((int)R.string.tips_new_unread_channel_msg)) || joinChannelItem.version == 0 && joinChannelItem.mPluginData != null && joinChannelItem.mPluginData.mode != 1) continue;
                        joinchannels.add(joinChannelItem.cid);
                        ChatSession targetSession = ChannelEntranceSessionPresenter.this.getTargetSession(joinChannelItem.cid);
                        ChannelEntranceMsg channelEntranceMsg = new ChannelEntranceMsg();
                        channelEntranceMsg.setMyJoinChannelItem(joinChannelItem);
                        if (targetSession != null) {
                            targetSession.update(channelEntranceMsg);
                            if (joinChannelItem.version == 1 && joinChannelItem.mPluginData != null && joinChannelItem.mPluginData.mode != 1 && targetSession.getSessionId().equals(joinChannelItem.cid)) {
                                ChannelEntranceSessionPresenter.this.mISessionCallback.deleteSession(targetSession, true);
                            }
                        } else if (joinChannelItem.version == 1 && joinChannelItem.mPluginData != null && joinChannelItem.mPluginData.mode == 1 && !ChannelEntranceSessionPresenter.this.isLocalDeleteMyJoinChannelSession(joinChannelItem)) {
                            targetSession = new ChannelEntranceSession(channelEntranceMsg);
                            Object object = ChannelEntranceSessionPresenter.this.listLock;
                            synchronized (object) {
                                ChannelEntranceSessionPresenter.this.mShowingJoinChannels.add((ChannelEntranceSession)targetSession);
                            }
                        }
                        if (targetSession == null) continue;
                        updates.add(targetSession);
                    }
                    ChannelEntranceSessionPresenter.this.mISessionCallback.updateChannelSessions(updates);
                }
                Object object = ChannelEntranceSessionPresenter.this.listLock;
                synchronized (object) {
                    ChannelEntranceSessionPresenter.this.mJoinChannels.clear();
                    ChannelEntranceSessionPresenter.this.mJoinChannels.addAll(joinchannels);
                    ChannelEntranceSessionPresenter.this.mHasPullMyJoinChannel = true;
                    ChannelEntranceSessionPresenter.this.updateChannelStatus();
                }
                ChannelEntranceSessionPresenter.this.checkDeleteNotJoinChannel();
            }

            public void onError(int errorCode, Exception e) {
            }
        }, forceRefresh, myChannel -> !myChannel.source.equals("hago.game") || myChannel.transClient);
    }

    private boolean isLocalDeleteMyJoinChannelSession(MyJoinChannelItem joinChannelItem) {
        return SettingFlags.getBoolean((String)(LOCAL_DELETE_JOIN_CHANNEL + joinChannelItem.cid + AccountUtil.getUid()), (boolean)false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ChatSession<?> updateUnReadMsg(String cid, int unreadNums, BaseImMsg from, MyJoinChannelItem tempChannelItem) {
        Iterator iterator;
        MyJoinChannelItem targetChannel;
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"updateUnReadMsg cid:%s, unread:%d", (Object[])new Object[]{cid, unreadNums});
        }
        if (StringUtils.isEmpty((String)cid)) {
            return null;
        }
        ChatSession targetSession = this.getTargetSession(cid);
        ArrayList myJoinedChannels = this.getChannelService().getMyJoinedChannels(null, false, myChannel -> !myChannel.source.equals("hago.game") || myChannel.transClient);
        if (tempChannelItem != null) {
            myJoinedChannels.clear();
            myJoinedChannels.add(tempChannelItem);
        }
        if (myJoinedChannels != null && !myJoinedChannels.isEmpty()) {
            targetChannel = null;
            iterator = myJoinedChannels.iterator();
        } else {
            return null;
        }
        while (iterator.hasNext()) {
            MyJoinChannelItem channelItem = (MyJoinChannelItem)iterator.next();
            if (!sUnreadOptSwitch && FP.empty((CharSequence)channelItem.getLastStorageMsgTips())) continue;
            if (channelItem.version == 1 && channelItem.mPluginData != null && channelItem.mPluginData.mode != 1) {
                if (targetSession == null || !targetSession.getSessionId().equals(channelItem.cid)) continue;
                this.mISessionCallback.deleteSession(targetSession, true);
                continue;
            }
            if (channelItem.version == 0 && channelItem.mPluginData != null && channelItem.mPluginData.mode != 1 || channelItem.version == 0 && channelItem.getLastMsgTips().equals(ResourceUtils.getString((int)R.string.tips_new_unread_channel_msg)) || channelItem != null && cid.equals(channelItem.cid) && SettingFlags.getBoolean((String)(LOCAL_DELETE_JOIN_CHANNEL + channelItem.cid + AccountUtil.getUid()), (boolean)false) && unreadNums == 0 || !cid.equals(channelItem.cid)) continue;
            targetChannel = channelItem;
            break;
        }
        if (targetChannel != null) {
            SettingFlags.setBoolean((String)(LOCAL_DELETE_JOIN_CHANNEL + targetChannel.cid + AccountUtil.getUid()), (boolean)false);
            ChannelEntranceMsg channelEntranceMsg = new ChannelEntranceMsg();
            channelEntranceMsg.setMyJoinChannelItem(targetChannel);
            if (targetSession == null) {
                if (targetChannel.mPluginData != null && targetChannel.mPluginData.mode == 1) {
                    targetSession = new ChannelEntranceSession(channelEntranceMsg);
                }
            } else if (targetSession instanceof ChannelEntranceSession) {
                if (((ChannelEntranceSession)targetSession).shouldUpdate(targetChannel)) {
                    targetSession.update(channelEntranceMsg);
                } else {
                    MLog.info((Object)TAG, (String)"do not need to update!!!!", (Object[])new Object[0]);
                }
            }
            if (targetSession instanceof ChannelEntranceSession) {
                ChannelEntranceSession channelEntranceSession;
                block35: {
                    channelEntranceSession = (ChannelEntranceSession)targetSession;
                    MyJoinChannelItem joinChannelItem = ((ChannelEntranceMsg)channelEntranceSession.getLastMessage()).getMyJoinChannelItem();
                    if (unreadNums > 0) {
                        String atMeMsg;
                        String key;
                        String msg;
                        SharedPreferences atMeSpFinal;
                        block34: {
                            atMeSpFinal = this.atMeSp;
                            if (joinChannelItem.getLastMsgType() == IMSecType.IST_TAT.getValue()) {
                                msg = joinChannelItem.getLastMsgContent();
                                try {
                                    String key2;
                                    CharSequence atMeMsg2;
                                    JSONObject msgJson = JsonParser.obtainJSONObject((String)msg);
                                    if (!msgJson.has("uid")) break block34;
                                    long uid = msgJson.getLong("uid");
                                    if (atMeSpFinal == null || uid != AccountUtil.getUid()) break block34;
                                    channelEntranceSession.atMeMsg = atMeMsg2 = ((ChannelEntranceMsg)channelEntranceSession.getLastMessage()).getMyJoinChannelItem().getLastMsgTips();
                                    if (atMeMsg2 != null && (key2 = this.getAtMeSpKey(cid)) != null) {
                                        atMeSpFinal.edit().putString(key2, atMeMsg2.toString()).apply();
                                    }
                                    break block35;
                                }
                                catch (Exception e) {
                                    MLog.error((Object)"update unRead msg", (String)"\u89e3\u6790msg\u51fa\u73b0\u95ee\u9898 msg:%s", (Object[])new Object[]{msg});
                                }
                            }
                        }
                        if (atMeSpFinal != null && (key = this.getAtMeSpKey(cid)) != null && !TextUtils.isEmpty((CharSequence)(atMeMsg = atMeSpFinal.getString(key, "")))) {
                            channelEntranceSession.atMeMsg = atMeMsg;
                        } else {
                            if (joinChannelItem.getLastMsgType() == IMSecType.IST_CHANNEL_CALLACT.getValue()) {
                                try {
                                    ActMsg actMsg = (ActMsg)new Gson().fromJson(joinChannelItem.getLastMsgContent(), ActMsg.class);
                                    if (actMsg.uri.intValue() == Uri.UriActCreate.getValue()) {
                                        if (!SettingFlags.getBoolean((String)("k_i_l_c_a_t_i_show" + actMsg.act_create_msg.act_info.act_id), (boolean)false)) {
                                            channelEntranceSession.hasChannelActivity = true;
                                            channelEntranceSession.channelActivityName = actMsg.act_create_msg.act_info.name;
                                            channelEntranceSession.channelActivityId = actMsg.act_create_msg.act_info.act_id;
                                            break block35;
                                        } else {
                                            channelEntranceSession.hasChannelActivity = false;
                                        }
                                        break block35;
                                    }
                                    if (actMsg.uri.intValue() != Uri.UriActEnd.getValue()) {
                                        // empty if block
                                    }
                                }
                                catch (Exception e) {
                                    MLog.error((Object)"cpt", (Throwable)e);
                                }
                            }
                            if (joinChannelItem.getLastMsgType() == IMSecType.IST_SET_BULLETIN.getValue() && from != null) {
                                MLog.info((Object)TAG, (String)"check bulletin", (Object[])new Object[0]);
                                msg = joinChannelItem.getLastMsgContent();
                                try {
                                    List sectionList = from.getSections();
                                    if (sectionList == null || sectionList.isEmpty()) break block35;
                                    MLog.info((Object)TAG, (String)"check bulletin2", (Object[])new Object[0]);
                                    MsgSection section = (MsgSection)sectionList.get(0);
                                    JSONObject bulletinObj = JsonParser.obtainJSONObject((String)section.getContent());
                                    String notice = bulletinObj.optString("bulletin");
                                    String key3 = AccountUtil.getUid() + cid;
                                    if (this.announcementSp != null) {
                                        MLog.info((Object)TAG, (String)"check bulletin3", (Object[])new Object[0]);
                                        this.announcementSp.edit().putString(key3, notice).apply();
                                        channelEntranceSession.hasAnnouncement = true;
                                        channelEntranceSession.announcement = notice;
                                    }
                                }
                                catch (Exception e) {
                                    MLog.error((Object)"update unRead msg", (String)"\u89e3\u6790msg\u51fa\u73b0\u95ee\u9898 msg:%s", (Object[])new Object[]{msg});
                                }
                            }
                        }
                    }
                }
                this.updateMsgStyle(channelEntranceSession);
            }
            ChatSessionEventReporter.INSTANCE.addReportMessageTimeArrived(targetSession);
            return targetSession;
        }
        if (sUnreadOptSwitch && targetSession != null && targetSession.getUnReadCounts() != unreadNums) {
            targetSession.setUnReadCounts(unreadNums);
        }
        return targetSession;
    }

    @Override
    public void start(Environment environment, ISessionPresenter.ISessionCallback callback) {
        super.start(environment, callback);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_INVITATION_HANDLE_RESULT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_SDK_INIT_IM, (INotify)this);
        NotificationCenter.getGlobalInstance().register(ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_VERSION_UPGRADE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_DISBAND_MSG, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.GAME_TRANS_TOGGLE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_ENTERED, (INotify)this);
        this.announcementSp = SharedPreferencesUtils.INSTANCE.getSharedPreferences(environment.getContext(), "im_channel_annoucement", 4);
        this.atMeSp = SharedPreferencesUtils.INSTANCE.getSharedPreferences(environment.getContext(), "im_channel_at_me", 4);
    }

    @Override
    public void notify(Notification notification) {
        if (notification.id == NotificationIdDef.CHANNEL_INVITATION_HANDLE_RESULT && notification.extObj instanceof Boolean) {
            boolean isForeground = (Boolean)notification.extObj;
            if (isForeground) {
                this.pullMyJoinChannels(true);
            }
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && notification.extObj instanceof Boolean) {
            Boolean isForeground = (Boolean)notification.extObj;
            if (isForeground.booleanValue()) {
                this.pullMyJoinChannels(true);
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS || notification.id == NotificationDef.N_SDK_INIT_IM) {
            this.getChannelService().addConfigOrMyJoinedChannelsListener(this.mChannelListener);
            this.pullMyJoinChannels(true);
        } else if (notification.id == NotificationIdDef.CHANNEL_VERSION_UPGRADE) {
            MLog.info((Object)TAG, (String)"\u5347\u7ea7", (Object[])new Object[0]);
            this.pullMyJoinChannels(true);
        } else if (notification.id == ImNotificationDef.IM_IGNORE_SINGLE_SESSION_UNREAD) {
            if (notification.extObj instanceof String) {
                MLog.info((Object)TAG, (String)"IM_IGNORE_SINGLE_SESSION_UNREAD %s", (Object[])new Object[]{(String)notification.extObj});
                ChatSession targetSession = this.getTargetSession((String)notification.extObj);
                if (targetSession instanceof ChannelEntranceSession) {
                    long serverTimeNow = TimeUtils.getServiceRealTime();
                    long clientTimeNow = System.currentTimeMillis();
                    this.getChannelService().getMyJoinChannelHandler().updateChannelMsgUnreadData(targetSession.getSessionId(), 0L, Math.max(serverTimeNow, clientTimeNow));
                }
            }
        } else if (notification.id == NotificationIdDef.CHANNEL_DISBAND_MSG) {
            ChatSession targetSession;
            if (notification.extObj instanceof String && (targetSession = this.getTargetSession((String)notification.extObj)) instanceof ChannelEntranceSession && this.mISessionCallback != null) {
                this.mISessionCallback.deleteSession(targetSession, true);
            }
        } else if (notification.id == NotificationIdDef.GAME_TRANS_TOGGLE_CHANGE) {
            this.pullMyJoinChannels(true);
        } else if (notification.id == NotificationIdDef.CHANNEL_ENTERED) {
            String key;
            if (!(notification.extObj instanceof String)) {
                return;
            }
            String cid = (String)notification.extObj;
            this.mISessionCallback.ignoreUnRead(cid);
            ChatSession chatSession = this.getTargetSession(cid);
            if (chatSession == null) {
                return;
            }
            ChannelEntranceSession entranceSession = (ChannelEntranceSession)chatSession;
            if (entranceSession.getLastMessage() == null) {
                return;
            }
            ChannelEntranceMsg msg = (ChannelEntranceMsg)entranceSession.getLastMessage();
            MyJoinChannelItem myJoinChannelItem = msg.getMyJoinChannelItem();
            entranceSession.atMeMsg = "";
            if (this.atMeSp != null && (key = this.getAtMeSpKey(cid)) != null) {
                this.atMeSp.edit().remove(key).apply();
            }
            entranceSession.hasAnnouncement = false;
            entranceSession.announcement = "";
            if (this.announcementSp != null) {
                this.announcementSp.edit().remove(AccountUtil.getUid() + cid).apply();
            }
            try {
                MLog.debug((Object)"cpt", (String)("handleClickItem: \u9690\u85cf aid = " + entranceSession.channelActivityId + " content = " + myJoinChannelItem.getLastMsgContent()), (Object[])new Object[0]);
                entranceSession.hasChannelActivity = false;
                if (!TextUtils.isEmpty((CharSequence)myJoinChannelItem.getLastMsgContent())) {
                    String aid = null;
                    if (TextUtils.isEmpty((CharSequence)entranceSession.channelActivityId)) {
                        ActMsg actMsg = (ActMsg)new Gson().fromJson(myJoinChannelItem.getLastMsgContent(), ActMsg.class);
                        if (actMsg != null && actMsg.uri.intValue() == Uri.UriActCreate.getValue()) {
                            aid = actMsg.act_create_msg.act_info.act_id;
                        }
                    } else {
                        aid = entranceSession.channelActivityId;
                    }
                    if (!TextUtils.isEmpty((CharSequence)aid)) {
                        SettingFlags.setBoolean((String)("k_i_l_c_a_t_i_show" + aid), (boolean)true);
                        entranceSession.hasChannelActivity = false;
                    }
                }
            }
            catch (Exception e) {
                MLog.error((Object)"cpt", (Throwable)e);
            }
            this.updateMsgStyle(entranceSession);
        }
    }

    @Override
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public long getUserUid(ChatSession temp) {
        return temp.getUid();
    }

    @Override
    public SessionClzConfig getSessionClzConfig() {
        return this.mSessionClzConfig;
    }

    @Override
    public void handleClickItem(ChatSession chatSession, View v, int position, int from) {
        super.handleClickItem(chatSession, v, position, from);
        if (chatSession instanceof ChannelEntranceSession) {
            Object msg = chatSession.getLastMessage();
            MyJoinChannelItem myJoinChannelItem = null;
            if (msg instanceof ChannelEntranceMsg && (myJoinChannelItem = ((ChannelEntranceMsg)msg).getMyJoinChannelItem()) != null) {
                String thirdType = "3";
                if (myJoinChannelItem.ownerUid == AccountUtil.getUid()) {
                    thirdType = "4";
                }
                EnterParam enterChannelParams = EnterParam.of((String)myJoinChannelItem.cid).entry(27).entryInfo(new EntryInfo(FirstEntType.IM, "1", thirdType)).build();
                Message message = Message.obtain();
                message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
                message.obj = enterChannelParams;
                if (myJoinChannelItem.mPluginData != null) {
                    enterChannelParams.setExtra("pluginType", (Object)myJoinChannelItem.mPluginData.mode);
                }
                MsgDispatcher.getInstance().sendMessage(message);
                chatSession.setUnReadCounts(0);
                this.mISessionCallback.updateChannelSession(chatSession);
                MyJoinChannelItem finalMyJoinChannelItem = myJoinChannelItem;
                ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getChannel(myJoinChannelItem.cid).getDataService().getChannelBaseInfo((channelId, info) -> {
                    if (info != null) {
                        if (StringUtils.isNotEmpty((String)info.avatar)) {
                            finalMyJoinChannelItem.channelAvatar = info.avatar;
                            chatSession.setAvatarUrl(info.avatar);
                        }
                        if (StringUtils.isNotEmpty((String)info.name)) {
                            finalMyJoinChannelItem.name = info.name;
                            chatSession.setTitle(info.name);
                        }
                    }
                });
                if (myJoinChannelItem.source.equals("hago.game")) {
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "game_group_imtab_click").put("gameid", myJoinChannelItem.indieGameId));
                }
            }
        }
    }

    @Override
    public void handleLongClickItem(final ChatSession session, View v, int position, int from) {
        ArrayList<ButtonItem> buttonList = new ArrayList<ButtonItem>();
        ButtonItem deleteButton2 = this.getCommonDeleteBtnItem(() -> {
            ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "1");
            this.clearUnRead(session);
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).deleteSession(session.getSessionId());
            if (session.getLastMessage() instanceof ChannelEntranceMsg && ((ChannelEntranceMsg)session.getLastMessage()).getMyJoinChannelItem() != null) {
                SettingFlags.setBoolean((String)(LOCAL_DELETE_JOIN_CHANNEL + ((ChannelEntranceMsg)session.getLastMessage()).getMyJoinChannelItem().cid + AccountUtil.getUid()), (boolean)true);
            }
        });
        ButtonItem ignoreButton2 = new ButtonItem(ResourceUtils.getString((int)R.string.tips_ignore), new ButtonItem.OnClickListener(){

            public void onClick() {
                ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, "2");
                ChannelEntranceSessionPresenter.this.clearUnRead(session);
            }
        });
        if (session instanceof SingleChatSession || session instanceof ChannelEntranceSession) {
            buttonList.add(deleteButton2);
            if (session.getUnReadCounts() > 0) {
                buttonList.add(ignoreButton2);
            }
            if (session instanceof ChannelEntranceSession) {
                ButtonItem stickTopButton = new ButtonItem(ResourceUtils.getString((int)(session.isStickTop() ? R.string.btn_msg_cancel_stick_top : R.string.btn_msg_stick_top)), () -> {
                    boolean stickTop = !session.isStickTop();
                    session.setStickTop(stickTop);
                    session.setPresentationTime(System.currentTimeMillis());
                    session.setPresentWeight(stickTop ? 5 : 0);
                    this.mISessionCallback.updateChannelSession(session);
                    ChatSessionEventReporter.INSTANCE.reportLongPressClick(session, session.isStickTop() ? "10" : "9");
                });
                buttonList.add(stickTopButton);
            }
        } else if (session instanceof ChannelNoticeEntranceSession) {
            buttonList.add(deleteButton2);
        } else if (session.getUnReadCounts() > 0) {
            buttonList.add(ignoreButton2);
        } else {
            return;
        }
        this.mDialogLinkManager.showCommonPopupDialog(buttonList, true, true);
    }

    @MainThread
    public void pageVisibilityChanged(boolean visible) {
        if (visible == this.isPageShow) {
            return;
        }
        this.isPageShow = visible;
        this.onPageVisibilityChanged();
    }

    private void onPageVisibilityChanged() {
        if (this.isPageShow) {
            this.updateChannelStatus();
        }
    }

    public void updateChannelMsgMointer(boolean open) {
        if (this.mKeepMonitor) {
            MLog.debug((Object)TAG, (String)"updateChannelMsgMointer mKeepMonitor return!!!!!", (Object[])new Object[0]);
            return;
        }
        MLog.debug((Object)TAG, (String)"updateChannelMsgMointer open: %s", (Object[])new Object[]{open});
        if (this.getChannelService() == null) {
            if (SystemUtils.isShowEnvSetting()) {
                throw new RuntimeException("channelService not found");
            }
            return;
        }
        if (open) {
            this.getChannelService().getMyJoinChannelHandler().startRefreshUnreadNum(3, 5000L);
        } else {
            this.getChannelService().getMyJoinChannelHandler().stopRefreshUnreadNum(3);
        }
    }

    public void updateChannelMsgKeep(boolean keep) {
        MLog.debug((Object)TAG, (String)"updateChannelMsgKeep keep: %s", (Object[])new Object[]{keep});
        this.mKeepMonitor = keep;
    }

    @Override
    public void onLoadDataFinish(List<ChatSession> stranger, final List<ChatSession> normal) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!FP.empty((Collection)normal)) {
                    ArrayList normalCopy = new ArrayList(normal);
                    Object object = ChannelEntranceSessionPresenter.this.listLock;
                    synchronized (object) {
                        for (ChatSession next : normalCopy) {
                            if (!(next instanceof ChannelEntranceSession)) continue;
                            ChannelEntranceSessionPresenter.this.mShowingJoinChannels.add((ChannelEntranceSession)next);
                        }
                    }
                }
                ChannelEntranceSessionPresenter.this.mHasUpdateShows = true;
                ChannelEntranceSessionPresenter.this.checkDeleteNotJoinChannel();
            }
        });
        if (ServiceManagerProxy.getServiceManager() != null) {
            ServiceManagerProxy.getServiceManager().observeService(IFamilyLuckyBagService.class, IFamilyLuckyBagService::tryRequestLuckyBagActivityState);
        }
    }

    private void checkDeleteNotJoinChannel() {
        if (this.mISessionCallback == null) {
            MLog.info((Object)TAG, (String)"checkDeleteNotJoinChannel mHasUpdateShow:%b,mHasPullMyJoinChannel:%b, callback is Null!", (Object[])new Object[]{this.mHasUpdateShows, this.mHasPullMyJoinChannel});
        } else {
            MLog.info((Object)TAG, (String)"checkDeleteNotJoinChannel mHasUpdateShow:%b,mHasPullMyJoinChannel:%b", (Object[])new Object[]{this.mHasUpdateShows, this.mHasPullMyJoinChannel});
        }
        if (this.mHasUpdateShows && this.mHasPullMyJoinChannel && this.mISessionCallback != null) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ChannelEntranceSessionPresenter.this.listLock;
                    synchronized (object) {
                        HashSet<ChatSession> removes = new HashSet<ChatSession>();
                        for (final ChatSession next : ChannelEntranceSessionPresenter.this.mShowingJoinChannels) {
                            if (next == null || ChannelEntranceSessionPresenter.this.mJoinChannels.contains(next.getSessionId())) continue;
                            removes.add(next);
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"checkDeleteNotJoinChannel remove:%s", (Object[])new Object[]{next.getSessionId()});
                                    if (sUnreadOptSwitch) {
                                        ChannelEntranceSessionPresenter.this.mISessionCallback.deleteSession(next, true, false);
                                    } else {
                                        ChannelEntranceSessionPresenter.this.mISessionCallback.deleteSession(next, false);
                                    }
                                }
                            });
                        }
                        if (sUnreadOptSwitch) {
                            for (final ChatSession next : ChannelEntranceSessionPresenter.this.mISessionCallback.getChannelSessions()) {
                                if (next == null || ChannelEntranceSessionPresenter.this.mJoinChannels.contains(next.getSessionId())) continue;
                                removes.add(next);
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)"checkDeleteNotJoinChannel remove:%s", (Object[])new Object[]{next.getSessionId()});
                                        ChannelEntranceSessionPresenter.this.mISessionCallback.deleteSession(next, true, false);
                                    }
                                });
                            }
                        }
                        ChannelEntranceSessionPresenter.this.mShowingJoinChannels.removeAll(removes);
                    }
                }
            });
        }
    }

    public void updateChannelStatus() {
        if (!this.isPageShow) {
            return;
        }
        this.statusUpdateExecutor.execute(() -> {
            MLog.info((Object)TAG, (String)"refresh channel status", (Object[])new Object[0]);
            ArrayList<String> requestCid = new ArrayList<String>();
            if (this.mJoinChannels.isEmpty()) {
                ArrayList joinedChannel = this.getChannelService().getMyJoinedChannels(null, false);
                for (MyJoinChannelItem channel : joinedChannel) {
                    if (TextUtils.isEmpty((CharSequence)channel.cid)) continue;
                    requestCid.add(channel.cid);
                }
            } else {
                Object object = this.listLock;
                synchronized (object) {
                    requestCid.addAll(this.mJoinChannels);
                }
            }
            ((IChannelCenterService)Objects.requireNonNull(ServiceManagerProxy.getService(IChannelCenterService.class))).queryChannelPluginStatus(requestCid, (ICommonCallback)new ICommonCallback<List<RoomPlugin>>(){

                public void onSuccess(List<RoomPlugin> roomPlugins, Object ... ext) {
                    for (RoomPlugin room : roomPlugins) {
                        String cid = room.getCid();
                        String pid = room.getPid();
                        ChatSession rawSession = ChannelEntranceSessionPresenter.this.getTargetSession(cid);
                        if (!(rawSession instanceof ChannelEntranceSession)) continue;
                        ChannelEntranceSession session = (ChannelEntranceSession)rawSession;
                        ChannelEntranceSessionPresenter.this.updateMsgStyle(session);
                        if (pid.equals(session.getPid())) continue;
                        session.setPid(pid);
                        ChannelEntranceSessionPresenter.this.mISessionCallback.updateChannelSession(session);
                        MLog.info((Object)ChannelEntranceSessionPresenter.TAG, (String)("update channel status cid " + cid + " " + pid), (Object[])new Object[0]);
                    }
                }

                public void onFail(int errCode, String msg, Object ... ext) {
                }
            });
            YYTaskExecutor.execute(this::updateChannelStatus, (long)30000L);
        });
    }

    public void getTempChannelChatInfo(MyJoinChannelItem joinChannelItem) {
        this.getChannelService().getTempChannelChatInfo(joinChannelItem, new ITempChannelChat(){

            public void onSuccess(@NotNull MyJoinChannelItem joinChannelItemRes, @NotNull LastMsgAndUnreadData data2) {
                ChatSession chatSession = ChannelEntranceSessionPresenter.this.updateUnReadMsg(joinChannelItemRes.cid, (int)data2.unreadMsgNum, data2.lastMsg, joinChannelItemRes);
                if (chatSession != null) {
                    ChannelEntranceSessionPresenter.this.mISessionCallback.updateChannelSession(chatSession);
                }
            }
        });
    }

    public void updateMsgStyle(ChannelEntranceSession session) {
        if (!TextUtils.isEmpty((CharSequence)session.atMeMsg)) {
            session.setMsgStyle(ChannelEntranceSession.MsgStyle.AT_ME);
        } else if (session.hasChannelActivity) {
            session.setMsgStyle(ChannelEntranceSession.MsgStyle.ACTIVITY);
        } else if (session.hasAnnouncement) {
            session.setMsgStyle(ChannelEntranceSession.MsgStyle.ANNOUNCEMENT);
        } else if (!TextUtils.isEmpty((CharSequence)session.getPid())) {
            session.setMsgStyle(ChannelEntranceSession.MsgStyle.CHANNEL_STATE);
        } else {
            session.setMsgStyle(ChannelEntranceSession.MsgStyle.NONE);
        }
    }

    @Nullable
    private String getAtMeSpKey(String cid) {
        long uid = AccountUtil.getUid();
        if (uid != 0L) {
            return AccountUtil.getUid() + cid;
        }
        return null;
    }
}

