/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.protocol;

import android.content.SharedPreferences;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;

public enum MsgProtocolSwitch {
    INSTANCE;

    private static final String TAG = "[Hago-CIM]";
    private boolean mIsSwitch = true;
    private boolean hasFetch = false;

    public boolean isSwitch() {
        return this.mIsSwitch;
    }

    public void setIsSwitch(boolean isUserCim) {
        MLog.info((Object)TAG, (String)("set is switch to cim:" + (isUserCim ? "true" : "false")), (Object[])new Object[0]);
        this.mIsSwitch = isUserCim;
        this.hasFetch = true;
        CIMStorage.INSTANCE.storeSwitch(this.mIsSwitch);
    }

    public boolean loadSwitch(long uid) {
        this.mIsSwitch = CIMStorage.INSTANCE.load(uid);
        MLog.info((Object)TAG, (String)("load is switch to cim:" + (this.mIsSwitch ? "true" : "false") + " for uid:" + uid), (Object[])new Object[0]);
        return this.mIsSwitch;
    }

    public boolean hasFetch() {
        return this.hasFetch;
    }

    protected static enum CIMStorage {
        INSTANCE;

        private static final String TAG = "[Hago-CIM]";
        private static SharedPreferences sPrefStorage;
        private static final String KeyPersonalSwitch = "cim_switch";

        public boolean load(long uid) {
            String prefKey = String.format("im_adapter_%d", uid);
            sPrefStorage = RuntimeContext.sApplicationContext.getSharedPreferences(prefKey, 0);
            return sPrefStorage.getBoolean(KeyPersonalSwitch, false);
        }

        public void storeSwitch(boolean isSwitch) {
            if (sPrefStorage == null) {
                MLog.error((Object)"[Hago-CIM]", (String)"Missing cim adapter user context", (Object[])new Object[0]);
                return;
            }
            SharedPreferences.Editor editor = sPrefStorage.edit();
            editor.putBoolean(KeyPersonalSwitch, isSwitch);
            editor.apply();
        }

        static {
            sPrefStorage = null;
        }
    }
}

