/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.NonNull;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerRechargeWarning
extends IImMsgParse {
    private IMsgParseCtlCallback callback;

    public MsgInnerRechargeWarning(IMsgParseCtlCallback callback) {
        this.callback = callback;
    }

    @Override
    @NonNull
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (msgJson != null) {
            JSONObject contentJson = msgJson.optJSONObject("recharge_warn");
            String pushPayload = item.getPushPayload();
            JSONObject json = null;
            String pushType = null;
            try {
                json = JsonParser.obtainJSONObject((String)pushPayload);
                pushType = json.optString("push_source");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            String tittle = contentJson.optString("im_msg");
            String content = contentJson.optString("im_content");
            String pushTittle = contentJson.optString("notify_title");
            String pushContent = contentJson.optString("notify_content");
            long unsealTime = contentJson.optLong("unseal_time", 0L);
            messageBuilder.content(tittle).reportTime(unsealTime).sendTime(item.getSendTime()).clientSendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).contentType(12).uid(10L).reportTitle(pushTittle).reportContent(pushContent).msgType(28).reserve1(content);
            SettingFlags.setBoolean((String)"key_recharge_warning", (boolean)true);
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_HOME_PROMPT_SHOWN);
            if (this.callback != null) {
                this.callback.showNotification(item, pushType, false);
            }
        }
        return messageBuilder;
    }
}

