/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.R;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerRecharge
extends IImMsgParse {
    private static final String TAG = "MsgInnerRecharge";
    private IMsgParseCtlCallback callback;

    public MsgInnerRecharge(IMsgParseCtlCallback callback) {
        this.callback = callback;
    }

    @Override
    @NonNull
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        if (msgJson != null) {
            try {
                MLog.info((Object)TAG, (String)"parseMsg msgJson=%s", (Object[])new Object[]{msgJson});
                JSONObject contentJson = msgJson.optJSONObject("recharge");
                String pushPayload = item.getPushPayload();
                JSONObject json = null;
                String pushType = null;
                try {
                    json = JsonParser.obtainJSONObject((String)pushPayload);
                    pushType = json.optString("push_source");
                }
                catch (JSONException e) {
                    MLog.info((Object)TAG, (String)"parseMsg %s", (Object[])new Object[]{e});
                }
                String orderId = contentJson.optString("order_id");
                String payChannel = contentJson.optString("pay_channel");
                int status = contentJson.optInt("status");
                Double currencyAmount = contentJson.optDouble("currency_amount", 0.0);
                Double amount = contentJson.optDouble("amount", 0.0);
                long createTime = contentJson.optLong("create_time", 0L);
                long finishTime = contentJson.optLong("finish_time", 0L);
                int currencyType = contentJson.optInt("currency_type", 0);
                boolean isShowAmount = contentJson.optBoolean("is_show_amount", false);
                String expand = contentJson.optString("expand", "");
                Double unitPrice = 0.0;
                String srcCurrencySymbol = "";
                String realPayChannel = "";
                try {
                    JSONObject expandJSONObject = JsonParser.obtainJSONObject((String)expand);
                    unitPrice = expandJSONObject.optDouble("unitPrice", 0.0);
                    srcCurrencySymbol = expandJSONObject.optString("srcCurrencySymbol", "");
                    realPayChannel = expandJSONObject.optString("realPayChannel", "");
                }
                catch (JSONException e) {
                    MLog.info((Object)TAG, (String)"expandJSONObject %s", (Object[])new Object[]{e});
                }
                if (TextUtils.isEmpty((CharSequence)srcCurrencySymbol)) {
                    unitPrice = amount;
                }
                if (TextUtils.isEmpty((CharSequence)realPayChannel)) {
                    realPayChannel = payChannel;
                }
                messageBuilder.uid(item.getFromUid()).sessionId(item.getSessionId()).msgType(26).contentType(1).chatType(1).status(0).clientSendTime(item.getSendTime()).toUserId(item.getFromUid()).orderDiamondNum((long)currencyAmount.intValue()).orderState(status).sendTime(item.getSendTime()).orderCurrencySymbol(srcCurrencySymbol).content(String.format(ResourceUtils.getString((int)R.string.short_tip_recharge_receipt), new Object[0])).rechargeOrderId(orderId).rechargePrice(unitPrice.doubleValue()).orderTime(createTime).channelId(realPayChannel).reverseInt1(2).reverse1(isShowAmount + "");
            }
            catch (Exception e) {
                MLog.info((Object)TAG, (String)"parseMsg %s", (Object[])new Object[]{e});
            }
        }
        return messageBuilder;
    }
}

