/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerPush
extends IImMsgParse {
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerPush(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        String pushPayload = item.getPushPayload();
        JSONObject json = null;
        try {
            json = JsonParser.obtainJSONObject((String)pushPayload);
            String pushType = json.optString("push_source");
            if (json.has("display_front")) {
                boolean isShowForeground = json.optBoolean("display_front");
                this.ctlCallback.showNotification(item, pushType, isShowForeground);
            } else {
                this.ctlCallback.showNotification(item, pushType, false);
            }
        }
        catch (JSONException e) {
            MLog.error((Object)this.TAG, (Throwable)e);
        }
        return null;
    }
}

