/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Message;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.game.base.bean.CheckGoinConifg;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import com.yy.im.utils.TimeUtils;
import ikxd.msg.MsgInnerType;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerPK
extends IImMsgParse {
    private static final int GAME_VERSION_FACTOR = 10000;
    private static final int PK_INVITE_OUT_OF_TIME = 30000;
    private IMsgParseCtlCallback ctlCallback;
    private GameLifeWrapper mGameLifeWrapper = new GameLifeWrapper(){

        public void onPreloadGame(GamePlayContext context) {
            super.onPreloadGame(context);
            MsgInnerPK.this.ctlCallback.removeAiInviteRunnable();
            IGameCenterService iGameCenterService = (IGameCenterService)MsgInnerPK.this.ctlCallback.getServiceManager().getService(IGameCenterService.class);
            if (iGameCenterService != null) {
                iGameCenterService.unRegisterGameLifecycle((IGameLifecycle)this);
                MLog.info((Object)MsgInnerPK.this.TAG, (String)"unRegisterGameLifecycle", (Object[])new Object[0]);
            }
        }
    };

    public MsgInnerPK(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(final MsgData item) {
        MLog.info((Object)this.TAG, (String)"\u63a5\u6536\u5230\u9080\u8bf7", (Object[])new Object[0]);
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        JSONObject payloadJson = (JSONObject)pair.second;
        long currentTime = TimeUtils.getCurrentTime();
        int testType = -1;
        long inviteTime = payloadJson.optLong("inviteTime");
        if (inviteTime <= 0L) {
            inviteTime = item.getSendTime();
        }
        if (payloadJson != null && payloadJson.has("test_type")) {
            testType = payloadJson.optInt("test_type");
            if (testType == 1) {
                this.requestAiGameInvite(inviteTime, item.getFromUid());
            }
            MLog.info((Object)this.TAG, (String)"test_type = %d", (Object[])new Object[]{testType});
        }
        MLog.info((Object)this.TAG, (String)("\u63a5\u6536\u5230\u9080\u8bf7\u7684\u670d\u52a1\u7aef\u65f6\u95f4:" + inviteTime + ", \u5ba2\u6237\u7aef\u7684\u65f6\u95f4:" + currentTime), (Object[])new Object[0]);
        if (payloadJson != null && currentTime - inviteTime < 30000L) {
            MLog.info((Object)this.TAG, (String)"\u662f\u6709\u6548\u6e38\u620f\u9080\u8bf7", (Object[])new Object[0]);
            final GameMessageModel gameMessageModel = ImMsgUtils.initGameMessageModel((JSONObject)payloadJson, (int)0, (long)inviteTime);
            gameMessageModel.setSource(msgJson.optInt("source"));
            if (this.ctlCallback.getServiceManager().getService(IGameInfoService.class) != null) {
                GameInfo gameInfo = ((IGameInfoService)this.ctlCallback.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameMessageModel.getGameId());
                if (gameInfo == null) {
                    MLog.info((Object)this.TAG, (String)"Dont have gameId=%s", (Object[])new Object[]{gameMessageModel.getGameId()});
                    YYTaskExecutor.execute(() -> {
                        ImMsgReqParam gameInvalidMsg = ImDataFactory.INSTANCE.sendGameInvalidMsg(gameMessageModel.getFromUserId(), gameMessageModel.getGameId(), gameMessageModel.getGameName(), gameMessageModel.getPkId());
                        ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(gameInvalidMsg, null);
                    });
                } else {
                    int myGameVersion = this.getGameVersion(gameInfo.getModulerVer());
                    int otherGameVersion = this.getGameVersion(String.valueOf(gameMessageModel.getGameVersion()));
                    if (gameMessageModel.getGameVersion() == 0 || myGameVersion == otherGameVersion) {
                        boolean isGoldGame = gameMessageModel.isGoldGame();
                        final Runnable runnable2 = new Runnable(){

                            @Override
                            public void run() {
                                if (gameMessageModel.getGameTimeLimitType() == 1 || gameMessageModel.getGameTimeLimitType() == 2) {
                                    MsgInnerPK.this.getGameInviteMsgAndNotify(item);
                                }
                                MLog.info((Object)MsgInnerPK.this.TAG, (String)"\u901a\u77e5\u5230\u4e0a\u5c42", (Object[])new Object[0]);
                                MsgInnerPK.this.ctlCallback.showNotification(item, "2", false);
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        Message pushMsg = Message.obtain();
                                        pushMsg.what = BaseMsgDef.NOTIFY_RECEIVE_PK;
                                        pushMsg.obj = gameMessageModel;
                                        MsgDispatcher.getInstance().sendMessage(pushMsg);
                                    }
                                });
                                if ((gameMessageModel.getGameTimeLimitType() == 1 || gameMessageModel.getGameTimeLimitType() == 2) && MsgInnerPK.this.ctlCallback.getServiceManager().getService(IGameInviteService.class) != null) {
                                    ((IGameInviteService)MsgInnerPK.this.ctlCallback.getServiceManager().getService(IGameInviteService.class)).receiveGameInviteMsg(gameMessageModel, 2);
                                }
                            }
                        };
                        MLog.info((Object)this.TAG, (String)"on receive game invite msg,isGoldGame:%b", (Object[])new Object[]{isGoldGame});
                        if (isGoldGame) {
                            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_CHECK_SELF_COIN_ENOUGH, -1, -1, (Object)new CheckGoinConifg((ICommonCallback)new ICommonCallback<CheckGoinConifg>(){

                                public void onSuccess(CheckGoinConifg o, Object ... ext) {
                                    if (o != null && o.status == 1) {
                                        runnable2.run();
                                    }
                                    MLog.info((Object)MsgInnerPK.this.TAG, (String)"check self coin finish,data:%s", (Object[])new Object[]{o});
                                }

                                public void onFail(int errCode, String msg, Object ... ext) {
                                    MLog.info((Object)MsgInnerPK.this.TAG, (String)"check self coin fail,code:%d, msg:%s", (Object[])new Object[]{errCode, msg});
                                }
                            }, gameInfo, 3));
                        } else {
                            runnable2.run();
                        }
                    } else {
                        MLog.info((Object)this.TAG, (String)"\u6536\u5230\u4e0d\u517c\u5bb9\u7248\u672c\u7684\u6e38\u620f:%s\uff0c\u81ea\u5df1\u7684\u7248\u672c:%s, \u5bf9\u65b9\u7684\u7248\u672c:%s", (Object[])new Object[]{gameInfo.getGname(), String.valueOf(myGameVersion), String.valueOf(otherGameVersion)});
                        if (this.ctlCallback.getServiceManager().getService(IGameInviteService.class) != null) {
                            ((IGameInviteService)this.ctlCallback.getServiceManager().getService(IGameInviteService.class)).receiveIncompatibleMsg();
                            YYTaskExecutor.execute(() -> {
                                ImMsgReqParam gamePair = ImDataFactory.INSTANCE.sendGameIncompatibleMsg(item.getFromUid(), gameInfo.getGid(), gameInfo.getGname(), gameMessageModel.getPkId(), gameInfo.getModulerVer());
                                ((ImService)this.ctlCallback.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(gamePair, null);
                            });
                        }
                    }
                }
            }
        }
        return MessageBuilder.newInstance();
    }

    private void requestAiGameInvite(long sendTime, long fromUid) {
        long inviteOverTime = System.currentTimeMillis() - sendTime;
        if (inviteOverTime < 0L) {
            return;
        }
        long delayTime = 0L;
        delayTime = inviteOverTime > 30000L ? 30000L : 30000L - inviteOverTime + 5000L;
        this.ctlCallback.startAiInviteTask(fromUid, inviteOverTime > 30000L, delayTime);
        IGameCenterService iGameCenterService = (IGameCenterService)this.ctlCallback.getServiceManager().getService(IGameCenterService.class);
        if (iGameCenterService != null) {
            iGameCenterService.registerGameLifecycle((IGameLifecycle)this.mGameLifeWrapper);
        }
    }

    private int getGameVersion(String gameVersion) {
        try {
            int version = Integer.parseInt(gameVersion);
            return version / 10000;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private void getGameInviteMsgAndNotify(MsgData item) {
        try {
            if (item == null) {
                return;
            }
            JSONObject msgJson = JsonParser.obtainJSONObject((String)item.getMsg());
            JSONObject payloadJson = JsonParser.obtainJSONObject((String)msgJson.optString("payload"));
            long type = item.getMsgInnertype();
            if (type == (long)MsgInnerType.kMsgInnerPK.getValue() || type == (long)MsgInnerType.kMsgInnerIndependentGameInvite.getValue()) {
                GameMessageModel model2 = ImMsgUtils.initGameMessageModel((JSONObject)payloadJson, (int)0);
                if (model2.getShadowUid() != 0L) {
                    MLog.info((Object)this.TAG, (String)"getGameInviteMsgAndNotify ignore, has shadowUid: %d, ai: %d", (Object[])new Object[]{model2.getShadowUid(), model2.getFromUserId()});
                    return;
                }
                final ImMessageDBBean imMessage = MessageBuilder.newInstance().clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).contentType(6).uid(item.getFromUid()).extObj((Object)model2).fromDiscoveryPage(msgJson.optBoolean("isFromDiscoveryChange", false)).builder();
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_RECEIVE_SINGLE_MESSAGE, (Object)imMessage));
                    }
                });
            }
        }
        catch (JSONException e) {
            MLog.error((Object)this.TAG, (Throwable)e);
        }
    }
}

