/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.R;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerImImgIllegalNotify
extends IImMsgParse {
    private static final String TAG = "MsgInnerImImgIllegalNotify";
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerImImgIllegalNotify(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        JSONObject postObject = msgJson.optJSONObject("notify");
        if (postObject != null) {
            String imgUrl = postObject.optString("illegal_image");
            String violatingMsg = postObject.optString("violating_tips");
            this.updateImMsg(imgUrl, violatingMsg);
        }
        String pushPayload = item.getPushPayload();
        JSONObject json = null;
        if (!TextUtils.isEmpty((CharSequence)pushPayload)) {
            try {
                json = JsonParser.obtainJSONObject((String)pushPayload);
                String pushType = json.optString("push_source");
                if (json.has("display_front")) {
                    boolean isShowForeground = json.optBoolean("display_front");
                    this.ctlCallback.showNotification(item, pushType, isShowForeground);
                } else {
                    this.ctlCallback.showNotification(item, pushType, false);
                }
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return messageBuilder;
    }

    private void updateImMsg(String imgUrl, String violatingMsg) {
        MyBox box2;
        if (TextUtils.isEmpty((CharSequence)imgUrl)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)violatingMsg)) {
            violatingMsg = ResourceUtils.getString((int)R.string.tips_im_img_violating);
        }
        if ((box2 = ((IDBService)this.ctlCallback.getServiceManager().getService(IDBService.class)).boxForCurUser(ImMessageDBBean.class)) == null) {
            return;
        }
        String finalViolatingMsg = violatingMsg;
        box2.getAll(dbList -> {
            if (dbList != null && dbList.size() > 0) {
                for (Object data2 : dbList) {
                    ImMessageDBBean msg = (ImMessageDBBean)data2;
                    if (msg.getContentType() != 2 || msg.getMsgType() != 0) continue;
                    String content = msg.getContent();
                    if (msg.getStatus() == 3 || !StringUtils.equal((String)imgUrl, (String)content)) continue;
                    msg.setStatus(3);
                    msg.setViolatingMsg(finalViolatingMsg);
                    box2.updateItem((BaseDBBean)msg, false);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationDef.IM_UPDATE_MSG, (Object)msg));
                }
            }
        });
    }
}

