/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerGamePublic
extends IImMsgParse {
    private static final String TAG = "MsgInnerGamePublic";
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerGamePublic(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        JSONObject gameObject = msgJson.optJSONObject("game");
        if (gameObject != null) {
            String gameId = gameObject.optString("gameid");
            String msgId = gameObject.optString("msgid");
            String said = gameObject.optString("said");
            String text = gameObject.optString("text");
            MLog.info((Object)TAG, (String)"gameId=%s, msgId=%s, said=%s, text=%s", (Object[])new Object[]{gameId, msgId, said, text});
            if (!StringUtils.isEmpty((String)gameId) && !StringUtils.isEmpty((String)text)) {
                messageBuilder.content(text).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).msgType(37).uid(item.getFromUid()).reverse1(gameId).reverse2(said).reverse3(msgId);
            }
        }
        String pushPayload = item.getPushPayload();
        JSONObject json = null;
        try {
            json = JsonParser.obtainJSONObject((String)pushPayload);
            String pushType = json.optString("push_source");
            if (json.has("display_front")) {
                boolean isShowForeground = json.optBoolean("display_front");
                this.ctlCallback.showNotification(item, pushType, isShowForeground);
            } else {
                this.ctlCallback.showNotification(item, pushType, false);
            }
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return messageBuilder;
    }
}

