/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Bundle;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.notify.NotifyPushToastInfo;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MsgInnerFloating
extends IImMsgParse {
    private static final String TAG = "MsgInnerFloating";
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerFloating(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Msg msg;
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"MsgInnerImGift item: %s", (Object[])new Object[]{item});
        }
        if ((msg = this.parseJson(item.getMsg())) != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MsgInnerFloating.this.showFloatNotify(msg);
                }
            });
        }
        return null;
    }

    private Msg parseJson(String json) {
        try {
            Msg msg = (Msg)JsonParser.parseJsonObject((String)json, Msg.class);
            return msg;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    private void showFloatNotify(@NonNull Msg msg) {
        if (msg.floating == null) {
            MLog.error((Object)TAG, (String)"showFloatNotify floating is null ", (Object[])new Object[0]);
            return;
        }
        Floating floating = msg.floating;
        Message pushMsg = Message.obtain();
        pushMsg.what = BaseMsgDef.MSG_SHOW_NOTIFY_TOAST;
        NotifyPushToastInfo info = new NotifyPushToastInfo();
        info.addShieldWindow(this.windowBlack(msg.floating.androidBlackList));
        info.setJumpType(10000);
        info.setPushType(10000);
        info.setJumpUri(floating.jumpUri);
        info.setImgUrl(floating.iconUrl);
        info.setPushTittle(floating.title);
        info.setPushContent((CharSequence)floating.desc);
        info.setButtonText(floating.righBtnTxt);
        info.setSource(msg.source);
        Bundle bundle = new Bundle();
        bundle.putSerializable("base_toast_info_type", (Serializable)info);
        pushMsg.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(pushMsg);
    }

    private List<Integer> windowBlack(List<String> list) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        if (!FP.empty(list)) {
            for (String id2 : list) {
                int idInt = StringUtils.parseInt((String)id2);
                if (idInt <= 0) continue;
                arr.add(idInt);
            }
        }
        return arr;
    }

    private static class Floating {
        @SerializedName(value="iconUrl")
        String iconUrl;
        @SerializedName(value="title")
        String title;
        @SerializedName(value="desc")
        String desc;
        @SerializedName(value="righBtnTxt")
        String righBtnTxt;
        @SerializedName(value="bizID")
        String bizID;
        @SerializedName(value="jumpUri")
        String jumpUri;
        @SerializedName(value="androidBlackList")
        List<String> androidBlackList;

        private Floating() {
        }
    }

    private static class Msg {
        @SerializedName(value="payload")
        String payload;
        @SerializedName(value="floating")
        Floating floating;
        @SerializedName(value="source")
        int source;

        private Msg() {
        }
    }
}

