/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.parse.item;

import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.MessageBuilder;
import com.yy.im.parse.IImMsgParse;
import com.yy.im.parse.IMsgParseCtlCallback;
import com.yy.im.utils.ActionUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MsgInnerBbsNotice
extends IImMsgParse {
    private static final String TAG = "MsgInnerBbsNotice";
    private IMsgParseCtlCallback ctlCallback;

    public MsgInnerBbsNotice(IMsgParseCtlCallback ctlCallback) {
        this.ctlCallback = ctlCallback;
    }

    @Override
    @Nullable
    public MessageBuilder parseMsg(MsgData item) {
        Pair pair = ImMsgUtils.parseMsgJson((String)item.getMsg());
        JSONObject msgJson = (JSONObject)pair.first;
        MessageBuilder messageBuilder = MessageBuilder.newInstance();
        JSONObject postObject = msgJson.optJSONObject("post");
        MLog.info((Object)TAG, (String)"parseMsg %s", (Object[])new Object[]{postObject.toString()});
        messageBuilder.content(postObject.toString()).clientSendTime(item.getSendTime()).sendTime(item.getSendTime()).sendByMe(false).msgId(StringUtils.parseLong((String)item.getSeq())).sessionId(item.getSessionId()).msgType(42).uid(item.getFromUid());
        String pushPayload = item.getPushPayload();
        JSONObject json = null;
        String pushSource = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)pushPayload)) {
                json = JsonParser.obtainJSONObject((String)pushPayload);
                pushSource = json.optString("push_source");
                if (json.has("display_front")) {
                    boolean isShowForeground = json.optBoolean("display_front");
                    this.ctlCallback.showNotification(item, pushSource, isShowForeground);
                } else {
                    this.ctlCallback.showNotification(item, pushSource, false);
                }
                messageBuilder.source(Integer.parseInt(pushSource));
            }
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (String)"MsgInnerBbsNotice error:%s", (Object[])new Object[]{pushPayload});
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (ActionUtils.isIsPushAction()) {
            ActionUtils.setIsPushAction(false);
            return messageBuilder;
        }
        if (RuntimeContext.sIsForeground && StringUtils.isNotEmpty((String)item.getPushContent()) && StringUtils.isNotEmpty((String)item.getPushTitle())) {
            String finalPushSource = pushSource;
            YYTaskExecutor.postToMainThread(() -> {
                try {
                    Message msg = Message.obtain();
                    msg.what = BaseMsgDef.MSG_BBS_TYPE;
                    Bundle bundle = new Bundle();
                    bundle.putString("content", item.getPushContent());
                    bundle.putString("avatar", item.getAvatar());
                    bundle.putString("title", item.getPushTitle());
                    bundle.putInt("sex", postObject.getInt("sex"));
                    bundle.putLong("uid", postObject.getLong("uid"));
                    bundle.putString("ppostid", postObject.getString("ppostid"));
                    bundle.putString("postid", postObject.getString("postid"));
                    bundle.putInt("posttype", postObject.getInt("posttype"));
                    bundle.putInt("ppostsource", postObject.optInt("ppostsource"));
                    bundle.putString("channelid", postObject.optString("channelid"));
                    bundle.putInt("jumpType", 0);
                    bundle.putInt("bbsType", postObject.has("users") && postObject.getJSONArray("users").length() > 0 || postObject.getInt("type") == 0 ? 1 : 0);
                    bundle.putInt("ptype", postObject.optInt("ptype", 0));
                    bundle.putInt("notice_type", postObject.optInt("notice_type", 0));
                    bundle.putString("push_source", finalPushSource);
                    msg.obj = bundle;
                    MsgDispatcher.getInstance().sendMessage(msg);
                }
                catch (JSONException e) {
                    MLog.error((Object)"", (Throwable)e);
                }
            });
        }
        return messageBuilder;
    }
}

