/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.bbs.base.bean.postinfo.BasePostInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.im.IMPostData;
import com.yy.hiyo.im.IMPostUtils;
import com.yy.hiyo.im.Utils;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.data.ImGameCardInfo;
import com.yy.im.module.room.post.PostItemVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class ChatMessageDataGenerator {
    private static volatile AtomicLong id = new AtomicLong(-1000L);

    public static ChatMessageData generateProfileData(long myUid, long targetUid) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setUid(targetUid);
        message.setSessionId(Utils.getSessionId((long)myUid, (long)targetUid));
        message.setSendTime(System.currentTimeMillis());
        message.setFromType(0);
        message.setMsgType(3);
        message.setStatus(0);
        message.setClientSendTime(System.currentTimeMillis());
        return new ChatMessageData(message);
    }

    public static ImMessageDBBean generateMathTimeMessage(long myUid, long targetUid, String nickName, long matchTime) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setUid(targetUid);
        message.setSessionId(Utils.getSessionId((long)myUid, (long)targetUid));
        message.setSendTime(System.currentTimeMillis());
        message.setFromType(0);
        message.setMsgType(16);
        message.setStatus(0);
        message.setClientSendTime(System.currentTimeMillis());
        if (null == nickName) {
            nickName = "";
        }
        String timeTip = ChatMessageDataGenerator.getMatchTimeTip(matchTime);
        String finalTip = StringUtils.format((String)ResourceUtils.getString((int)R.string.tip_wemeet_match_time), (Object[])new Object[]{nickName, timeTip});
        message.setExtObj((Object)finalTip);
        return message;
    }

    public static ImMessageDBBean generateMathTimeMessage(long myUid, long targetUid, String nickName) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setUid(targetUid);
        message.setSessionId(Utils.getSessionId((long)myUid, (long)targetUid));
        message.setSendTime(System.currentTimeMillis());
        message.setFromType(0);
        message.setMsgType(16);
        message.setStatus(0);
        message.setClientSendTime(System.currentTimeMillis());
        if (null == nickName) {
            nickName = "";
        }
        String finalTip = StringUtils.format((String)ResourceUtils.getString((int)R.string.short_summary_wemeet_im_match_tip), (Object[])new Object[]{nickName});
        message.setExtObj((Object)finalTip);
        return message;
    }

    private static String getMatchTimeTip(long matchTime) {
        long minute = 60L;
        long hour = 3600L;
        long day = 86400L;
        long month = 2592000L;
        long year = 31104000L;
        long delta = System.currentTimeMillis() / 1000L - matchTime;
        String matchTimeTip = "";
        if (delta < 60L) {
            matchTimeTip = ResourceUtils.getString((int)R.string.tip_wemeet_moment);
        } else if (delta < 3600L) {
            int strId = (delta /= 60L) > 1L ? R.string.tip_wemeet_minutes : R.string.tip_wemeet_minute;
            matchTimeTip = delta + " " + ResourceUtils.getString((int)strId);
        } else if (delta < 86400L) {
            int strId = (delta /= 3600L) > 1L ? R.string.tip_wemeet_hours : R.string.tip_wemeet_hour;
            matchTimeTip = delta + " " + ResourceUtils.getString((int)strId);
        } else if (delta < 2592000L) {
            int strId = (delta /= 86400L) > 1L ? R.string.tip_wemeet_days : R.string.tip_wemeet_day;
            matchTimeTip = delta + " " + ResourceUtils.getString((int)strId);
        } else if (delta < 31104000L) {
            int strId = (delta /= 2592000L) > 1L ? R.string.tip_wemeet_months : R.string.tip_wemeet_month;
            matchTimeTip = delta + " " + ResourceUtils.getString((int)strId);
        } else {
            int strId = (delta /= 31104000L) > 1L ? R.string.tip_wemeet_years : R.string.tip_wemeet_year;
            matchTimeTip = delta + " " + ResourceUtils.getString((int)strId);
        }
        return matchTimeTip;
    }

    public static ChatMessageData generateLocalSystemData(String content, long targetUid) {
        long currentTime = System.currentTimeMillis();
        ImMessageDBBean message = new ImMessageDBBean();
        message.setContent(content);
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setUid(targetUid);
        message.setToUserId(AccountUtil.getUid());
        message.setFromType(0);
        message.setMsgType(4);
        message.setStatus(0);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateLocalOverdueImGameInviteData(String userName, long targetUid, String gameName, String gameId, long currentTime, int source) {
        ImMessageDBBean message = new ImMessageDBBean();
        if (FP.size((CharSequence)userName) > 5) {
            userName = userName.substring(0, 5) + "..";
        }
        String content = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_overdue_game_invite), (Object[])new Object[]{userName, gameName});
        message.setContent(content);
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setUid(targetUid);
        message.setFromType(0);
        message.setMsgType(52);
        message.setStatus(0);
        message.setGameId(gameId);
        message.setReserveInt1(source);
        if (source == 1) {
            message.setStrategyType(1);
        }
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    @NonNull
    public static ChatMessageData generateLocalRecommendGameData(String gameId, long targetUid, String content) {
        ImMessageDBBean message = new ImMessageDBBean();
        long currentTime = System.currentTimeMillis();
        message.setContent(content);
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setUid(targetUid);
        message.setFromType(0);
        message.setMsgType(59);
        message.setStatus(0);
        message.setGameId(gameId);
        message.setNewGuideStrategyType(4);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    @NonNull
    public static ChatMessageData generateLocalEmotionGuideData(long targetUid, String content) {
        ImMessageDBBean message = new ImMessageDBBean();
        long currentTime = System.currentTimeMillis();
        message.setContent(content);
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setUid(AccountUtil.getUid());
        message.setToUserId(targetUid);
        message.setFromType(0);
        message.setMsgType(60);
        message.setStatus(0);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    @NonNull
    public static ChatMessageData generateTeamUpGameCardTipData(long targetUid, boolean sendTip) {
        ImMessageDBBean message = new ImMessageDBBean();
        long currentTime = System.currentTimeMillis();
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setUid(targetUid);
        message.setToUserId(AccountUtil.getUid());
        message.setFromType(0);
        message.setMsgType(71);
        message.setExtObj((Object)sendTip);
        message.setStatus(0);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    @NonNull
    public static ChatMessageData generateCreateTeamUpTipData(long targetUid, String gid) {
        ImMessageDBBean message = new ImMessageDBBean();
        long currentTime = System.currentTimeMillis();
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setUid(targetUid);
        message.setToUserId(AccountUtil.getUid());
        message.setFromType(0);
        message.setMsgType(74);
        message.setStatus(0);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        message.setGameId(gid);
        return new ChatMessageData(message);
    }

    @NonNull
    public static ChatMessageData generateHagoOfficialTipData(long targetUid) {
        ImMessageDBBean message = new ImMessageDBBean();
        long currentTime = System.currentTimeMillis();
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setUid(targetUid);
        message.setToUserId(AccountUtil.getUid());
        message.setFromType(0);
        message.setMsgType(78);
        message.setStatus(0);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateSysNoticeData(String content, String imageUrl, String jumpUrl) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setContent(content);
        message.setSendTime(System.currentTimeMillis());
        message.setFromType(0);
        message.setMsgType(1);
        message.setStatus(0);
        message.setImageUrl(imageUrl);
        message.setJumpUrl(jumpUrl);
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateSendingImageData(String imagePath, String tag, int width, int height) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setUid(AccountUtil.getUid());
        message.setContent(imagePath);
        message.setReserve2(imagePath);
        message.setTag(tag);
        message.setContentType(2);
        message.setSendByMe(true);
        message.setMsgType(0);
        message.setChatType(1);
        message.setFromType(0);
        message.setStatus(2);
        message.setSendTime(System.currentTimeMillis());
        message.setReserve1(width + ":" + height);
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateLocalText(long toUserId, String textContent, long currentTime, int mesType) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setContent(textContent);
        message.setUid(toUserId);
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setContentType(1);
        message.setMsgType(mesType);
        message.setChatType(1);
        message.setFromType(0);
        message.setStatus(0);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)toUserId));
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateGameResultTextMsg(long toUserId, String textContent, long currentTime, boolean isSend) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setContent(textContent);
        if (isSend) {
            message.setUid(AccountUtil.getUid());
            message.setToUserId(toUserId);
        } else {
            message.setUid(toUserId);
            message.setToUserId(AccountUtil.getUid());
        }
        message.setSendTime(currentTime);
        message.setClientSendTime(currentTime);
        message.setContentType(1);
        message.setMsgType(58);
        message.setChatType(1);
        message.setFromType(0);
        message.setStatus(0);
        message.setSendByMe(isSend);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)toUserId));
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateFavorNoticeData(long targetUid) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setUid(AccountUtil.getUid());
        message.setToUserId(targetUid);
        message.setContent("I like your profile.");
        message.setSendTime(System.currentTimeMillis());
        message.setFromType(0);
        message.setMsgType(5);
        message.setStatus(2);
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateGameCardData(GameInfo gameInfo, String pkId, long serverTime, String gameModeName, Map<String, Object> extendInfo, long fromUid, int state2, String url, long targetUid, int winCount) {
        return ChatMessageDataGenerator.generateGameCardData(gameInfo, pkId, serverTime, gameModeName, extendInfo, fromUid, state2, url, targetUid, Collections.emptyList(), winCount);
    }

    public static ChatMessageData generateGameRandomMatchCardData(GameInfo gameInfo, long fromUid, long targetUid) {
        ImMessageDBBean message = new ImMessageDBBean();
        message.setFromType(0);
        message.setMsgType(79);
        message.setStatus(0);
        message.setUid(AccountUtil.getUid());
        message.setToUserId(fromUid);
        message.setSendByMe(true);
        message.setSendTime(System.currentTimeMillis());
        message.setClientSendTime(System.currentTimeMillis());
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        message.setGameId(gameInfo.gid);
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateGameCardData(GameInfo gameInfo, String pkId, long serverTime, String gameModeName, Map<String, Object> extendInfo, long fromUid, int state2, String url, long targetUid, List<String> friendAvatars, int winCount) {
        ImMessageDBBean message = new ImMessageDBBean();
        ImGameCardInfo imGameCardInfo = new ImGameCardInfo();
        imGameCardInfo.mGameInfo = gameInfo;
        imGameCardInfo.mPkId = pkId;
        imGameCardInfo.mStartTime = serverTime;
        imGameCardInfo.mGameModeName = gameModeName;
        imGameCardInfo.mGameState = state2;
        imGameCardInfo.mPortraitUrl = url;
        imGameCardInfo.friendAvatars = friendAvatars;
        imGameCardInfo.winCount = winCount;
        message.setFromType(0);
        message.setMsgType(55);
        message.setStatus(0);
        if (extendInfo != null) {
            if (extendInfo.get("roomId") instanceof String) {
                message.setRoomeId((String)extendInfo.get("roomId"));
            }
            if (extendInfo.get("infoPayload") instanceof String) {
                message.setReserve1((String)extendInfo.get("infoPayload"));
            }
            if (extendInfo.get("coinGradeType") instanceof Integer) {
                message.setReserve2(extendInfo.get("coinGradeType").toString());
            }
            if (extendInfo.get("isGold") instanceof Boolean) {
                message.setReserve3(extendInfo.get("isGold").toString());
            }
            if (extendInfo.get("is_send_from_other_platform_share_landing_page") instanceof Boolean) {
                message.setReserve4(Objects.requireNonNull(extendInfo.get("is_send_from_other_platform_share_landing_page")).toString());
            }
        }
        if (state2 == 2) {
            message.setUid(fromUid);
            message.setToUserId(AccountUtil.getUid());
            message.setSendByMe(false);
            imGameCardInfo.isInviteByMe = false;
        } else {
            message.setUid(AccountUtil.getUid());
            message.setToUserId(targetUid);
            message.setSendByMe(true);
            imGameCardInfo.isInviteByMe = true;
        }
        String gameJson = new Gson().toJson((Object)imGameCardInfo);
        message.setExtra(gameJson);
        message.setSendTime(System.currentTimeMillis());
        message.setClientSendTime(System.currentTimeMillis());
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateGameScoreData(GameInfo gameInfo, String pkId, long serverTime, long targetUid, String url, String friendUrl, int myScore, int friendScore) {
        ImMessageDBBean message = new ImMessageDBBean();
        ImGameCardInfo imGameCardInfo = new ImGameCardInfo();
        imGameCardInfo.mGameInfo = gameInfo;
        imGameCardInfo.mPkId = pkId;
        imGameCardInfo.mStartTime = serverTime;
        imGameCardInfo.mPortraitUrl = url;
        imGameCardInfo.mFriendPortraitUrl = friendUrl;
        imGameCardInfo.mMyScore = myScore;
        imGameCardInfo.mFriendScore = friendScore;
        String gameJson = new Gson().toJson((Object)imGameCardInfo);
        message.setExtra(gameJson);
        message.setFromType(0);
        message.setMsgType(56);
        message.setStatus(0);
        message.setSendTime(serverTime);
        message.setUid(targetUid);
        message.setSendTime(System.currentTimeMillis());
        message.setClientSendTime(System.currentTimeMillis());
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)targetUid));
        return new ChatMessageData(message);
    }

    private static ChatMessageData generateNewPostMsg(ImMessageDBBean msgData, BasePostInfo postInfo, PostItemVersion version) {
        IMPostData postData = IMPostUtils.INSTANCE.parseToIMPostData(postInfo);
        if (null == postData) {
            return null;
        }
        msgData.setSendByMe(true);
        msgData.setPostId(postData.getPostId());
        msgData.setPostType(postData.getPostType());
        msgData.setPostTime(postData.getTime() == null ? 0L : postData.getTime());
        msgData.setPostContent(postData.getContent());
        msgData.setPostImage(postData.getImage());
        msgData.setpostCreatorAvatar(postData.getCreatorAvatar());
        if (version == PostItemVersion.V2) {
            msgData.setPostImgCount(postData.getImageCount());
            msgData.setPostLiked(postData.getLiked());
            msgData.setExtObj((Object)postInfo);
        }
        return new ChatMessageData(msgData);
    }

    @Nullable
    public static ChatMessageData generateNewPostMsg(BasePostInfo postInfo, long toUid, PostItemVersion version) {
        ImMessageDBBean imMessage = new ImMessageDBBean();
        long sendTime = System.currentTimeMillis();
        imMessage.setSendByMe(true);
        imMessage.setSessionId(Utils.getSessionId((long)toUid, (long)AccountUtil.getUid()));
        imMessage.setToUserId(toUid);
        imMessage.setUid(toUid);
        int msgType = version == PostItemVersion.V1 ? 57 : 68;
        imMessage.setMsgType(msgType);
        imMessage.setStatus(0);
        imMessage.setClientSendTime(sendTime);
        imMessage.setSendTime(sendTime);
        return ChatMessageDataGenerator.generateNewPostMsg(imMessage, postInfo, version);
    }

    public static ChatMessageData generateNewGameRecommendMsg(String gid, long fromUid) {
        ImMessageDBBean message = new ImMessageDBBean();
        String content = "";
        message.setContent(content);
        message.setSendTime(System.currentTimeMillis());
        message.setClientSendTime(System.currentTimeMillis());
        message.setUid(fromUid);
        message.setToUserId(AccountUtil.getUid());
        message.setFromType(0);
        message.setMsgType(61);
        message.setStatus(0);
        message.setGameId(gid);
        message.setSessionId(Utils.getSessionId((long)AccountUtil.getUid(), (long)fromUid));
        return new ChatMessageData(message);
    }

    public static ChatMessageData generateEmptyData() {
        ImMessageDBBean messageDBBean = new ImMessageDBBean();
        messageDBBean.setMsgType(36);
        return new ChatMessageData(messageDBBean);
    }
}

