/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.sticker.view;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYRecyclerView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.im.module.room.sticker.IStickerHandlerCallback;
import com.yy.im.module.room.sticker.ImWhatsAppStickerPresenter;
import com.yy.im.module.room.sticker.StickerInfo;
import com.yy.im.module.room.sticker.view.ImStickerPanelAdapter;
import java.util.List;

public class WhatsAppStickerPanel
extends CommonStatusLayout {
    private ImStickerPanelAdapter mAdapter;
    private RecyclerView mRecyclerView;
    private Context mContext;
    private ImWhatsAppStickerPresenter mPresenter;
    private IStickerHandlerCallback mCallback;

    public WhatsAppStickerPanel(@NonNull Context context, ImWhatsAppStickerPresenter presenter, IStickerHandlerCallback callback) {
        super(context);
        this.mContext = context;
        this.mPresenter = presenter;
        this.mCallback = callback;
        this.initView(context);
    }

    private void initView(Context context) {
        this.mRecyclerView = new YYRecyclerView(context, "WhatsAppStickerPanel");
        GridLayoutManager gridLayoutManager = new GridLayoutManager(context, 4);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.mRecyclerView.setHasFixedSize(true);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpacesItemDecoration(ResolutionUtils.dip2Px((float)2.0f)));
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(new ViewGroup.LayoutParams(-1, -1));
        layoutParams2.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
        this.addView((View)this.mRecyclerView, (ViewGroup.LayoutParams)layoutParams2);
    }

    private void initAdapter() {
        this.mAdapter = new ImStickerPanelAdapter(this.mContext);
        this.mAdapter.setCallback(this.mCallback);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    public void onPanelShow() {
        if (this.mAdapter == null) {
            this.showLoading();
        }
        if (this.mPresenter != null) {
            this.mPresenter.onPanelShow();
        }
    }

    public void setStickList(List<StickerInfo> stickList) {
        if (this.mAdapter == null) {
            this.initAdapter();
            this.hideAllStatus();
        }
        this.mAdapter.addDataList(stickList);
    }

    class SpacesItemDecoration
    extends RecyclerView.ItemDecoration {
        private int space;

        SpacesItemDecoration(int space) {
            this.space = space;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state2) {
            outRect.top = this.space;
        }
    }
}

