/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.sticker;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Message;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.mixmodule.base.whatsappsticker.StickerMsgDef;
import com.yy.hiyo.mixmodule.base.whatsappsticker.WhatsAppStickerCode;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.CheckStickerData;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.GetStickerData;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.InstallStickerData;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.Sticker;
import com.yy.hiyo.mixmodule.base.whatsappsticker.bean.StickerPack;
import com.yy.hiyo.mixmodule.base.whatsappsticker.callback.ICheckStickerStateCallback;
import com.yy.hiyo.mixmodule.base.whatsappsticker.callback.IGetResCallback;
import com.yy.hiyo.mixmodule.base.whatsappsticker.callback.IInstallStickerCallback;
import com.yy.im.R;
import com.yy.im.module.room.sticker.GenerateImStickerDataUtil;
import com.yy.im.module.room.sticker.IStickerHandlerCallback;
import com.yy.im.module.room.sticker.IStickerMsgCallback;
import com.yy.im.module.room.sticker.StickerInfo;
import com.yy.im.module.room.sticker.view.WhatsAppStickerPanel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ImWhatsAppStickerPresenter {
    private static final String TAG = "ImWhatsAppStickerPresenter";
    private static final String WHATS_APP_SHOW_RED_TIP_KEY = "key_whatsApp_show_tip";
    private boolean isNeedShowStickerEntrance;
    private WhatsAppStickerPanel mPanel;
    private boolean showTips = false;
    private StickerPack mStickerPack;
    private List<StickerInfo> mStickerInfoList;
    @WhatsAppStickerCode.CheckInstallStickerState
    private int mPackInstallCode;
    private IStickerMsgCallback mMsgCallback;
    private ICheckStickerStateCallback mCheckStickerStateCallback = new ICheckStickerStateCallback(){

        public void checkWhatsAppStickerState(int state2) {
            MLog.info((Object)ImWhatsAppStickerPresenter.TAG, (String)"checkWhatsAppStickerState state: %s", (Object[])new Object[]{state2});
            if (ImWhatsAppStickerPresenter.this.mPackInstallCode != -1) {
                return;
            }
            ImWhatsAppStickerPresenter.this.mPackInstallCode = state2;
            if (!FP.empty((Collection)ImWhatsAppStickerPresenter.this.mStickerInfoList) && ImWhatsAppStickerPresenter.this.mPanel != null && ImWhatsAppStickerPresenter.this.mPackInstallCode == 0 && ((StickerInfo)((ImWhatsAppStickerPresenter)ImWhatsAppStickerPresenter.this).mStickerInfoList.get((int)0)).isInstallIcon) {
                StickerInfo entrance = (StickerInfo)ImWhatsAppStickerPresenter.this.mStickerInfoList.remove(0);
                ImWhatsAppStickerPresenter.this.mStickerInfoList.add(entrance);
                ImWhatsAppStickerPresenter.this.mPanel.setStickList(ImWhatsAppStickerPresenter.this.mStickerInfoList);
                MLog.info((Object)ImWhatsAppStickerPresenter.TAG, (String)"mCheckStickerStateCallback need move entrance to end", (Object[])new Object[0]);
            }
        }
    };
    private IGetResCallback mGetResCallback = new IGetResCallback(){

        public void onCompleted(String path) {
            MLog.info((Object)ImWhatsAppStickerPresenter.TAG, (String)"mGetResCallback path: %s", (Object[])new Object[]{path});
            ImWhatsAppStickerPresenter.this.createStickerList(path);
        }

        public void onFailed() {
            MLog.info((Object)ImWhatsAppStickerPresenter.TAG, (String)"mGetResCallback onFailed!!!", (Object[])new Object[0]);
            ImWhatsAppStickerPresenter.this.mPanel.setStickList(Collections.EMPTY_LIST);
        }
    };
    private boolean isInstalling = false;
    private IStickerHandlerCallback mHandlerCallback = new IStickerHandlerCallback(){

        @Override
        public void onItemClick(StickerInfo info) {
            MLog.info((Object)ImWhatsAppStickerPresenter.TAG, (String)"onItemClick info: %s", (Object[])new Object[]{info});
            if (!info.isInstallIcon) {
                if (ImWhatsAppStickerPresenter.this.mMsgCallback != null) {
                    ImWhatsAppStickerPresenter.this.mMsgCallback.onSendStickMsg(info);
                }
            } else {
                if (ImWhatsAppStickerPresenter.this.mStickerPack == null) {
                    MLog.info((Object)ImWhatsAppStickerPresenter.TAG, (String)"onItemClick mStickerPack is null!", (Object[])new Object[0]);
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_add_whatsapp_sticker_failed, (int)0);
                    HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "texture_fail"));
                    return;
                }
                if (ImWhatsAppStickerPresenter.this.isInstalling) {
                    MLog.debug((Object)ImWhatsAppStickerPresenter.TAG, (String)"onItemClick filter!!!", (Object[])new Object[0]);
                    return;
                }
                ImWhatsAppStickerPresenter.this.isInstalling = true;
                YYTaskExecutor.execute(() -> {
                    String json = JsonParser.toJson((Object)ImWhatsAppStickerPresenter.this.mStickerPack);
                    ImWhatsAppStickerPresenter.this.installWhatsAppSticker(json);
                });
                HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "texture_down"));
            }
        }
    };

    public ImWhatsAppStickerPresenter(IStickerMsgCallback msgCallback) {
        this.isNeedShowStickerEntrance = NAB.A.equals((Object)NewABDefine.HAGO_ANDROID_IM_WHATSAPP_ENTRANCE.getTest());
        MLog.info((Object)TAG, (String)"isNeedShowStickerEntrance: %s  plane: %s", (Object[])new Object[]{this.isNeedShowStickerEntrance, NewABDefine.HAGO_ANDROID_IM_WHATSAPP_ENTRANCE.getTest()});
        this.mPackInstallCode = -1;
        this.mMsgCallback = msgCallback;
    }

    public boolean judgeNeedShowRedPointTips() {
        if (!this.isNeedShowStickerEntrance) {
            return false;
        }
        SharedPreferences sharedPreferences = SharedPreferencesUtils.getDefaultPrf();
        this.showTips = sharedPreferences.getBoolean(WHATS_APP_SHOW_RED_TIP_KEY, true);
        return this.showTips;
    }

    public void updateShowRedPointTips() {
        if (!this.showTips) {
            return;
        }
        this.showTips = false;
        MLog.info((Object)TAG, (String)"updateShowRedPointTips!!", (Object[])new Object[0]);
        SharedPreferences sharedPreferences = SharedPreferencesUtils.getDefaultPrf();
        sharedPreferences.edit().putBoolean(WHATS_APP_SHOW_RED_TIP_KEY, false).apply();
    }

    public WhatsAppStickerPanel getWhatsAppPanel(Context context) {
        if (!this.isNeedShowStickerEntrance) {
            return null;
        }
        if (this.mPanel == null) {
            this.mPanel = new WhatsAppStickerPanel(context, this, this.mHandlerCallback);
        }
        return this.mPanel;
    }

    public void onPanelShow() {
        if (this.mPanel == null) {
            MLog.error((Object)TAG, (String)"onPanelShow but panel is null!!!", (Object[])new Object[0]);
            return;
        }
        if (this.mStickerPack == null) {
            this.mStickerPack = GenerateImStickerDataUtil.generateImStickerPack();
            this.updateShowRedPointTips();
            CheckStickerData checkData = new CheckStickerData(this.mStickerPack.identifier, this.mCheckStickerStateCallback);
            Message checkMsg = Message.obtain();
            checkMsg.what = StickerMsgDef.CHECK_WHATSAPP_STICKER_INSTALLED;
            checkMsg.obj = checkData;
            MsgDispatcher.getInstance().sendMessage(checkMsg);
            GetStickerData data2 = new GetStickerData(this.mStickerPack, this.mGetResCallback);
            Message msg = Message.obtain();
            msg.what = StickerMsgDef.GET_STICKER_RES;
            msg.obj = data2;
            MsgDispatcher.getInstance().sendMessage(msg);
        }
        HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "texture_show"));
    }

    private void createStickerList(String path) {
        this.mStickerInfoList = new ArrayList<StickerInfo>();
        for (int i = 0; i < this.mStickerPack.stickers.size(); ++i) {
            Sticker sticker = (Sticker)this.mStickerPack.stickers.get(i);
            String filePath = path + File.separator + sticker.imageFile;
            File file = new File(filePath);
            if (!file.exists()) continue;
            StickerInfo info = new StickerInfo(filePath, sticker.imageFile, sticker.downloadUrl, GenerateImStickerDataUtil.getEmojiName(sticker.imageFile));
            this.mStickerInfoList.add(info);
        }
        StickerInfo installInfo = new StickerInfo(true);
        if (this.mPackInstallCode != -1) {
            if (this.mPackInstallCode == 0) {
                this.mStickerInfoList.add(installInfo);
            } else {
                this.mStickerInfoList.add(0, installInfo);
            }
        } else {
            this.mStickerInfoList.add(0, installInfo);
        }
        if (this.mPanel != null) {
            this.mPanel.setStickList(this.mStickerInfoList);
        }
    }

    private void installWhatsAppSticker(String json) {
        IInstallStickerCallback installStickerCallback = code -> {
            MLog.info((Object)TAG, (String)"installStickerCallback code: %s", (Object[])new Object[]{code});
            if (code != 1) {
                if (code == 2) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_add_whatsapp_sticker_not_install, (int)0);
                    HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "texture_nowhatsapp"));
                } else if (code == 7) {
                    HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "texture_back"));
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_add_whatsapp_sticker_failed, (int)0);
                    HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "texture_fail"));
                }
            } else {
                this.mPackInstallCode = 0;
                this.modifyStickerListToInstall();
            }
            this.isInstalling = false;
        };
        InstallStickerData installStickerData = new InstallStickerData(json, installStickerCallback);
        Message message = Message.obtain();
        message.what = StickerMsgDef.ADD_WHATSAPP_STICKER_HANDLER;
        message.obj = installStickerData;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    private void modifyStickerListToInstall() {
        if (FP.empty(this.mStickerInfoList)) {
            MLog.info((Object)TAG, (String)"modifyStickerListToInstall mStickerInfoList is empty", (Object[])new Object[0]);
            return;
        }
        StickerInfo info = this.mStickerInfoList.get(this.mStickerInfoList.size() - 1);
        if (info.isInstallIcon) {
            return;
        }
        StickerInfo entranceInfo = this.mStickerInfoList.remove(0);
        this.mStickerInfoList.add(entranceInfo);
        this.mPanel.setStickList(this.mStickerInfoList);
    }

    public void onRelease() {
        MsgDispatcher.getInstance().sendMessage(StickerMsgDef.CANCEL_WHATS_APP_OP);
    }
}

