/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.service.ISocialMediaService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.socialmdeia.SocialMediaInfo;
import com.yy.appbase.socialmdeia.SocialMediaSource;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

@DontProguardClass
public class OfficialSocialHolder
extends ChatBaseHolder {
    private View container;
    private YYTextView title;
    private YYTextView tvContent;
    private YYTextView tvTime;
    private RecycleImageView ivImage;
    private RecycleImageView leftIcon;
    private RecycleImageView rightIcon;
    private ImMessageDBBean msgBean;
    private String lastImageUrl;

    public OfficialSocialHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.container = itemView.findViewById(R.id.container);
        this.title = (YYTextView)itemView.findViewById(R.id.title);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.content);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivImage = (RecycleImageView)itemView.findViewById(R.id.image);
        this.leftIcon = (RecycleImageView)itemView.findViewById(R.id.leftIcon);
        this.rightIcon = (RecycleImageView)itemView.findViewById(R.id.rightIcon);
        this.container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OfficialSocialHolder.this.msgBean != null) {
                    SocialMediaInfo info = new SocialMediaInfo(Boolean.valueOf(true), Boolean.valueOf(true), OfficialSocialHolder.this.msgBean.getContent(), OfficialSocialHolder.this.msgBean.getImageUrl(), OfficialSocialHolder.this.msgBean.getJumpUrl(), OfficialSocialHolder.this.msgBean.getExtra(), OfficialSocialHolder.this.msgBean.getReserve5(), SocialMediaSource.OFFICIAL_MSG);
                    ((ISocialMediaService)ServiceManagerProxy.getServiceManager().getService(ISocialMediaService.class)).onSocialClick(info);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20038709").put("function_id", "message_click"));
                }
            }
        });
    }

    public static BaseItemBinder<ChatMessageData, OfficialSocialHolder> getBinder(final IMvpContext provider) {
        return new BaseItemBinder<ChatMessageData, OfficialSocialHolder>(){

            @NonNull
            protected OfficialSocialHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new OfficialSocialHolder(inflater.inflate(R.layout.layout_item_im_official_social, parent, false), provider);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        String imageUrl;
        super.setData((Object)data2);
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.msgBean = data2.message;
        this.tvContent.setText((CharSequence)this.msgBean.getContent());
        ImageLoader.loadImage((ImageView)this.leftIcon, (String)this.msgBean.getReserve1());
        ImageLoader.loadImage((ImageView)this.rightIcon, (String)this.msgBean.getReserve3());
        if (!FP.empty((CharSequence)this.msgBean.getReserve2())) {
            this.title.setText((CharSequence)this.msgBean.getReserve2());
        }
        String reser4 = this.msgBean.getReserve4();
        boolean useImageSize = false;
        if (!FP.empty((CharSequence)reser4)) {
            useImageSize = StringUtils.parseBoolean((String)reser4);
        }
        if (!StringUtils.equal((String)(imageUrl = this.msgBean.getImageUrl()), (String)this.lastImageUrl)) {
            this.ivImage.setImageDrawableToNull();
        }
        this.lastImageUrl = imageUrl;
        this.ivImage.setVisibility(0);
        final ConstraintLayout.LayoutParams lp = (ConstraintLayout.LayoutParams)this.ivImage.getLayoutParams();
        if (!useImageSize) {
            lp.dimensionRatio = "H,330:240";
            this.ivImage.setLayoutParams((ViewGroup.LayoutParams)lp);
            ImageLoader.loadImage((ImageView)this.ivImage, (String)imageUrl);
        } else {
            ImageLoader.loadBitmap((Context)this.ivImage.getContext(), (String)imageUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){
                private String localImageUrl;
                {
                    this.localImageUrl = imageUrl;
                }

                public void onLoadFailed(Exception e) {
                    if (!StringUtils.equal((String)this.localImageUrl, (String)OfficialSocialHolder.this.msgBean.getImageUrl())) {
                        return;
                    }
                    OfficialSocialHolder.this.ivImage.setVisibility(8);
                }

                public void onResourceReady(Bitmap bitmap) {
                    if (!StringUtils.equal((String)this.localImageUrl, (String)OfficialSocialHolder.this.msgBean.getImageUrl())) {
                        return;
                    }
                    if (bitmap != null && OfficialSocialHolder.this.ivImage != null) {
                        int width = bitmap.getWidth();
                        int height = bitmap.getHeight();
                        lp.height = height = (int)(1.0f * (float)height / (float)width * (float)OfficialSocialHolder.this.ivImage.getWidth());
                        lp.dimensionRatio = "";
                        OfficialSocialHolder.this.ivImage.setLayoutParams((ViewGroup.LayoutParams)lp);
                        BitmapDrawable drawable2 = new BitmapDrawable(bitmap);
                        OfficialSocialHolder.this.ivImage.setImageDrawable((Drawable)drawable2);
                    }
                }
            });
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20038709").put("function_id", "message_show"));
    }
}

