/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;

@DontProguardClass
public class ChatRecommendFriendHolder
extends ChatBaseHolder {
    private View view;
    private YYTextView nameTv;
    private YYTextView tipsTv;
    private YYTextView contentTv;
    private YYTextView timeTv;
    private YYTextView chatTv;
    private RecycleImageView avatarIv;
    private RecycleImageView typeIv;

    public ChatRecommendFriendHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.view = itemView;
        this.nameTv = (YYTextView)itemView.findViewById(R.id.tv_name);
        this.tipsTv = (YYTextView)itemView.findViewById(R.id.tv_tips);
        this.contentTv = (YYTextView)itemView.findViewById(R.id.tv_content);
        this.timeTv = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.chatTv = (YYTextView)itemView.findViewById(R.id.tv_chat);
        this.avatarIv = (RecycleImageView)itemView.findViewById(R.id.iv_avatar);
        this.typeIv = (RecycleImageView)itemView.findViewById(R.id.iv_type);
    }

    public static BaseItemBinder<ChatMessageData, ChatRecommendFriendHolder> getBinder(final IMvpContext provider) {
        return new BaseItemBinder<ChatMessageData, ChatRecommendFriendHolder>(){

            @NonNull
            protected ChatRecommendFriendHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatRecommendFriendHolder(inflater.inflate(R.layout.layout_item_im_recommend_friend, parent, false), provider);
            }
        };
    }

    public void setData(ChatMessageData data2) {
        super.setData((Object)data2);
        this.setFormatTimeInfo((TextView)this.timeTv, data2);
        ImageLoader.loadBitmap((ImageView)this.avatarIv, (String)(data2.message.getToUserHeader() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.icon_avatar_default_male);
        this.nameTv.setText((CharSequence)data2.message.getToUserName());
        this.contentTv.setText((CharSequence)data2.message.getContent());
        if (data2.message.getBindType() == 0) {
            this.tipsTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_im_suggest_friend_fb, (Object[])new Object[]{data2.message.getExtra()}));
            this.typeIv.setImageResource(R.drawable.icon_recommend_fb);
        } else if (data2.message.getBindType() == 1) {
            this.tipsTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_im_suggest_friend_contact, (Object[])new Object[]{data2.message.getExtra()}));
            this.typeIv.setImageResource(R.drawable.icon_recommend_contact);
        } else if (data2.message.getBindType() == 2) {
            this.tipsTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_im_suggest_friend_zalo, (Object[])new Object[]{data2.message.getExtra()}));
            this.typeIv.setImageResource(R.drawable.icon_zalo_little);
        }
        this.view.setOnClickListener(v -> {
            if (this.getEventCallback() != null) {
                this.getEventCallback().onContentClick(v, data2);
            }
        });
    }
}

