/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.URLUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class ChatCommonTxtPicMessageBaseHolder
extends ChatBaseHolder
implements View.OnClickListener,
View.OnLongClickListener {
    private YYTextView tvTxtMsg;
    private YYTextView tvTime;
    private RecycleImageView ivIcon;
    private View contentView;
    private boolean isExposure;

    ChatCommonTxtPicMessageBaseHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.tvTxtMsg = (YYTextView)itemView.findViewById(R.id.tv_txt_msg);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.ivIcon = (RecycleImageView)itemView.findViewById(R.id.iv_icon);
        this.contentView = itemView.findViewById(R.id.content);
    }

    public void setData(ChatMessageData data2) {
        if (data2 != this.getData()) {
            this.isExposure = false;
            this.reportExposure();
        }
        super.setData((Object)data2);
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.tvTxtMsg.setText((CharSequence)data2.message.getContent());
        ImageLoader.loadBitmap((ImageView)this.ivIcon, (String)data2.message.getImageUrl(), (int)R.drawable.ic_img_loading);
        this.ivIcon.setTag(R.id.chat_message_data, (Object)data2);
        this.ivIcon.setOnClickListener((View.OnClickListener)this);
        this.contentView.setTag(R.id.chat_message_data, (Object)data2);
        this.contentView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.iv_user_avatar) {
            if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
                this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
            }
        } else if (id2 == R.id.iv_icon && v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.reportClick();
            this.getEventCallback().onImageClick(v, (ChatMessageData)v.getTag(R.id.chat_message_data));
        }
    }

    public boolean onLongClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData) {
            if (this.getEventCallback() != null) {
                this.getEventCallback().onChatMessageItemLongClick((ChatMessageData)v.getTag(R.id.chat_message_data), v);
            }
            return true;
        }
        return false;
    }

    public void onViewVisible(IRecycleView view) {
        super.onViewVisible(view);
        this.reportExposure();
    }

    private void reportExposure() {
        ChatMessageData data2 = (ChatMessageData)this.getData();
        if (data2 == null || data2.message == null) {
            return;
        }
        if (this.isExposure) {
            return;
        }
        String url = URLUtils.urlDecoderDecode((String)data2.message.getJumpUrl());
        if (!TextUtils.isEmpty((CharSequence)url) && (url.contains("test.ihago.net/a/mlbb-ladder/index.html") || url.contains("www.ihago.net/a/mlbb-ladder/index.html"))) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "inside_invite_expose"));
        }
        this.isExposure = true;
    }

    private void reportClick() {
        ChatMessageData data2 = (ChatMessageData)this.getData();
        if (data2 == null || data2.message == null) {
            return;
        }
        String url = URLUtils.urlDecoderDecode((String)data2.message.getJumpUrl());
        if (!TextUtils.isEmpty((CharSequence)url) && (url.contains("test.ihago.net/a/mlbb-ladder/index.html") || url.contains("www.ihago.net/a/mlbb-ladder/index.html"))) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "inside_invite_click"));
        }
    }
}

