/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.kvo.HeadFrameType;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.ImResourceManager;
import com.yy.im.R;
import com.yy.im.model.ChatMessageData;
import com.yy.im.module.room.holder.ChatBaseHolder;

@DontProguardClass
public class ChatChannelInviteReceiveHolder
extends ChatBaseHolder
implements View.OnClickListener {
    private HeadFrameImageView ivAvatar;
    private YYTextView tvTxtMsg;
    private YYTextView tvContent;
    private YYTextView tvTime;
    private View contentView;

    public ChatChannelInviteReceiveHolder(View itemView, IMvpContext baseRecyclerAdapter) {
        super(itemView, baseRecyclerAdapter);
        this.ivAvatar = (HeadFrameImageView)itemView.findViewById(R.id.iv_user_avatar);
        this.tvTxtMsg = (YYTextView)itemView.findViewById(R.id.tv_txt_msg);
        this.tvContent = (YYTextView)itemView.findViewById(R.id.tv_content);
        this.tvTime = (YYTextView)itemView.findViewById(R.id.tv_time);
        this.contentView = itemView.findViewById(R.id.content);
        itemView.findViewById(R.id.llyt_voice_item_bg).setBackgroundResource(ImResourceManager.INSTANCE.getChannelInviteOtherBackground());
    }

    public static BaseItemBinder<ChatMessageData, ChatChannelInviteReceiveHolder> getBinder(final IMvpContext context) {
        return new BaseItemBinder<ChatMessageData, ChatChannelInviteReceiveHolder>(){

            @NonNull
            protected ChatChannelInviteReceiveHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChatChannelInviteReceiveHolder(inflater.inflate(R.layout.layout_item_im_channel_invite_receive, parent, false), context);
            }
        };
    }

    public void setData(final ChatMessageData data2) {
        super.setData((Object)data2);
        if (data2.message.getUid() == 10L || data2.message.getUid() == 14L) {
            this.ivAvatar.getCircleImageView().setImageResource(R.drawable.icon_public_msg_avatar);
        } else {
            this.showAvatar((RecycleImageView)this.ivAvatar.getCircleImageView(), this.getUserInfo(data2.message.getUid()));
        }
        this.setFormatTimeInfo((TextView)this.tvTime, data2);
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)data2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        this.tvTxtMsg.setText((CharSequence)data2.message.getRoomName());
        this.tvContent.setText((CharSequence)data2.message.getContent());
        this.contentView.setTag(R.id.chat_message_data, (Object)data2);
        this.contentView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChatChannelInviteReceiveHolder.this.getEventCallback() != null) {
                    ChatChannelInviteReceiveHolder.this.getEventCallback().onVoiceRoomInviteClick(data2.message.getRoomeId(), data2.message.getRoomPwdToken(), false, data2.message.getReserve2(), data2.message.getUid(), data2.message.getRoomSource());
                }
            }
        });
        this.contentView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (ChatChannelInviteReceiveHolder.this.getEventCallback() != null) {
                    ChatChannelInviteReceiveHolder.this.getEventCallback().onVoiceRoomInviteLongClick(v, data2);
                }
                return true;
            }
        });
        HeadFrameType otherHeadFrameType = this.getOtherHeadFrameType();
        if (otherHeadFrameType != null) {
            Kvo.addKvoBinding((KvoSource)otherHeadFrameType, (Object)((Object)this), (String)"onOtherHeadFrameTypeUpdate");
        }
    }

    @KvoMethodAnnotation(name="headFrameType", sourceClass=HeadFrameType.class)
    public void onOtherHeadFrameTypeUpdate(KvoEventIntent event) {
        if (this.ivAvatar != null) {
            int frame = (int)((HeadFrameType)event.source()).headFrameType;
            this.ivAvatar.setHeadFrame(((IHonorService)this.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(frame));
        }
    }

    public void onClick(View v) {
        if (v.getTag(R.id.chat_message_data) instanceof ChatMessageData && this.getEventCallback() != null) {
            this.getEventCallback().onUserAvatarClick(((ChatMessageData)v.getTag((int)R.id.chat_message_data)).message.getUid(), 8);
        }
    }
}

