/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import android.text.TextUtils;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import com.yy.im.model.StrangerMessage;
import java.util.ArrayList;
import java.util.List;

public class StrangerEntranceSession
extends ChatSession<StrangerMessage> {
    private static final String TAG = "StrangerEntranceSession";
    private ChatSession mFirstSession;
    private KvoBinder mBinder;

    public StrangerEntranceSession(StrangerMessage mLastMessage) {
        super(4, mLastMessage);
    }

    @Override
    public void initial() {
        if (this.mBinder == null) {
            this.mBinder = new KvoBinder((Object)this);
        }
        StrangerMessage msg = (StrangerMessage)this.getLastMessage();
        this.setAvatarType(2);
        this.setUnReadType(1);
        this.setTitleBold(true);
        this.setBgColor(R.drawable.shape_corner_59c1ff);
        this.setDefaultAvatar(R.drawable.shape_corner_33000000);
        this.setTitle(ResourceUtils.getString((int)R.string.title_stranger_message));
        this.setSessionId("-3");
        this.setSessionFrom("0");
        List<ChatSession> sessions = msg.chatSessions;
        IUserInfoService service2 = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        if (!FP.empty(sessions)) {
            ChatSession session;
            int unread = 0;
            ArrayList<String> urls = new ArrayList<String>(4);
            for (ChatSession session2 : sessions) {
                List<String> avatars;
                if (urls.size() < 4 && (avatars = session2.getAvatarUrls()) != null && !avatars.isEmpty()) {
                    urls.add(avatars.get(0));
                }
                unread += session2.getUnReadCounts();
            }
            this.setUnReadCounts(unread);
            this.setAvatarUrls(urls);
            if (urls.size() > 1) {
                this.setAvatarType(2);
            } else {
                this.setAvatarType(0);
            }
            this.mFirstSession = session = sessions.get(0);
            this.setTimeStr(session.getTimeStr());
            this.setPresentationTime(session.getTimeStr());
            UserInfoKS info = session.getUserInfo();
            if (info == null) {
                info = service2.getUserInfo(session.getUid());
            }
            if (info != null) {
                if (info.isLoadFinish()) {
                    this.updateSubTitle(info);
                } else {
                    this.mBinder.singleBindSourceTo((KvoSource)info);
                }
            }
            this.setUnReadType(1);
        }
    }

    @KvoMethodAnnotation(name="nick", sourceClass=UserInfoKS.class, thread=1)
    public void onUserInfoChange(KvoEventIntent event) {
        if (this.mFirstSession != null) {
            UserInfoKS info = (UserInfoKS)event.source();
            this.updateSubTitle(info);
        }
    }

    private void updateSubTitle(UserInfoKS info) {
        if (!FP.anyNull((Object[])new Object[]{info, info.nick, this.mFirstSession, this.mFirstSession.getSubTitle()})) {
            this.setSubTitle(TextUtils.concat((CharSequence[])new CharSequence[]{info.nick, ":", this.mFirstSession.getSubTitle()}));
        }
    }

    @Override
    public void setPresentWeight(int presentWeight) {
        if (SystemUtils.isShowEnvSetting()) {
            throw new UnsupportedOperationException("Cannot Set present weight");
        }
    }

    @Override
    public int getPresentWeight() {
        return 3;
    }
}

