/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.model;

import android.text.TextUtils;
import com.yy.appbase.im.SessionUnread;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.im.ImModuleData;
import com.yy.im.R;
import com.yy.im.model.ChatSession;
import com.yy.im.model.OfficialAccountEntranceMessage;
import java.util.ArrayList;
import java.util.List;

public class OfficialAccountEntranceSession
extends ChatSession<OfficialAccountEntranceMessage> {
    private static final String TAG = "OfficialAccountEntranceSession";
    private ChatSession mFirstSession;
    private boolean binded = false;
    private KvoBinder mBinder = null;

    public OfficialAccountEntranceSession(OfficialAccountEntranceMessage mLastMessage) {
        super(14, mLastMessage);
    }

    @Override
    public void initial() {
        if (this.mBinder == null) {
            this.mBinder = new KvoBinder((Object)this);
        }
        this.setAvatarType(2);
        OfficialAccountEntranceMessage msg = (OfficialAccountEntranceMessage)this.getLastMessage();
        List<ChatSession> sessions = msg.chatSessions;
        ArrayList<String> urls = new ArrayList<String>();
        this.setTitle(ResourceUtils.getString((int)R.string.title_activity_account));
        this.setTitleBold(true);
        this.setDefaultAvatar(R.drawable.shape_corner_ffd04e);
        this.setBgColor(R.drawable.shape_corner_59c1ff);
        this.setSessionId("-8");
        this.setSessionFrom("0");
        if (!FP.empty(sessions)) {
            ChatSession session;
            for (ChatSession session2 : sessions) {
                List<String> avatars = session2.getAvatarUrls();
                if (avatars == null) {
                    avatars = new ArrayList<String>();
                }
                if (avatars.isEmpty()) {
                    avatars.add("");
                }
                urls.addAll(avatars);
            }
            this.setAvatarUrls(urls);
            this.mFirstSession = session = sessions.get(0);
            this.updateSubTitle();
            this.setTimeStr(session.getTimeStr());
            this.setPresentationTime(session.getPresentationTime());
            ImModuleData data2 = (ImModuleData)KvoModuleManager.getModuleData(ImModule.class);
            if (data2 != null && !this.binded) {
                this.mBinder.singleBindSourceTo((KvoSource)data2.mOfficialAccountSessionUnread);
                this.binded = true;
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=SessionUnread.class, name="count", thread=1)
    public void onUnReadChange(KvoEventIntent event) {
        Integer newValue = (Integer)event.caseNewValue((Object)0);
        MLog.info((Object)TAG, (String)"onUnReadChange %s", (Object[])new Object[]{newValue});
        this.setUnReadCounts(newValue);
    }

    @KvoMethodAnnotation(sourceClass=SessionUnread.class, name="redPoints", thread=1)
    public void onUnReadTypeChange(KvoEventIntent event) {
        Boolean newValue = (Boolean)event.caseNewValue((Object)false);
        MLog.info((Object)TAG, (String)"onUnReadType %s", (Object[])new Object[]{newValue});
        if (newValue.booleanValue()) {
            this.setUnReadType(1);
        } else {
            this.setUnReadType(0);
        }
    }

    private void updateSubTitle() {
        if (!FP.anyNull((Object[])new Object[]{this.mFirstSession, this.mFirstSession.getTitle(), this.mFirstSession.getSubTitle()})) {
            this.setSubTitle(TextUtils.concat((CharSequence[])new CharSequence[]{this.mFirstSession.getTitle(), ": ", this.mFirstSession.getSubTitle()}));
        }
    }
}

