/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.findfriend.v1.ui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.im.R;
import com.yy.im.findfriend.v1.bean.IconData;
import com.yy.im.findfriend.v1.ui.IconView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class IconRowView
extends ViewGroup
implements View.OnClickListener {
    private IconViewAdapter mAdapter;
    private boolean mShowEntrance;
    private int mRows;
    private int mViewType;
    private List<IconData> mIconDatas = new ArrayList<IconData>();
    private List<IconData> mRealAddedIcons = new ArrayList<IconData>();
    public static final int DEFAULT_ROW_ITEM_SIZE = 5;
    public static final int DEFAULT_ROW_MARGIN = ResolutionUtils.dip2Px((float)23.0f);
    public static final int DEFAULT_VIEW_MARGIN_PARENT = ResolutionUtils.dip2Px((float)15.0f);

    public IconRowView(Context context) {
        super(context);
        this.setBackgroundColor(ResourceUtils.getColor((int)R.color.white));
    }

    public IconRowView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IconRowView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAdapter(IconViewAdapter adapter2) {
        this.reset();
        this.mAdapter = adapter2;
        if (adapter2 == null || adapter2.getAllItems() == null || adapter2.getAllItems().isEmpty()) {
            this.notifyDataSetChange();
            return;
        }
        List<IconData> iconDatas = adapter2.getAllItems();
        this.mIconDatas.addAll(iconDatas);
        this.mShowEntrance = adapter2.showMoreEntrance();
        this.mViewType = adapter2.getType();
        this.mRows = this.getRowsWithType(iconDatas.size(), 5, this.mViewType);
        this.notifyDataSetChange();
    }

    private void addViews() {
        if (this.mAdapter != null) {
            int size = 0;
            size = this.mAdapter.adjustSingleLine() ? this.mIconDatas.size() : Math.min(this.mIconDatas.size(), this.mRows * 5);
            this.mRealAddedIcons.addAll(this.mIconDatas.subList(0, size));
        }
        for (int i = 0; i < this.mRealAddedIcons.size(); ++i) {
            IconView view = null;
            view = new IconView(this.getContext());
            this.addView((View)view, new ViewGroup.LayoutParams(-2, -2));
            view.setTag(this.mRealAddedIcons.get(i));
            view.setData(this.mRealAddedIcons.get(i));
            view.setOnClickListener(this);
        }
        this.requestLayout();
    }

    private int getRowsWithType(int total, int sizePerRow, int type) {
        int row = 0;
        if (total == 0 || sizePerRow == 0) {
            return row;
        }
        if (type == 0) {
            row = total / sizePerRow + (total % sizePerRow == 0 ? 0 : 1);
        } else if (type == 1) {
            if (total < sizePerRow) {
                return row;
            }
            row = total / sizePerRow;
        }
        return row;
    }

    private void reset() {
        this.mRows = 0;
        this.mIconDatas.clear();
        this.mRealAddedIcons.clear();
        this.mShowEntrance = false;
        this.mViewType = 1;
    }

    private void notifyDataSetChange() {
        if (this.mIconDatas == null || this.mIconDatas.isEmpty()) {
            this.removeAllViews();
            return;
        }
        this.addViews();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        if (this.mRealAddedIcons == null || this.mRealAddedIcons.isEmpty()) {
            this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
            return;
        }
        if (this.mRows >= 1) {
            int rowHeights = this.getChildAt(0).getMeasuredHeight() * this.mRows;
            int rowMargins = (this.mRows - 1) * DEFAULT_ROW_MARGIN;
            this.setMeasuredDimension(width, rowHeights + rowMargins);
        } else {
            this.setMeasuredDimension(width, height);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mRows == 0) {
            return;
        }
        int currentL = 0;
        int currentT = 0;
        int childWidth = this.getChildAt(0).getMeasuredWidth();
        int childHigh = this.getChildAt(0).getMeasuredHeight();
        int childWidths = 5 * childWidth;
        int leftRightMargins = DEFAULT_VIEW_MARGIN_PARENT * 2;
        int restWidth = this.getWidth() - childWidths - leftRightMargins;
        int middleGapwidth = restWidth / 4;
        for (int i = 0; i < this.getChildCount(); ++i) {
            currentL = i % 5 == 0 ? DEFAULT_VIEW_MARGIN_PARENT : (currentL += childWidth + middleGapwidth);
            if (i % 5 == 0) {
                currentT = i / 5 * (childHigh + DEFAULT_ROW_MARGIN);
            }
            this.getChildAt(i).layout(currentL, currentT, currentL + childWidth, currentT + childHigh);
        }
    }

    public void onClick(View v) {
        if (this.mAdapter != null) {
            this.mAdapter.onItemClick((IconData)v.getTag());
        }
    }

    public static abstract class IconViewAdapter {
        public static final int TYPE_REAL = 0;
        public static final int TYPE_SUMMARY = 1;

        public abstract boolean showMoreEntrance();

        public abstract List<IconData> getAllItems();

        public abstract void onItemClick(IconData var1);

        public int getType() {
            return 1;
        }

        public boolean adjustSingleLine() {
            return true;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IconType {
        }
    }
}

