/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.findfriend.v1.ui;

import android.content.Context;
import android.graphics.Rect;
import android.text.TextPaint;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.im.R;
import com.yy.im.findfriend.v1.bean.ChannelItem;
import java.util.ArrayList;
import java.util.List;

public class FindChannelAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements View.OnClickListener {
    private static final int TYPE_CHANNEL = 0;
    private static final int TYPE_SPACE = 1;
    private List<ChannelItem> mDatas = new ArrayList<ChannelItem>();
    private OnItemClickListener itemClickListener;

    public void setData(List<ChannelItem> channelList) {
        this.mDatas.clear();
        if (channelList != null) {
            for (ChannelItem channelItem : channelList) {
                this.mDatas.add(new ChannelItem(5));
                this.mDatas.add(channelItem);
            }
            this.mDatas.add(new ChannelItem(5));
        }
        this.notifyDataSetChanged();
    }

    public void setItemClickListener(OnItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new IntervalViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_interval, parent, false));
        }
        return new FindFriendsChannelViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_finded_channel, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (position < 0 || position >= this.mDatas.size()) {
            return;
        }
        if (this.getItemViewType(position) == 0) {
            FindFriendsChannelViewHolder viewHolder = (FindFriendsChannelViewHolder)holder;
            viewHolder.update(position, this.mDatas.get(position));
            viewHolder.setOnClickListener(this);
            viewHolder.bgChannel.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            v.setAlpha(0.6f);
                            break;
                        }
                        case 1: 
                        case 3: {
                            v.setAlpha(1.0f);
                            break;
                        }
                    }
                    return false;
                }
            });
        }
    }

    public int getItemCount() {
        if (this.mDatas == null || this.mDatas.isEmpty()) {
            return 0;
        }
        return this.mDatas.size();
    }

    public int getItemViewType(int position) {
        if (this.mDatas.get(position).getType() == 5) {
            return 1;
        }
        return 0;
    }

    public void onClick(View v) {
        Integer position = (Integer)v.getTag();
        if (position == null || position < 0 || position >= this.mDatas.size()) {
            return;
        }
        if (this.itemClickListener == null) {
            return;
        }
        this.itemClickListener.onItemClicked(position, this.mDatas.get(position));
    }

    public static interface OnItemClickListener {
        public void onItemClicked(int var1, ChannelItem var2);
    }

    public class FindFriendsChannelViewHolder
    extends RecyclerView.ViewHolder {
        private YYTextView channel;
        private YYLinearLayout bgChannel;
        private int maxWidth;
        private int mTextWidth;
        private int singleWidth;

        public FindFriendsChannelViewHolder(View itemView) {
            super(itemView);
            this.maxWidth = 0;
            this.mTextWidth = 0;
            this.singleWidth = 0;
            this.channel = (YYTextView)itemView.findViewById(R.id.tv_channel);
            this.bgChannel = (YYLinearLayout)itemView.findViewById(R.id.bg_channel);
            Rect bounds = new Rect();
            TextPaint paint = this.channel.getPaint();
            if (FindChannelAdapter.this.mDatas != null) {
                for (ChannelItem channelItem : FindChannelAdapter.this.mDatas) {
                    if (channelItem.getFindFriendsChannel() != null && FindChannelAdapter.this.mDatas.size() == 3) {
                        if (this.singleWidth == 0) {
                            this.singleWidth = ScreenUtils.getInstance().getWidthPixels() - ResolutionUtils.dip2Px((float)76.0f);
                        }
                        this.maxWidth = this.singleWidth;
                        continue;
                    }
                    if (channelItem.getFindFriendsChannel() == null) continue;
                    paint.getTextBounds(channelItem.getFindFriendsChannel(), 0, channelItem.getFindFriendsChannel().length(), bounds);
                    this.mTextWidth = bounds.width();
                    if (this.mTextWidth <= this.maxWidth) continue;
                    this.maxWidth = this.mTextWidth;
                }
                if (this.maxWidth != 0) {
                    this.bgChannel.setMinimumWidth(this.maxWidth + ResolutionUtils.dip2Px((float)48.0f));
                }
            }
        }

        public void setOnClickListener(View.OnClickListener onClickListener) {
            this.bgChannel.setOnClickListener(onClickListener);
        }

        public void update(int position, ChannelItem channelItem) {
            if (channelItem == null) {
                return;
            }
            this.channel.setText((CharSequence)channelItem.getFindFriendsChannel());
            this.bgChannel.setBackgroundResource(channelItem.getChannelBackGround());
            this.bgChannel.setTag((Object)position);
        }
    }

    public static class IntervalViewHolder
    extends RecyclerView.ViewHolder {
        public IntervalViewHolder(View itemView) {
            super(itemView);
        }
    }
}

