/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.os.Message;
import android.view.View;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.im.interfaces.ISearchViewCallback;
import com.yy.im.msg.ImModuleMsgDef;
import com.yy.im.msg.ImNotificationDef;
import com.yy.im.ui.window.SearchFriendWindow;
import com.yy.im.viewmodel.BizViewModel;
import com.yy.im.viewmodel.FriendListViewModel;
import com.yy.im.viewmodel.SearchFriendViewModel;

public class SearchFriendController
extends DefaultWindowController
implements ISearchViewCallback {
    private SearchFriendViewModel mViewModel;
    private FriendListViewModel mFriendListVM = BizViewModel.getVM(this.getActivity(), FriendListViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
    private SearchFriendWindow mWindow;
    private boolean popWithAnim = true;

    public SearchFriendController(Environment env) {
        super(env);
        this.mViewModel = BizViewModel.getVM(this.getActivity(), SearchFriendViewModel.class, this.getServiceManager(), this.mDialogLinkManager);
        this.mViewModel.setmFriendListVM(this.mFriendListVM);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ImModuleMsgDef.OPEN_SEARCH_FRIEND_PAGE) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mWindow = new SearchFriendWindow(this.mContext, this.mViewModel, (UICallBacks)this, this);
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            this.popWithAnim = true;
        } else if (msg.what == ImModuleMsgDef.POP_SEARCH_FRIEND_PAGE) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mWindow = new SearchFriendWindow(this.mContext, this.mViewModel, (UICallBacks)this, this);
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, false);
            this.popWithAnim = false;
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == ImNotificationDef.IM_OPEN_SEARCH_FRIENDS_PAGE) {
            this.sendMessage(ImModuleMsgDef.OPEN_SEARCH_FRIEND_PAGE);
        } else if (notification.id == ImNotificationDef.IM_POP_SEARCH_FRIENDS_PAGE) {
            this.sendMessage(ImModuleMsgDef.POP_SEARCH_FRIEND_PAGE);
        }
    }

    @Override
    public void onSearchBackClick(View view) {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(this.popWithAnim, (AbstractWindow)this.mWindow);
        }
    }

    protected boolean onWindowBackKeyEvent() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(this.popWithAnim, (AbstractWindow)this.mWindow);
        }
        return true;
    }

    public void onWindowAttach(AbstractWindow abstractWindow) {
        super.onWindowAttach(abstractWindow);
        if (this.mViewModel != null) {
            this.mViewModel.onWindowAttach();
        }
        if (this.mFriendListVM != null) {
            this.mFriendListVM.onWindowAttach();
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mViewModel != null) {
            this.mViewModel.onWindowDetach();
        }
        if (this.mFriendListVM != null) {
            this.mFriendListVM.onWindowDetach();
        }
        this.mWindow = null;
    }
}

