/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.controller;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.OutOfLineBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ReportMsgDef;
import com.yy.hiyo.im.base.MsgData;
import com.yy.hiyo.im.base.data.IIMdata;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.im.module.room.callback.Callback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public enum ImOufOfLineManager {
    INSTANCE;

    private static final String TAG = "ImOufOfLineManager";
    private HashMap<String, OutOfLineBean> mOutOfLineData;
    private static final String SHARE_PRE_NAME = "im_out_of_line";
    private static final String KEY_CLICK_AT = "CLICK_AT";
    private static final String DATE = "date";
    private static final String REPEAT_NUM_SHOW = "repeatNumShow";
    private static final String SENSITIVE_NUM_SHOW = "sensitiveNumShow";
    private static final int REPORT_MSG_SIZE = 30;
    private Callback<OutOfLineBean> mOutOfLineListener;
    private MyBox<OutOfLineBean> mDbBox;
    private boolean isInRoom = false;
    private boolean isTodayFirstShow = true;
    private boolean isShowGoSettingPrompt = true;
    private int sensitiveShowTimes = 0;
    private int repeatShowTimes = 0;
    private static final int REPEAT_NUM = 5;
    private static final int SENSITIVE_NUM = 3;
    private boolean repeatNumShow = true;
    private boolean sensitiveNumShow = true;
    private boolean isNeedWriteRepeatNumShow = true;
    private boolean isNeedWriteSensitiveNumShow = true;
    private boolean isNeedWriteDate = true;
    private boolean isAddGoSettingMessage = true;
    private boolean isReply = false;
    private UserInfoKS mMyUserInfo;
    private UserInfoKS mTargetUserInfo;
    private String keyId;

    public void setDbBox(MyBox<OutOfLineBean> dbBox) {
        this.mDbBox = dbBox;
        this.mOutOfLineData = new HashMap(1);
        if (this.mDbBox != null) {
            this.mDbBox.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<OutOfLineBean>(){

                public void onLoaded(ArrayList<OutOfLineBean> datas) {
                    for (OutOfLineBean item : datas) {
                        ImOufOfLineManager.this.mOutOfLineData.put(item.seq, item);
                    }
                }
            });
        }
    }

    public void updateDb(@Nonnull OutOfLineBean bean) {
        if (this.mDbBox != null) {
            this.mDbBox.updateItem((BaseDBBean)bean, false);
        }
    }

    public void onReceiveOutOfLine(MsgData item) {
        MLog.info((Object)TAG, (String)"onReceiveOutOfLine %s, isInRoom %b", (Object[])new Object[]{item, this.isInRoom});
        try {
            String msg = item.getMsg();
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)msg);
            final OutOfLineBean data2 = (OutOfLineBean)JsonParser.parseJsonObject((String)jsonObject.optString("ofl"), OutOfLineBean.class);
            long targetUid = data2 != null ? data2.uid : 0L;
            boolean isClicked = this.isClickedToday(targetUid);
            MLog.info((Object)TAG, (String)"onReceiveOutOfLine %b", (Object[])new Object[]{isClicked});
            if (data2 != null && !FP.empty((CharSequence)data2.seq) && !isClicked) {
                data2.isShowInUi = this.isInRoom;
                data2.outOfLineSeq = item.getSeq();
                this.mOutOfLineData.put(data2.seq, data2);
                if (this.mDbBox != null) {
                    this.mDbBox.addItem((BaseDBBean)data2);
                }
                if (this.mOutOfLineListener != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ImOufOfLineManager.this.mOutOfLineListener.onResponse(data2);
                        }
                    });
                }
            }
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public boolean isOutOfLine(@Nonnull ImMessageDBBean bean, long targetUid) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"isOutOfLine targetUid %s, seq: %s, content: %s", (Object[])new Object[]{targetUid, bean.getMsgId(), bean.getContent()});
        }
        if (this.mOutOfLineData == null || bean.getMsgId() == 0L) {
            return false;
        }
        String seq = String.valueOf(bean.getMsgId());
        OutOfLineBean outOfLine = this.mOutOfLineData != null ? this.mOutOfLineData.get(seq) : null;
        return !FP.empty((CharSequence)seq) && outOfLine != null;
    }

    public boolean isShowOutOfLineUi(@Nonnull ImMessageDBBean bean, long targetUid) {
        if (this.isClickedToday(targetUid) || this.mOutOfLineData == null || bean.getMsgId() == 0L) {
            return false;
        }
        String seq = String.valueOf(bean.getMsgId());
        OutOfLineBean outOfLine = this.mOutOfLineData != null ? this.mOutOfLineData.get(seq) : null;
        return !FP.empty((CharSequence)seq) && outOfLine != null && outOfLine.isShowInUi && !outOfLine.isNeverShow;
    }

    public boolean isFriend(long targetUid) {
        return this.getFollowStatus() == Relation.FRIEND;
    }

    public boolean isClickedToday(long targetUid) {
        int blockAt = this.getPreference().getInt(KEY_CLICK_AT + targetUid + "_" + AccountUtil.getUid(), -1);
        int today = Calendar.getInstance().get(6);
        return blockAt != -1 && today == blockAt;
    }

    @Nullable
    public OutOfLineBean getOutOfLine(String seq) {
        return this.mOutOfLineData != null ? this.mOutOfLineData.get(seq) : null;
    }

    public void onBlock(long targetUid, @Nullable Callback<Boolean> callback) {
        this.updateActionAt(targetUid);
    }

    private void updateActionAt(long targetUid) {
        this.getPreference().edit().putInt(KEY_CLICK_AT + targetUid + "_" + AccountUtil.getUid(), Calendar.getInstance().get(6)).apply();
    }

    public void onReportOutOfLine(final @Nonnull DefaultController controller, final long targetUid, List<IIMdata> messageList, int position, final Callback<Boolean> callback) {
        this.updateActionAt(targetUid);
        final ArrayList<String> contentList = new ArrayList<String>();
        int size = 0;
        for (int i = position - 1; i >= 0 && size < 30; --i) {
            ImMessageDBBean item = messageList.get(i).getMessageDBBean();
            if (item.getUid() != targetUid) continue;
            ++size;
            contentList.add(item.getContent());
        }
        MLog.info((Object)TAG, (String)"onReportOutOfLine content %s", (Object[])new Object[]{contentList});
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                Bundle bundle = new Bundle();
                bundle.putLong("targetUid", targetUid);
                bundle.putStringArrayList("textList", contentList);
                Message message = Message.obtain();
                message.setData(bundle);
                message.what = ReportMsgDef.IMG_TEXT;
                message.arg1 = 0;
                message.replyTo = new Messenger(new Handler(Looper.getMainLooper()){

                    public void handleMessage(Message msg) {
                        super.handleMessage(msg);
                        if (msg.obj instanceof Boolean) {
                            boolean isSuccess = (Boolean)msg.obj;
                            if (callback != null) {
                                callback.onResponse(isSuccess);
                            }
                        }
                    }
                });
                controller.sendMessage(message);
            }
        });
    }

    public void onNoMoreNoticeToday(long targetUid) {
        this.updateActionAt(targetUid);
    }

    private SharedPreferences getPreference() {
        return SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, SHARE_PRE_NAME, 0);
    }

    public void setOutOfLineListener(Callback<OutOfLineBean> outOfLineListener) {
        this.mOutOfLineListener = outOfLineListener;
    }

    public void hideAll() {
        if (this.mOutOfLineData != null && !this.mOutOfLineData.isEmpty()) {
            Set<String> keys = this.mOutOfLineData.keySet();
            ArrayList<String> beanList = new ArrayList<String>(this.mOutOfLineData.size());
            for (String key : keys) {
                OutOfLineBean item = this.mOutOfLineData.get(key);
                beanList.add(item.seq);
            }
            if (this.mDbBox != null) {
                this.mDbBox.deleteByIndexs(beanList);
            }
        }
    }

    public void onRoomEnter() {
        this.isInRoom = true;
    }

    public void onRoomExit() {
        this.isInRoom = false;
        this.mOutOfLineListener = null;
    }

    public void initIsTodayDate() {
        if (this.mMyUserInfo == null || this.mTargetUserInfo == null) {
            MLog.error((Object)TAG, (String)"initIsTodayDate fail, mMyUserInfo or mTargetUserInfo is null", (Object[])new Object[0]);
            return;
        }
        this.repeatNumShow = true;
        this.sensitiveNumShow = true;
        this.isNeedWriteRepeatNumShow = true;
        this.isNeedWriteSensitiveNumShow = true;
        this.isNeedWriteDate = true;
        this.isTodayFirstShow = true;
        this.isShowGoSettingPrompt = true;
        this.keyId = this.mMyUserInfo.uid + "and" + this.mTargetUserInfo.uid;
        String date = SettingFlags.getStringValue((String)(this.keyId + DATE));
        if (!TextUtils.isEmpty((CharSequence)date) && DateUtils.isToday((Calendar)Calendar.getInstance(), (long)DateUtils.stringtoDate((String)date, (String)"yyyy-MM-dd").getTime())) {
            this.isTodayFirstShow = false;
        } else {
            this.isTodayFirstShow = true;
            SettingFlags.setBoolean((String)(this.keyId + REPEAT_NUM_SHOW), (boolean)true);
            SettingFlags.setBoolean((String)(this.keyId + SENSITIVE_NUM_SHOW), (boolean)true);
        }
        this.repeatNumShow = SettingFlags.getBoolean((String)(this.keyId + REPEAT_NUM_SHOW), (boolean)true);
        this.sensitiveNumShow = SettingFlags.getBoolean((String)(this.keyId + SENSITIVE_NUM_SHOW), (boolean)true);
        if (SettingFlags.containKey((String)(AccountUtil.getUid() + "match_gender"))) {
            this.isShowGoSettingPrompt = false;
        }
        MLog.info((Object)TAG, (String)"initIsTodayDate keyId= %s, repeatNumShow = %s, sensitiveNumShow = %s, isShowGoSettingPrompt = %s, isTodayFirstShow = %s", (Object[])new Object[]{this.keyId, this.repeatNumShow, this.sensitiveNumShow, this.isShowGoSettingPrompt, this.isTodayFirstShow});
    }

    public void resetRepeatTimes(ImMessageDBBean msg) {
        if (this.mMyUserInfo != null && msg.getUid() == this.mMyUserInfo.uid) {
            this.repeatShowTimes = 0;
            this.isReply = true;
        }
    }

    public void updateUserInfo(UserInfoKS mMyUserInfo, UserInfoKS mTargetUserInfo) {
        this.mMyUserInfo = mMyUserInfo;
        this.mTargetUserInfo = mTargetUserInfo;
    }

    public boolean isRepeatSensitiveShow(ImMessageDBBean msg) {
        if (this.mMyUserInfo == null || this.mTargetUserInfo == null || msg == null || this.getFollowStatus() == Relation.NONE) {
            MLog.error((Object)TAG, (String)"isRepeatSensitiveShow fail, mMyUserInfo,mTargetUserInfo,msg or relationship is null", (Object[])new Object[0]);
            return false;
        }
        if (this.isShowGoSettingPrompt && this.getFollowStatus() != Relation.FRIEND && DateUtils.isToday((Calendar)Calendar.getInstance(), (long)msg.getSendTime()) && this.mMyUserInfo.sex == UserInfoKS.FEMALE && this.mMyUserInfo != null && msg.getUid() != this.mMyUserInfo.uid && this.repeatShowTimes < 5 && this.repeatNumShow && !this.isReply) {
            ++this.repeatShowTimes;
            if (this.repeatShowTimes == 5) {
                if (this.isNeedWriteDate) {
                    SettingFlags.setStringValue((String)(this.keyId + DATE), (String)DateUtils.getNow());
                    this.isNeedWriteDate = false;
                    MLog.info((Object)TAG, (String)"updateDate repeatShow isNeedWriteDate=%s", (Object[])new Object[]{this.isNeedWriteDate});
                }
                if (this.isNeedWriteRepeatNumShow) {
                    SettingFlags.setBoolean((String)(this.keyId + REPEAT_NUM_SHOW), (boolean)false);
                    this.isNeedWriteRepeatNumShow = false;
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "tips_show").put("act_uid", String.valueOf(this.mTargetUserInfo.uid)));
                    MLog.info((Object)TAG, (String)"updateDate repeatShow isNeedWriteRepeatNumShow=%s", (Object[])new Object[]{this.isNeedWriteRepeatNumShow});
                }
                return true;
            }
        }
        return false;
    }

    public boolean isSensitiveShow(ImMessageDBBean msg) {
        if (msg != null && !DateUtils.isToday((Calendar)Calendar.getInstance(), (long)msg.getSendTime())) {
            return false;
        }
        if (this.mMyUserInfo == null || this.mTargetUserInfo == null || this.getFollowStatus() == Relation.NONE) {
            MLog.error((Object)TAG, (String)"isSensitiveShow fail, mMyUserInfo or mTargetUserInfo or relationship is null", (Object[])new Object[0]);
            return false;
        }
        if (this.isShowGoSettingPrompt && this.getFollowStatus() != Relation.FRIEND && this.mMyUserInfo.sex == UserInfoKS.FEMALE && this.sensitiveShowTimes < 3 && this.sensitiveNumShow) {
            ++this.sensitiveShowTimes;
            if (this.sensitiveShowTimes == 3) {
                if (this.isNeedWriteDate) {
                    SettingFlags.setStringValue((String)(this.keyId + DATE), (String)DateUtils.getNow());
                    this.isNeedWriteDate = false;
                }
                if (this.isNeedWriteSensitiveNumShow) {
                    SettingFlags.setBoolean((String)(this.keyId + SENSITIVE_NUM_SHOW), (boolean)false);
                    this.isNeedWriteSensitiveNumShow = false;
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023799").put("function_id", "tips_show").put("act_uid", String.valueOf(this.mTargetUserInfo.uid)));
                }
                return true;
            }
        }
        return false;
    }

    public void resetAllTimes() {
        this.repeatShowTimes = 0;
        this.sensitiveShowTimes = 0;
        this.isReply = false;
    }

    public boolean getIsAddGoSettingMessage() {
        return this.isAddGoSettingMessage;
    }

    public void setIsAddGoSettingMessage(boolean addGoSettingMessage) {
        this.isAddGoSettingMessage = addGoSettingMessage;
    }

    private Relation getFollowStatus() {
        if (this.mTargetUserInfo == null) {
            return Relation.NONE;
        }
        IRelationService service2 = (IRelationService)ServiceManagerProxy.getService(IRelationService.class);
        if (service2 == null) {
            return Relation.NONE;
        }
        return service2.getRelationLocal(this.mTargetUserInfo.uid).getRelation();
    }
}

