/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.cim;

import android.content.Context;
import android.os.Build;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.IMRPC;
import com.hummer.im._internals.log.Log;
import com.hummer.im._internals.services.user.UserService;
import com.hummer.im._internals.shared.ServiceProvider;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;
import com.hummer.im.model.id.User;
import com.hummer.im.service.Channel;
import com.hummer.im.service.MQService;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.hiyo.im.base.PushTagManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.ICIMProtoCallback;
import com.yy.hiyo.proto.callback.ICIMProtoNotify;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.im.cim.CIMMsgItem;
import com.yy.im.protocol.MsgProtocolSwitch;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.ihago.base.srv.pubsubgroup.ClearGroupReq;
import net.ihago.base.srv.pubsubgroup.ClearGroupRes;
import net.ihago.base.srv.pubsubgroup.SubGroupReq;
import net.ihago.base.srv.pubsubgroup.SubGroupRes;
import net.ihago.base.srv.pubsubgroup.UnsubGroupReq;
import net.ihago.base.srv.pubsubgroup.UnsubGroupRes;
import net.ihago.im.api.imcheck.CheckUseCimRequest;
import net.ihago.im.api.imcheck.CheckUseCimResponse;

public enum CIMModule {
    INSTANCE;

    private static final String TAG = "[Hago-CIM]";
    private static boolean sInitSuccess;
    private static Channel sChannel;
    private long mConnectedTS = 0L;
    private long mAppId = 0L;
    private String region;
    private Channel.StateChangedListener mChanneStateListener;
    protected final CIMProtoNotifyImpl mNotifyListener = new CIMProtoNotifyImpl(1);
    protected final CIMProtoNotifyImpl mGroupNotifyListener = new CIMProtoNotifyImpl(2);
    private final Set<Channel.NotificationHandler> handlers = new HashSet<Channel.NotificationHandler>();
    private long mMySelfUid = 0L;
    private long mSeq = System.currentTimeMillis();

    public boolean init(Context appContext, long appId, String region) {
        if (sChannel == null) {
            Log.setLogger((lv, msg) -> {
                if (6 == lv) {
                    MLog.error((Object)TAG, (String)msg, (Object[])new Object[0]);
                } else if (4 == lv) {
                    MLog.info((Object)TAG, (String)msg, (Object[])new Object[0]);
                } else if (RuntimeContext.sIsDebuggable) {
                    MLog.debug((Object)TAG, (String)msg, (Object[])new Object[0]);
                }
            });
            try {
                sChannel = new Channel(){

                    public void run(Channel.RPC channelRpc) {
                        byte[] requestPayLoad;
                        if (!(channelRpc instanceof IMRPC)) {
                            return;
                        }
                        final IMRPC rpc = (IMRPC)channelRpc;
                        try {
                            requestPayLoad = rpc.getRequestBytes();
                            if (requestPayLoad == null) {
                                rpc.handleError(new Error(1002, "Can't acquire data from RPC object", (Object)rpc));
                                return;
                            }
                        }
                        catch (Throwable e) {
                            MLog.debug((Object)CIMModule.TAG, (String)"ClientExceptions, Exception happened:%s", (Object[])new Object[]{e});
                            rpc.handleError(new Error(1000, "Exception happened:", (Object)e));
                            return;
                        }
                        final User currentMe = HMR.getMe();
                        final Integer[] retryCount = new Integer[]{0, 0};
                        String funcName = rpc.getHummerFunction();
                        ProtoManager.getInstance().sendCIMRpc("cim.private.hago.proxy", "ProxyService/" + funcName, requestPayLoad, (ICIMProtoCallback)new ICIMProtoCallback<byte[]>(){

                            public void onResponse(@Nullable byte[] message) {
                                if (currentMe != HMR.getMe()) {
                                    MLog.error((Object)CIMModule.TAG, (String)"Overdue success response", (Object[])new Object[0]);
                                    rpc.handleError(new Error(1000, "Overdue rpc response bcz Me has been changed!", (Object)message));
                                    return;
                                }
                                MLog.info((Object)CIMModule.TAG, (String)("Success wss rpc:" + message), (Object[])new Object[0]);
                                if (message != null) {
                                    try {
                                        rpc.handleResponse(message);
                                    }
                                    catch (Throwable t) {
                                        Log.e((String)CIMModule.TAG, (Object)("handle rpc response error, e: " + t));
                                    }
                                } else {
                                    rpc.handleError(new Error(2001, "Empty wss rpc respone"));
                                }
                            }

                            public boolean retryWhenTimeout(boolean canRetry) {
                                MLog.error((Object)CIMModule.TAG, (String)("Timeout wss rpc,retryCount:" + retryCount[0]), (Object[])new Object[0]);
                                Integer n = retryCount[0];
                                Integer[] integerArray = retryCount;
                                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                                if (!canRetry || retryCount[0] >= 3) {
                                    rpc.handleError(new Error(1005, "Wss rpc timeout"));
                                    return false;
                                }
                                return true;
                            }

                            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                                MLog.error((Object)CIMModule.TAG, (String)("Fail wss rpc:" + reason + ",retryCount:" + retryCount[0]), (Object[])new Object[0]);
                                Integer n = retryCount[0];
                                Integer[] integerArray = retryCount;
                                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                                if (!canRetry || code == 4000 || code == 4004 || code == 4002 || code == 100 || retryCount[0] >= 3) {
                                    rpc.handleError(new Error(1003, "wss rpc error(" + code + "," + reason + ")"));
                                    return false;
                                }
                                return true;
                            }
                        });
                    }

                    public void addNotificationHandler(Channel.NotificationHandler observer2) {
                        MLog.info((Object)CIMModule.TAG, (String)"addNotificationHandler", (Object[])new Object[0]);
                        CIMModule.this.addHandler(observer2);
                    }

                    public void removeNotificationHandler(Channel.NotificationHandler observer2) {
                        CIMModule.this.removeHandler(observer2);
                    }

                    public void subscribeDigitGroups(List<Pair<Long, Long>> groups, RichCompletion completion) {
                    }

                    public void unSubscribeDigitGroups(List<Pair<Long, Long>> groups, RichCompletion completion) {
                    }

                    public void addStateListener(Channel.StateChangedListener stateChangedListener) {
                        MLog.info((Object)CIMModule.TAG, (String)("addStateListener:" + stateChangedListener), (Object[])new Object[0]);
                        CIMModule.this.mChanneStateListener = stateChangedListener;
                    }

                    public void removeStateListener(Channel.StateChangedListener stateChangedListener) {
                        MLog.info((Object)CIMModule.TAG, (String)("removeStateListener:" + stateChangedListener), (Object[])new Object[0]);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CIMModule.this.mChanneStateListener = null;
                            }
                        });
                    }

                    public void subscribeGroupcasts(@NonNull Set<String> groups, final @Nullable HMR.Completion completion) {
                        if (groups == null || groups.size() <= 0) {
                            MLog.error((Object)CIMModule.TAG, (String)"subscribeGroupcast empty!", (Object[])new Object[0]);
                            return;
                        }
                        MLog.info((Object)CIMModule.TAG, (String)"subscribeGroupcast", (Object[])new Object[0]);
                        SubGroupReq subGroupReq = new SubGroupReq.Builder().seqid(Long.valueOf(CIMModule.this.uniqueSeq())).uid(Long.valueOf(AccountUtil.getUid())).groups(new ArrayList<String>(groups)).build();
                        final User currentMe = HMR.getMe();
                        final Integer[] retryCount = new Integer[]{0, 0};
                        ProtoManager.getInstance().sendRpc((AndroidMessage)subGroupReq, (IProtoCallback)new IProtoCallback<SubGroupRes>(){

                            public void onResponse(@NonNull SubGroupRes message, long code, String msg) {
                                if (currentMe != HMR.getMe()) {
                                    MLog.error((Object)CIMModule.TAG, (String)"Overdue success response", (Object[])new Object[0]);
                                    completion.onFailed(new Error(1000, "Overdue rpc response bcz Me has been changed!", (Object)message));
                                    return;
                                }
                                if (completion != null) {
                                    completion.onSuccess();
                                }
                            }

                            public boolean retryWhenTimeout(boolean canRetry) {
                                MLog.error((Object)CIMModule.TAG, (String)("Timeout subscribe group,retryCount:" + retryCount[0]), (Object[])new Object[0]);
                                Integer n = retryCount[0];
                                Integer[] integerArray = retryCount;
                                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                                if (!canRetry || retryCount[0] >= 3) {
                                    completion.onFailed(new Error(1005, "subscribe rpc timeout"));
                                    return false;
                                }
                                return true;
                            }

                            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                                MLog.error((Object)CIMModule.TAG, (String)("Fail unsubscribe group, reason:" + reason + ",retryCount:" + retryCount[0]), (Object[])new Object[0]);
                                Integer n = retryCount[0];
                                Integer[] integerArray = retryCount;
                                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                                if (!canRetry || code == 4000 || code == 4004 || code == 4002 || code == 100 || retryCount[0] >= 3) {
                                    completion.onFailed(new Error(1003, "unsubscribe error(" + code + "," + reason + ")"));
                                    return false;
                                }
                                return true;
                            }
                        });
                    }

                    public void unsubscribeGroupcasts(@NonNull Set<String> groups, final @Nullable HMR.Completion completion) {
                        if (groups == null || groups.size() <= 0) {
                            MLog.error((Object)CIMModule.TAG, (String)"unsubscribeGroupcast empty!", (Object[])new Object[0]);
                            return;
                        }
                        MLog.info((Object)CIMModule.TAG, (String)"unsubscribeGroupcast", (Object[])new Object[0]);
                        UnsubGroupReq unsubGroupReq = new UnsubGroupReq.Builder().seqid(Long.valueOf(CIMModule.this.uniqueSeq())).uid(Long.valueOf(AccountUtil.getUid())).groups(new ArrayList<String>(groups)).build();
                        final User currentMe = HMR.getMe();
                        final Integer[] retryCount = new Integer[]{0, 0};
                        ProtoManager.getInstance().sendRpc((AndroidMessage)unsubGroupReq, (IProtoCallback)new IProtoCallback<UnsubGroupRes>(){

                            public void onResponse(@NonNull UnsubGroupRes message, long code, String msg) {
                                if (currentMe != HMR.getMe()) {
                                    MLog.error((Object)CIMModule.TAG, (String)"Overdue success response", (Object[])new Object[0]);
                                    if (completion != null) {
                                        completion.onFailed(new Error(1000, "Overdue rpc response bcz Me has been changed!", (Object)message));
                                    }
                                    return;
                                }
                                if (completion != null) {
                                    completion.onSuccess();
                                }
                            }

                            public boolean retryWhenTimeout(boolean canRetry) {
                                MLog.error((Object)CIMModule.TAG, (String)("Timeout unsubscribe group,retryCount:" + retryCount[0]), (Object[])new Object[0]);
                                Integer n = retryCount[0];
                                Integer[] integerArray = retryCount;
                                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                                if (!canRetry || retryCount[0] >= 3) {
                                    if (completion != null) {
                                        completion.onFailed(new Error(1005, "unsubscribe rpc timeout"));
                                    }
                                    return false;
                                }
                                return true;
                            }

                            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                                MLog.error((Object)CIMModule.TAG, (String)("Fail unsubscribe group, reason:" + reason + ",retryCount:" + retryCount[0]), (Object[])new Object[0]);
                                Integer n = retryCount[0];
                                Integer[] integerArray = retryCount;
                                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                                if (!canRetry || code == 4000 || code == 4004 || code == 4002 || code == 100 || retryCount[0] >= 3) {
                                    if (completion != null) {
                                        completion.onFailed(new Error(1003, "unsubscriberpc error(" + code + "," + reason + ")"));
                                    }
                                    return false;
                                }
                                return true;
                            }
                        });
                    }

                    public void setChannelBindResultHandler(Channel.ChannelBindResultHandler handler) {
                    }

                    public void addTokenInvalidHandler(Channel.TokenInvalidHandler handler) {
                    }

                    public void removeTokenInvalidHandler(Channel.TokenInvalidHandler handler) {
                    }

                    public void refreshToken(String token) {
                    }

                    public void refreshToken(String token, RichCompletion completion) {
                    }

                    public long getLastSyncServerTs() {
                        return 0L;
                    }

                    public long getAlignmentServerTs() {
                        return 0L;
                    }

                    public long getInstanceId() {
                        return 0L;
                    }

                    public void initService() {
                    }

                    public void openService(@NonNull RichCompletion completion) {
                        CompletionUtils.dispatchSuccess((RichCompletion)completion);
                    }

                    public void closeService() {
                    }

                    public Class[] staticDependencies() {
                        return null;
                    }

                    public Class[] inherentDynamicDependencies() {
                        return new Class[]{UserService.class};
                    }

                    public Class[] plantingDynamicDependencies() {
                        return null;
                    }
                };
                ServiceProvider.register(Channel.class, (ServiceProvider.Service)sChannel);
                if (!sInitSuccess) {
                    HMR.init((Context)appContext, (long)appId, null);
                }
                CIMMsgItem.registerCodecs();
                this.region = region;
                sInitSuccess = true;
            }
            catch (Throwable e) {
                sInitSuccess = false;
                MLog.error((Object)TAG, (String)("Init CIM error:" + e), (Object[])new Object[0]);
            }
        }
        MLog.info((Object)TAG, (String)"channel: %@", (Object[])new Object[]{HMR.getService(Channel.class)});
        return sInitSuccess;
    }

    public void notifyChannelConncected() {
        this.mConnectedTS = System.currentTimeMillis();
        if (this.mChanneStateListener != null) {
            MLog.info((Object)TAG, (String)"notify ws connected", (Object[])new Object[0]);
            this.mChanneStateListener.onChannelConnected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHandler(Channel.NotificationHandler handler) {
        Set<Channel.NotificationHandler> set2 = this.handlers;
        synchronized (set2) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHandler(Channel.NotificationHandler handler) {
        Set<Channel.NotificationHandler> set2 = this.handlers;
        synchronized (set2) {
            this.handlers.remove(handler);
        }
    }

    public void open(long uid, IOpenCallBack callBack) {
        if (!sInitSuccess) {
            MLog.info((Object)TAG, (String)"not init for cim", (Object[])new Object[0]);
            if (callBack != null) {
                callBack.onError(-1, "cim not init!");
            }
            return;
        }
        if (uid <= 0L) {
            if (callBack != null) {
                callBack.onError(-1, "no uid for cim!");
            }
            MLog.info((Object)TAG, (String)"no uid for cim", (Object[])new Object[0]);
            return;
        }
        if (this.mMySelfUid == uid && HMR.getState() == HMR.State.Opened) {
            if (callBack != null) {
                callBack.onsuccess();
            }
            return;
        }
        this.clearSubscribe(uid);
        this.mMySelfUid = uid;
        MLog.info((Object)TAG, (String)("open for cim, uid:" + uid), (Object[])new Object[0]);
        this.open(uid, MQService.FetchStrategy.Continuously, callBack);
        ProtoManager.getInstance().registerCIMNotify((ICIMProtoNotify)this.mNotifyListener);
        ProtoManager.getInstance().registerCIMNotify((ICIMProtoNotify)this.mGroupNotifyListener);
    }

    private void clearSubscribe(final long uid) {
        ClearGroupReq clearGroupReq = new ClearGroupReq.Builder().seqid(Long.valueOf(this.uniqueSeq())).uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)clearGroupReq, (IProtoCallback)new IProtoCallback<ClearGroupRes>(){

            public void onResponse(@NonNull ClearGroupRes message, long code, String msg) {
                MLog.info((Object)CIMModule.TAG, (String)("clear group success, uid: " + uid), (Object[])new Object[0]);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)CIMModule.TAG, (String)"clear group req, retryWhenTimeout:%b, uid:%d", (Object[])new Object[]{canRetry, uid});
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)CIMModule.TAG, (String)"clear group req, retryWhenTimeout:%b, reason:%s, code:%d, uid:%d", (Object[])new Object[]{canRetry, reason, code, uid});
                return false;
            }
        });
    }

    public void reset() {
        if (!sInitSuccess) {
            MLog.info((Object)TAG, (String)"not init for cim", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"reset cim", (Object[])new Object[0]);
        ProtoManager.getInstance().unregisterCIMNotify((ICIMProtoNotify)this.mNotifyListener);
        ProtoManager.getInstance().unregisterCIMNotify((ICIMProtoNotify)this.mGroupNotifyListener);
        this.mMySelfUid = 0L;
        HMR.close(null);
        sChannel = null;
    }

    private void open(long uid, MQService.FetchStrategy syncStrategy, final IOpenCallBack callBack) {
        List tagList;
        if (!sInitSuccess) {
            MLog.info((Object)TAG, (String)"not init for cim", (Object[])new Object[0]);
            if (callBack != null) {
                callBack.onError(-1, "cim init fail!");
            }
            return;
        }
        MLog.info((Object)TAG, (String)("start open cim:" + uid + ",msg sync strategy:" + syncStrategy), (Object[])new Object[0]);
        HashSet<String> tags = new HashSet<String>();
        tags.add(SystemUtils.getLang());
        if (!PushTagManager.isInited()) {
            PushTagManager.initTag();
        }
        if ((tagList = PushTagManager.getTagList()) != null && !tagList.isEmpty()) {
            int len = tagList.size();
            for (int i = 1; i < len; i += 2) {
                String item = (String)tagList.get(i);
                if (item != null && item.contains("country_")) {
                    item = item.toLowerCase();
                }
                tags.add(item);
            }
        } else {
            MLog.error((Object)TAG, (String)("no push tags for uid:" + uid), (Object[])new Object[0]);
        }
        HMR.Completion completion = new HMR.Completion(){

            public void onSuccess() {
                MLog.info((Object)CIMModule.TAG, (String)"open success!", (Object[])new Object[0]);
                if (callBack != null) {
                    callBack.onsuccess();
                }
            }

            public void onFailed(Error error) {
                if (error != null) {
                    MLog.error((Object)CIMModule.TAG, (String)"open error code:%d, tips:%s!", (Object[])new Object[]{error.code, error.desc});
                    if (callBack != null) {
                        callBack.onError(error.code, error.desc);
                    }
                } else {
                    if (callBack != null) {
                        callBack.onError(-1, "");
                    }
                    MLog.error((Object)CIMModule.TAG, (String)"open error code:%d, tips:%s!", (Object[])new Object[]{-1, ""});
                }
            }
        };
        HMR.open((long)uid, (String)this.region, tags, (HMR.Completion)completion);
    }

    private void reportTemporary(long startTS, String uri, long rtt, int code, String funcName, long logId) {
        if (!ProtoManager.getInstance().isWSConnected() || this.mConnectedTS == 0L) {
            return;
        }
        if (startTS < this.mConnectedTS && this.mConnectedTS - startTS > 5000L) {
            MLog.info((Object)TAG, (String)"may be no net work for cim", (Object[])new Object[0]);
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("report one uri:" + uri + ",code:" + code), (Object[])new Object[0]);
        }
        HiidoStatis.reportReturnCode((int)50216, (String)uri, (long)rtt, (String)String.format(Locale.US, "%d", code));
    }

    private void requestSwitch(final IOpenCallBack callBack) {
        final long logId = System.currentTimeMillis();
        CheckUseCimRequest cimcheck = new CheckUseCimRequest.Builder().self_uid(Long.valueOf(AccountUtil.getUid())).log_id(Long.valueOf(logId)).os_type("Android").os_version(Build.VERSION.RELEASE).model_name(Build.MODEL).cim_sdk_version(HMR.getVersion()).hago_app_version(VersionUtil.getVersionWithoutSnpashot((Context)RuntimeContext.sApplicationContext)).build();
        final User currentMe = HMR.getMe();
        final boolean previousSwitch = MsgProtocolSwitch.INSTANCE.isSwitch();
        final Integer[] retryCount = new Integer[]{0, 0};
        MLog.info((Object)TAG, (String)("CIM Check Switch logId=" + logId + ",cimver=" + cimcheck.cim_sdk_version + ",appver=" + cimcheck.hago_app_version), (Object[])new Object[0]);
        final long startTS = System.currentTimeMillis();
        String funcName = "CheckUseCim";
        ProtoManager.getInstance().sendCIMRpc("net.ihago.im.srv.imcheck", "ImCheck.CheckUseCim", cimcheck.encode(), (ICIMProtoCallback)new ICIMProtoCallback<byte[]>(){

            public void onResponse(@Nullable byte[] message) {
                if (currentMe != HMR.getMe()) {
                    MLog.error((Object)CIMModule.TAG, (String)"Overdue success response", (Object[])new Object[0]);
                    return;
                }
                if (message != null) {
                    try {
                        CheckUseCimResponse cimcheckRes = (CheckUseCimResponse)CheckUseCimResponse.ADAPTER.decode(message);
                        MLog.info((Object)CIMModule.TAG, (String)("Success CIM Check Switch logId=" + cimcheckRes.log_id), (Object[])new Object[0]);
                        MsgProtocolSwitch.INSTANCE.setIsSwitch(cimcheckRes.is_use_cim);
                        long endTS = System.currentTimeMillis();
                        long rtt = endTS - startTS;
                        CIMModule.this.reportTemporary(startTS, "CheckUseCim/" + CIMModule.this.mAppId, rtt, 0, "CheckUseCim", logId);
                        if (!previousSwitch && MsgProtocolSwitch.INSTANCE.isSwitch()) {
                            HMR.close(null);
                            CIMModule.this.open(AccountUtil.getUid(), MQService.FetchStrategy.SkipFetched, callBack);
                        } else if (previousSwitch && !MsgProtocolSwitch.INSTANCE.isSwitch()) {
                            HMR.close(null);
                        } else if (callBack != null) {
                            callBack.onError(-1, "already open or switch is off");
                        }
                    }
                    catch (Exception ex) {
                        MLog.error((Object)CIMModule.TAG, (String)("Invalid CIM Check Switch Response:" + ex.getMessage()), (Object[])new Object[0]);
                        CIMModule.this.reportTemporary(startTS, "CheckUseCim/" + CIMModule.this.mAppId, 0L, 2000, "CheckUseCim", logId);
                    }
                } else {
                    MLog.error((Object)CIMModule.TAG, (String)("Invalid CIM Check Switch Response:" + null), (Object[])new Object[0]);
                    CIMModule.this.reportTemporary(startTS, "CheckUseCim/" + CIMModule.this.mAppId, 0L, 2001, "CheckUseCim", logId);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)CIMModule.TAG, (String)("Timeout CIM Check Switch,retryCount:" + retryCount[0]), (Object[])new Object[0]);
                Integer n = retryCount[0];
                Integer[] integerArray = retryCount;
                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                if (!canRetry || retryCount[0] >= 3) {
                    CIMModule.this.reportTemporary(startTS, "CheckUseCim/" + CIMModule.this.mAppId, 0L, 1005, "CheckUseCim", logId);
                    return false;
                }
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)CIMModule.TAG, (String)("Fail CIM Check Switch:" + reason + ",retryCount:" + retryCount[0]), (Object[])new Object[0]);
                Integer n = retryCount[0];
                Integer[] integerArray = retryCount;
                Integer n2 = integerArray[0] = Integer.valueOf(integerArray[0] + 1);
                if (!canRetry || code == 4000 || code == 4004 || code == 4002 || code == 100 || retryCount[0] >= 3) {
                    CIMModule.this.reportTemporary(startTS, "cproxy_error", 0L, code, "cproxy_error", logId);
                    return false;
                }
                return true;
            }
        });
    }

    public synchronized long uniqueSeq() {
        long cur = System.currentTimeMillis();
        this.mSeq = cur > this.mSeq ? cur : ++this.mSeq;
        return this.mSeq;
    }

    static {
        sInitSuccess = false;
        sChannel = null;
    }

    public static interface IOpenCallBack {
        public void onsuccess();

        public void onError(int var1, String var2);
    }

    private class CIMProtoNotifyImpl
    implements ICIMProtoNotify<byte[]> {
        private int uri;

        public CIMProtoNotifyImpl(int uri) {
            this.uri = uri;
        }

        public int uri() {
            return this.uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNotify(@NonNull byte[] data2) {
            MLog.info((Object)CIMModule.TAG, (String)"on new cim msg notify", (Object[])new Object[0]);
            Set set2 = CIMModule.this.handlers;
            synchronized (set2) {
                for (Channel.NotificationHandler handler : CIMModule.this.handlers) {
                    if (this.uri == 1) {
                        handler.onNotify("service_api_gateway", "cim.proto.PushService.IMPushMsg", data2);
                        continue;
                    }
                    if (this.uri != 2) continue;
                    handler.onNotify("service_api_gateway", "cim.proto.PushService.IMPushGroupSysMsg", data2);
                }
            }
        }
    }
}

