/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.R;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.IMsgReqCallback;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.im.base.PushTagManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.im.R;
import common.Header;
import ikxd.msg.AckMsgReq;
import ikxd.msg.ERet;
import ikxd.msg.IM;
import ikxd.msg.PullMsgReq;
import ikxd.msg.SendMsgReq;
import ikxd.msg.Uri;
import java.util.ArrayList;
import java.util.List;

public enum MsgProtocolHelper {
    Instance;

    private static final String TAG = "MsgProtocolHelper";
    public static final long TIME_OUT_ERROR_CODE = -10000L;
    public static final String TIME_OUT_ERROR = "\u8d85\u6642\u9519\u8bef";

    public IM initAckMsgReq(List<String> segList, Header header2) {
        AckMsgReq.Builder builder = new AckMsgReq.Builder();
        builder.seqs(segList);
        AckMsgReq ackMsgReq = builder.front(Boolean.valueOf(true)).build();
        IM message = new IM.Builder().header(header2).uri(Uri.kUriAckMsgReq).ack_msg_req(ackMsgReq).build();
        return message;
    }

    public IM initMsgReq(ImMsgReqParam param) {
        return this.initMsgReq(param, System.currentTimeMillis());
    }

    public IM initMsgReq(ImMsgReqParam param, long ts) {
        Header header2 = ProtoManager.getInstance().getHeader("ikxd_msg_d");
        SendMsgReq req = new SendMsgReq.Builder().msg_type(Long.valueOf(param.getMsgType())).msg_innertype(Long.valueOf(param.getInnerType())).session_id(TextUtils.isEmpty((CharSequence)param.getSessionId()) ? Utils.getSessionId((long)param.getFromUid(), (long)param.getToUid()) : param.getSessionId()).msg(param.getMsg()).seq("" + ts).push_title(param.getPushTitle()).nopush(Boolean.valueOf(param.isNopush())).push_content(param.getPushContent()).push_payload(param.getPushPayload()).build();
        IM message = new IM.Builder().header(header2).uri(Uri.kUriSendMsgReq).send_msg_req(req).build();
        FeatureLog.i((String)"FTMessage", (String)"sendMessage:%s ts:%s", (Object[])new Object[]{param.getMsg(), ts});
        return message;
    }

    public IM initPullMsgReq(long pullType) {
        ArrayList tags = PushTagManager.getTagList();
        tags = tags == null ? new ArrayList() : new ArrayList(tags);
        PullMsgReq req = new PullMsgReq.Builder().tags(tags).pull_type(Long.valueOf(pullType)).build();
        Header header2 = ProtoManager.getInstance().getHeader("ikxd_msg_d");
        IM message = new IM.Builder().header(header2).uri(Uri.kUriPullMsgReq).pull_msg_req(req).build();
        return message;
    }

    public void sendRequest(IM request2, final IMsgReqCallback<IM> callback, final boolean retry) {
        ProtoManager.getInstance().send((AndroidMessage)request2, (IProtoCallback)new IProtoCallback<IM>(){

            public void onResponse(@Nullable IM message) {
                if (message == null || message.header == null) {
                    FeatureLog.e((String)"FTMessage", (String)"\u8f6c\u6362Header\u51fa\u9519:", (Object[])new Object[0]);
                    return;
                }
                Header header2 = message.header;
                FeatureLog.i((String)"FTMessage", (String)("\u6d88\u606f\u53d1\u9001:" + ProtoManager.getInstance().getResponseError(FP.orInt((Long)header2.code))), (Object[])new Object[0]);
                if (header2.code == 0L || header2.code == (long)ERet.kRetAIIllegalImage.getValue()) {
                    if (callback != null) {
                        callback.onSucceed((Object)message);
                    }
                } else {
                    if (header2.code == 7L) {
                        TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tip_im_server_overloaded), (int)0, (int)ResourceUtils.getColor((int)R.color.error_toast_bg), (boolean)false);
                    }
                    if (callback != null) {
                        callback.onFailed(header2.code.longValue(), ProtoManager.getInstance().getResponseError(FP.orInt((Long)header2.code)));
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (callback != null) {
                    callback.onFailed(-10000L, MsgProtocolHelper.TIME_OUT_ERROR);
                }
                return retry;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (callback != null) {
                    callback.onFailed((long)code, reason);
                }
                if (code == 4000 || code == 4004 || code == 4002) {
                    return false;
                }
                if (code == 100) {
                    return false;
                }
                return retry;
            }
        });
    }

    public static interface IMsgRequestCallback {
        public void onSucceed(IM var1);

        public void onFailed(long var1, String var3);
    }
}

