/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.im.base;

import com.yy.appbase.common.Callback;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.im.base.RecommendGameBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public enum ImRecommendGameInfoManager {
    INSTANCE;

    private static final String TAG = "ImRecommendGameInfoManager";
    private Map<Long, RecommendGameBean> mImTargetUidRecommendGameMap = new HashMap<Long, RecommendGameBean>();
    private List<String> mImGameIdList;
    private boolean mCurrentIsRecommend = false;
    private String mCurrentRecommendGameId;
    private long mTargetUid;
    private String mMatchReason;
    private int mMatchReasonType;
    private List<GameInfo> newGameList;
    IGameLifecycle mGameLifeWrapper = new GameLifeWrapper(){

        public void onPlayGameStart(GamePlayContext context) {
            UserInfoKS userInfoKS;
            if (context != null && context.getGameInfo() != null && context.getGameInfo().getGameMode() == 1 && (userInfoKS = context.getOtherUserInfo()) != null) {
                long targetUid = userInfoKS.getUid();
                ImRecommendGameInfoManager.this.requestIMRecommendGameInfoList(targetUid, ImRecommendGameInfoManager.this.getIMDrawerGameIdList());
            }
        }
    };

    public void init() {
        if (ServiceManagerProxy.getServiceManager() != null) {
            ServiceManagerProxy.getServiceManager().observeService(IGameCenterService.class, (Callback)new Callback<IGameCenterService>(){

                public void onResponse(IGameCenterService data) {
                    data.registerGameLifecycle(ImRecommendGameInfoManager.this.mGameLifeWrapper);
                }
            });
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ServiceManagerProxy.getServiceManager() != null) {
                        ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle(ImRecommendGameInfoManager.this.mGameLifeWrapper);
                    }
                }
            }, (long)2000L);
        }
    }

    public void requestIMRecommendGameInfoList(long uid) {
        this.requestIMRecommendGameInfoList(uid, this.getIMDrawerGameIdList());
    }

    private void requestIMRecommendGameInfoList(long uid, List<String> gameIds) {
        int recType;
        JSONObject jsonObject;
        block4: {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"requestIMRecommendGameInfoList uid=%d", (Object[])new Object[]{uid});
            }
            if (gameIds == null || gameIds.size() == 0) {
                return;
            }
            JSONArray uidsArray = new JSONArray();
            uidsArray.put(uid);
            JSONArray gameIdsArray = new JSONArray(gameIds);
            jsonObject = JsonParser.obtainJSONObject();
            recType = 0;
            try {
                jsonObject.put("uids", (Object)uidsArray);
                recType = 1;
                jsonObject.put("recType", recType);
            }
            catch (JSONException e) {
                if (!MLog.isLogLevelBlowInfo()) break block4;
                MLog.info((Object)TAG, (String)"getIMRecommendGameInfoList e=%s", (Object[])new Object[]{e});
            }
        }
        final int finalRecType = recType;
        HttpUtil.httpReqPostForJson((String)UriProvider.getRecommendImGameListUrl(), (String)jsonObject.toString(), null, (INetRespCallback)new INetRespCallback<RecommendGameBean>(){

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ImRecommendGameInfoManager.TAG, (String)"onError id=%d, Exception = %s", (Object[])new Object[]{id2, e});
                }
            }

            public void onResponse(String response, BaseResponseBean<RecommendGameBean> res, int id2) {
                MLog.debug((Object)ImRecommendGameInfoManager.TAG, (String)"onResponse %d, %d, response=%s", (Object[])new Object[]{id2, finalRecType, response});
                if (res != null && res.isSuccess() && res.data != null) {
                    List<GameInfo> list;
                    RecommendGameBean recommendGameBean = (RecommendGameBean)res.data;
                    if (ImRecommendGameInfoManager.this.newGameList == null) {
                        ImRecommendGameInfoManager.this.newGameList = new ArrayList();
                    }
                    if ((list = ImRecommendGameInfoManager.this.parseGameInfoList(recommendGameBean)) != null) {
                        ImRecommendGameInfoManager.this.newGameList.clear();
                        ImRecommendGameInfoManager.this.newGameList.addAll(list);
                    }
                }
            }
        });
    }

    public List<String> getIMDrawerGameIdList() {
        if (this.mImGameIdList != null) {
            return this.mImGameIdList;
        }
        this.mImGameIdList = new CopyOnWriteArrayList<String>();
        List imDrawerGameInfoList = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getIMGameInfoList();
        if (imDrawerGameInfoList != null && imDrawerGameInfoList.size() > 0) {
            for (GameInfo gameInfo : imDrawerGameInfoList) {
                if (gameInfo == null) continue;
                this.mImGameIdList.add(gameInfo.gid);
            }
        }
        return this.mImGameIdList;
    }

    public void clearImTargetUidRecommendGameData() {
        this.mImTargetUidRecommendGameMap.clear();
    }

    public List<GameInfo> getImRecommendGameInfoList(long targetUid) {
        return this.getImRecommendGameInfoListNew();
    }

    public List<GameInfo> getImRecommendGameInfoListNew() {
        return this.newGameList;
    }

    public List<GameInfo> getImRecommendGameInfoListOld(long targetUid) {
        if (this.mImTargetUidRecommendGameMap.containsKey(targetUid)) {
            RecommendGameBean recommendGameBean = this.mImTargetUidRecommendGameMap.get(targetUid);
            return this.parseGameInfoList(recommendGameBean);
        }
        return null;
    }

    public List<GameInfo> parseGameInfoList(RecommendGameBean recommendGameBean) {
        block4: {
            try {
                RecommendGameBean.GameReasonListBean gameReasonListBean;
                List<RecommendGameBean.GameReasonListBean> gameReasonLists;
                if (recommendGameBean != null && recommendGameBean.mUserGames != null && (gameReasonLists = recommendGameBean.mUserGames).size() > 0 && (gameReasonListBean = gameReasonLists.get(0)) != null && gameReasonListBean.games != null) {
                    ArrayList<GameInfo> gameInfoList = new ArrayList<GameInfo>();
                    for (RecommendGameBean.GameReason gameReason : gameReasonListBean.games) {
                        GameInfo gameInfo;
                        if (StringUtils.isEmpty((String)gameReason.gameid) || (gameInfo = ((IGameInfoService)ServiceManagerProxy.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameReason.gameid)) == null) continue;
                        gameInfoList.add(gameInfo);
                    }
                    return gameInfoList;
                }
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block4;
                MLog.info((Object)TAG, (String)"parseGameInfoList Exception=%s", (Object[])new Object[]{e});
            }
        }
        return null;
    }

    public RecommendGameBean.GameReason getCurrentImRecommendReason() {
        block5: {
            try {
                RecommendGameBean.GameReasonListBean gameReasonListBean;
                List<RecommendGameBean.GameReasonListBean> gameReasonLists;
                RecommendGameBean recommendGameBean;
                if (this.mImTargetUidRecommendGameMap.containsKey(this.mTargetUid) && (recommendGameBean = this.mImTargetUidRecommendGameMap.get(this.mTargetUid)) != null && recommendGameBean.mUserGames != null && (gameReasonLists = recommendGameBean.mUserGames).size() > 0 && (gameReasonListBean = gameReasonLists.get(0)) != null && gameReasonListBean.uid == this.mTargetUid && gameReasonListBean.games != null && gameReasonListBean.games.size() > 0) {
                    RecommendGameBean.GameReason gameReason = gameReasonListBean.games.get(0);
                    if (!StringUtils.isEmpty((String)gameReason.gameid)) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)TAG, (String)"gameReason.gameid=%s, gameReason.reason=%s", (Object[])new Object[]{gameReason.gameid, gameReason.reason});
                        }
                        return gameReason;
                    }
                }
            }
            catch (Exception e) {
                if (!MLog.isLogLevelBlowInfo()) break block5;
                MLog.info((Object)TAG, (String)"getCurrentImRecommendReason Exception=%s", (Object[])new Object[]{e});
            }
        }
        return null;
    }

    public String getToken(long targetUid) {
        RecommendGameBean recommendGameBean;
        if (this.mImTargetUidRecommendGameMap.containsKey(targetUid) && (recommendGameBean = this.mImTargetUidRecommendGameMap.get(targetUid)) != null) {
            return recommendGameBean.token;
        }
        return null;
    }

    public void setCurrentImRecommend(boolean isRecommend, String gameId, long targetUid) {
        this.mCurrentIsRecommend = isRecommend;
        this.mCurrentRecommendGameId = gameId;
        this.mTargetUid = targetUid;
    }

    public boolean isCurrentIsRecommend() {
        return this.mCurrentIsRecommend;
    }

    public String getMatchReason() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getMatchReason=%s", (Object[])new Object[]{this.mMatchReason});
        }
        return this.mMatchReason;
    }

    public void setMatchReason(String mMatchReason) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"setMatchReason=%s", (Object[])new Object[]{mMatchReason});
        }
        this.mMatchReason = mMatchReason;
    }

    public int getMatchReasonType() {
        return this.mMatchReasonType;
    }

    public void setMatchReasonType(int matchReasonType) {
        this.mMatchReasonType = matchReasonType;
    }
}

