/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.im;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import com.yy.appbase.permission.checker.ContactsReadTest;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.im.base.ContactBaseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContactUtils {
    private static final String TAG = "ContactUtils";
    private static volatile boolean sNeedCheckContactPermission = true;
    private static volatile boolean sHasContactPermission = false;
    private static volatile boolean sIsUpload = false;
    public static boolean S_CAN_CONTACT_DIALOG_SHOW = ContactBaseUtils.S_CAN_CONTACT_DIALOG_SHOW;

    public static void hasContactPermission(final Activity activity, final IContactPermissionCheckCallBack checkCallBack) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"hasContactPermission", (Object[])new Object[0]);
        }
        S_CAN_CONTACT_DIALOG_SHOW = true;
        final Runnable check = new Runnable(){

            @Override
            public void run() {
                if (!S_CAN_CONTACT_DIALOG_SHOW) {
                    return;
                }
                final boolean has = PermissionHelper.hasContactPermission((Activity)activity);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (checkCallBack != null) {
                            checkCallBack.onHasContactPermissionCallBack(has);
                        }
                    }
                });
            }
        };
        if (Build.VERSION.SDK_INT >= 23) {
            YYTaskExecutor.execute((Runnable)check);
        } else {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    block4: {
                        if (PermissionHelper.hasContactUserTipShow()) {
                            ContactsReadTest test = new ContactsReadTest();
                            try {
                                test.test();
                                if (MLog.isLogLevelBlowInfo()) {
                                    MLog.info((Object)ContactUtils.TAG, (String)"has per!", (Object[])new Object[0]);
                                }
                            }
                            catch (Throwable throwable) {
                                if (!MLog.isLogLevelBlowInfo()) break block4;
                                MLog.info((Object)ContactUtils.TAG, (String)"has no per!", (Object[])new Object[0]);
                            }
                        }
                    }
                    check.run();
                }
            });
        }
    }

    public static void showContactPemissionDialog(Activity activity, IPermissionListener listener) {
        PermissionHelper.requestContactPermission((Activity)activity, (IPermissionListener)listener);
    }

    public static void showQuizContactPemissionDialog(Activity activity, IPermissionListener listener) {
        PermissionHelper.requestQuizContactPermission((Activity)activity, (IPermissionListener)listener);
    }

    public static String getContacts(Context context) throws JSONException {
        List<Contacts> values = ContactUtils.getContactList(context);
        if (values != null && values.size() >= 1000) {
            values = values.subList(0, 1000);
        }
        String country = ContactUtils.getCountry(context);
        String contacts = ContactUtils.formatContacts(country, values);
        if (MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("contacts: " + contacts), (Object[])new Object[0]);
        }
        return contacts;
    }

    private static String getCountry(Context context) {
        String country = SystemUtils.getHagoCountry();
        if (country == null) {
            return "";
        }
        return country.toUpperCase();
    }

    private static String formatContacts(String country, List<Contacts> values) throws JSONException {
        if (MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("formatContacts: " + values.size()), (Object[])new Object[0]);
        }
        JSONObject json = JsonParser.obtainJSONObject();
        json.put("country", (Object)country);
        JSONArray list = new JSONArray();
        JSONObject obj = null;
        JSONArray phones = null;
        JSONObject phone = null;
        for (Contacts contacts : values) {
            obj = JsonParser.obtainJSONObject();
            obj.put("nick", (Object)contacts.name);
            phones = new JSONArray();
            for (String s : contacts.phoneNumbers) {
                phone = JsonParser.obtainJSONObject();
                phone.put("number", (Object)s);
                phones.put((Object)phone);
            }
            obj.put("phone", (Object)phones);
            list.put((Object)obj);
        }
        json.put("list", (Object)list);
        return json.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Contacts> getContactList(Context context) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"getContactList", (Object[])new Object[0]);
        }
        HashMap<Long, Contacts> map = null;
        try (Cursor contactCursor = null;){
            contactCursor = context.getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, new String[]{"_id", "display_name"}, null, null, null);
            map = new HashMap(contactCursor.getCount());
            int idIndex = contactCursor.getColumnIndex("_id");
            int nameIndex = contactCursor.getColumnIndex("display_name");
            contactCursor.moveToFirst();
            while (!contactCursor.isAfterLast()) {
                long id2 = contactCursor.getLong(idIndex);
                String name = contactCursor.getString(nameIndex);
                Contacts contacts = new Contacts(id2, name);
                map.put(id2, contacts);
                contactCursor.moveToNext();
            }
        }
        try (Cursor phoneCursor = null;){
            if (map == null) {
                map = new HashMap<Long, Contacts>();
            }
            phoneCursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, new String[]{"contact_id", "data1"}, null, null, null);
            int idIndex = phoneCursor.getColumnIndex("contact_id");
            int phoneIndex = phoneCursor.getColumnIndex("data1");
            Contacts contacts = null;
            phoneCursor.moveToFirst();
            while (!phoneCursor.isAfterLast()) {
                contacts = (Contacts)map.get(phoneCursor.getLong(idIndex));
                if (contacts != null) {
                    contacts.addPhoneNumber(phoneCursor.getString(phoneIndex));
                }
                phoneCursor.moveToNext();
            }
        }
        if (MLog.isLogLevelAboveDebug()) {
            for (Contacts contacts : map.values()) {
                if (MLog.isLogLevelAboveDebug()) continue;
                MLog.debug((Object)TAG, (String)("contacts: " + contacts.name + ", " + contacts.phoneNumbers), (Object[])new Object[0]);
            }
        }
        return new ArrayList<Contacts>(map.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ContactsBean> getContactListAllNumber(Context context) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"\u83b7\u53d6\u901a\u8baf\u5f55", (Object[])new Object[0]);
        }
        HashMap<Long, String> map = null;
        try (Cursor contactCursor = null;){
            contactCursor = context.getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, new String[]{"_id", "display_name"}, null, null, null);
            map = new HashMap(contactCursor.getCount());
            int idIndex = contactCursor.getColumnIndex("_id");
            int nameIndex = contactCursor.getColumnIndex("display_name");
            contactCursor.moveToFirst();
            while (!contactCursor.isAfterLast()) {
                long id2 = contactCursor.getLong(idIndex);
                String name = contactCursor.getString(nameIndex);
                map.put(id2, name);
                contactCursor.moveToNext();
            }
        }
        ArrayList<ContactsBean> contactsList = new ArrayList<ContactsBean>();
        try (Cursor phoneCursor = null;){
            if (map == null) {
                map = new HashMap<Long, String>();
            }
            phoneCursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, new String[]{"contact_id", "data1"}, null, null, null);
            int idIndex = phoneCursor.getColumnIndex("contact_id");
            int phoneIndex = phoneCursor.getColumnIndex("data1");
            phoneCursor.moveToFirst();
            while (!phoneCursor.isAfterLast()) {
                String name = (String)map.get(phoneCursor.getLong(idIndex));
                String phoneNumber = phoneCursor.getString(phoneIndex).replace(" ", "");
                if (!StringUtils.isEmpty((String)name) && !StringUtils.isEmpty((String)phoneNumber)) {
                    ContactsBean contacts = new ContactsBean(name, phoneNumber, ContactsBean.TYPE_NORMAL);
                    contactsList.add(contacts);
                }
                phoneCursor.moveToNext();
            }
        }
        LinkedHashSet<ContactsBean> set = new LinkedHashSet<ContactsBean>(contactsList.size());
        set.addAll(contactsList);
        contactsList.clear();
        contactsList.addAll(set);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("\u83b7\u53d6\u901a\u8baf\u5f55 size=" + contactsList.size()), (Object[])new Object[0]);
        }
        return contactsList;
    }

    public static final void goToPermissionSetting(Activity activity) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"Contact permission onOk", (Object[])new Object[0]);
        }
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)RuntimeContext.sPackageName, null);
        intent.setData(uri);
        try {
            activity.startActivity(intent);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public static class ContactsBean {
        public static int TYPE_NORMAL = 0;
        public static int TYPE_HEADER = 1;
        private int type;
        private String name;
        private String phoneNumber;

        public ContactsBean(int type) {
            this.type = type;
        }

        public ContactsBean(String name, String phoneNumber, int type) {
            this.name = name;
            this.phoneNumber = phoneNumber;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContactsBean)) {
                return false;
            }
            ContactsBean bean = (ContactsBean)o;
            if (this.name == null || !this.name.equals(bean.name)) {
                return false;
            }
            return this.phoneNumber != null && this.phoneNumber.equals(bean.phoneNumber);
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
            return result;
        }
    }

    private static class Contacts {
        final long id;
        final String name;
        final List<String> phoneNumbers = new ArrayList<String>();

        private Contacts(long id2, String name) {
            this.id = id2;
            this.name = name;
        }

        public Contacts addPhoneNumber(String phoneNumber) {
            this.phoneNumbers.add(phoneNumber);
            return this;
        }
    }

    public static interface IContactPermissionCheckCallBack {
        public void onHasContactPermissionCallBack(boolean var1);
    }
}

