/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.desktopredpoint;

import com.yy.appbase.im.SessionUnread;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.callback.OnUnReadChangeNotify;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.module.desktopredpoint.IUnReadHandler;
import com.yy.hiyo.module.desktopredpoint.IUnreadDelegate;
import com.yy.hiyo.module.desktopredpoint.ServerUnreadBean;
import com.yy.hiyo.module.desktopredpoint.UnreadType;
import org.json.JSONException;
import org.json.JSONObject;

public class MainHandler
implements IUnReadHandler {
    private static final String TAG = "MainHandler";
    private IUnreadDelegate mDelegate;
    private OnUnReadChangeNotify mOnUnreadNotify = new OnUnReadChangeNotify(){

        public void onUnReadChange(SessionUnread sessionUnread) {
            MainHandler.this.mDelegate.setUnreadCount(UnreadType.IM, sessionUnread.getCount());
        }
    };

    public MainHandler(IUnreadDelegate iUnreadDelegate) {
        this.mDelegate = iUnreadDelegate;
    }

    @Override
    public void startWatch() {
        MLog.debug((Object)TAG, (String)"MainHandler startWatch", (Object[])new Object[0]);
        this.mDelegate.reportStartupRedPoint();
        this.mDelegate.resetUnreadCountWhenStartup();
        if (KvoModuleManager.isKvoInitEnved()) {
            ((ImModule)KvoModuleManager.getModule(ImModule.class)).registerUnReadNotify(this.mOnUnreadNotify, true);
        } else {
            KvoModuleManager.addInitEnvCallback((KvoModuleManager.InitEnvCallback)new KvoModuleManager.InitEnvCallback(){

                public void onInitEnv() {
                    ((ImModule)KvoModuleManager.getModule(ImModule.class)).registerUnReadNotify(MainHandler.this.mOnUnreadNotify, true);
                }
            });
        }
    }

    @Override
    public void onReceivePushMsgs(JSONObject jSONObject) {
        if (RuntimeContext.sIsForeground) {
            return;
        }
        if (jSONObject.has("pushsdk")) {
            try {
                MLog.debug((Object)TAG, (String)"receive unread msg", (Object[])new Object[0]);
                JSONObject jSONObject2 = JsonParser.obtainJSONObject((String)jSONObject.optString("pushsdk"));
                if (jSONObject2.has("redpoint")) {
                    ServerUnreadBean serverUnreadBean = (ServerUnreadBean)JsonParser.parseJsonObject((String)jSONObject2.optString("redpoint"), ServerUnreadBean.class);
                    MLog.debug((Object)TAG, (String)("receive unread msg," + serverUnreadBean.getType() + " " + serverUnreadBean.getCount() + " " + serverUnreadBean.getMax()), (Object[])new Object[0]);
                    if (serverUnreadBean == null) {
                        return;
                    }
                    this.mDelegate.updateMaxServerUnreadCount(serverUnreadBean.getMax());
                    if (serverUnreadBean.getType() == 1) {
                        this.mDelegate.increaseUnreadCount(UnreadType.SERVER, serverUnreadBean.getCount());
                        return;
                    }
                    if (serverUnreadBean.getType() == 2) {
                        this.mDelegate.setUnreadCount(UnreadType.SERVER, serverUnreadBean.getCount());
                        return;
                    }
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (jSONObject.has("im") || jSONObject.has("friend")) {
            return;
        }
        this.mDelegate.increaseUnreadCount(UnreadType.PUSH, 1);
    }
}

