/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.desktopredpoint;

import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.module.desktopredpoint.IUnReadHandler;
import com.yy.hiyo.module.desktopredpoint.IUnreadDelegate;
import com.yy.hiyo.module.desktopredpoint.MainHandler;
import com.yy.hiyo.module.desktopredpoint.OtherHandler;
import com.yy.hiyo.module.desktopredpoint.UnreadDelegate;
import com.yy.hiyo.module.desktopredpoint.UnreadType;
import org.json.JSONObject;

public final class UnReadHandler {
    private static final String TAG = "UnReadHandler";
    private boolean mInited = false;
    private IUnreadDelegate mDelegate;
    private IUnReadHandler mIUnReadHandler = null;
    private INotify mNotify = new INotify(){

        public void notify(Notification notification) {
            if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
                if (notification.extObj instanceof Boolean) {
                    if (!((Boolean)notification.extObj).booleanValue()) {
                        UnReadHandler.this.mDelegate.refreshDesktopCount();
                        UnReadHandler.this.mDelegate.reportLeaveRedPoint();
                        RuntimeContext.sStartType = 1;
                    } else {
                        UnReadHandler.this.mDelegate.reportStartupRedPoint();
                        UnReadHandler.this.mDelegate.resetUnreadCountWhenStartup();
                    }
                }
            } else if (notification.id == NotificationIdDef.BADGER_NOTIFY) {
                if (notification.extObj instanceof JSONObject) {
                    UnReadHandler.this.handlePushMsg((JSONObject)notification.extObj);
                }
            } else if (notification.id == NotificationDef.N_DESKTOP_BADGE_REFRESH) {
                MLog.debug((Object)UnReadHandler.TAG, (String)"receive desktop badge refresh", (Object[])new Object[0]);
                UnReadHandler.this.mDelegate.refreshDesktopCount();
            }
        }
    };

    private UnReadHandler() {
        this.mDelegate = new UnreadDelegate();
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_DESKTOP_BADGE_REFRESH, this.mNotify);
    }

    public static UnReadHandler getInstance() {
        return InnerFactory.sInstance;
    }

    public void init() {
        MLog.debug((Object)TAG, (String)("init mInited:" + this.mInited + " mIUnReadHandler:" + this.mIUnReadHandler), (Object[])new Object[0]);
        if (this.mInited) {
            if (this.mIUnReadHandler instanceof MainHandler) {
                MLog.debug((Object)TAG, (String)"mIUnReadHandler is main return!!!", (Object[])new Object[0]);
                return;
            }
            if (!this.isMainStarted()) {
                MLog.debug((Object)TAG, (String)("isMainStarted false" + this.mIUnReadHandler), (Object[])new Object[0]);
                return;
            }
            MLog.debug((Object)TAG, (String)("isMainStarted true" + this.mIUnReadHandler), (Object[])new Object[0]);
        }
        if (this.isMainStarted()) {
            this.mIUnReadHandler = new MainHandler(this.mDelegate);
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, this.mNotify);
            NotificationCenter.getGlobalInstance().register(NotificationIdDef.BADGER_NOTIFY, this.mNotify);
        } else {
            this.mIUnReadHandler = new OtherHandler(this.mDelegate);
        }
        this.mInited = true;
        this.mDelegate.resumeFromLocalStorage();
        this.mIUnReadHandler.startWatch();
    }

    public void onPushMsg(JSONObject jSONObject) {
        if (this.mIUnReadHandler != null && this.mIUnReadHandler instanceof MainHandler) {
            return;
        }
        this.handlePushMsg(jSONObject);
    }

    public void onAlarmRedPoint() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onAlarmRedPoint", (Object[])new Object[0]);
        }
        this.mDelegate.updateAutoTriggerCount();
    }

    public void onUpdateFixedUnread(int n2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onUpdateFixedUnread: " + n2), (Object[])new Object[0]);
        }
        this.mDelegate.setUnreadCount(UnreadType.FIXED, n2);
    }

    public void onFixedUnreadChange(int n2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("onFixedUnreadChange: " + n2), (Object[])new Object[0]);
        }
        this.mDelegate.increaseUnreadCount(UnreadType.FIXED, n2);
    }

    private void handlePushMsg(JSONObject jSONObject) {
        MLog.debug((Object)TAG, (String)("handlePushMsg,payloadJson:" + jSONObject.toString()), (Object[])new Object[0]);
        this.mIUnReadHandler.onReceivePushMsgs(jSONObject);
    }

    private boolean isMainStarted() {
        if (RuntimeContext.sIsAppStarted) {
            MLog.debug((Object)TAG, (String)"isMainStarted true", (Object[])new Object[0]);
            return true;
        }
        MLog.debug((Object)TAG, (String)"isMainStarted false", (Object[])new Object[0]);
        return false;
    }

    private static class InnerFactory {
        private static final UnReadHandler sInstance = new UnReadHandler();

        private InnerFactory() {
        }
    }
}

