/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.x2c;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Trace;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.x2c.IViewCreator;

public final class X2CUtils {
    private static final SparseArray<IViewCreator> sSparseArray = new SparseArray();
    private static boolean sDebug = RuntimeContext.sIsDebuggable;
    private static boolean sEnable = false;

    public static void init(boolean debug) {
    }

    private static void updateEnable() {
        sEnable = SettingFlags.getBoolean((String)"x2c_switch", (boolean)true);
    }

    public static int getResourceIdFromAttr(Context ctx, int attr) {
        TypedValue outValue = new TypedValue();
        Resources.Theme theme = ctx.getTheme();
        theme.resolveAttribute(attr, outValue, true);
        TypedArray typedArray = theme.obtainStyledAttributes(outValue.resourceId, new int[]{attr});
        try {
            return typedArray.getResourceId(0, 0);
        }
        catch (Exception e) {
            typedArray.recycle();
            return 0;
        }
    }

    public static void setContentView(Activity activity, int layoutId) {
        if (activity == null) {
            throw new IllegalArgumentException("Activity must not be null");
        }
        View view = X2CUtils.getView((Context)activity, layoutId);
        if (view != null) {
            activity.setContentView(view);
        } else {
            activity.setContentView(layoutId);
        }
    }

    public static View inflate(Context context, int layoutId, ViewGroup parent) {
        return X2CUtils.inflate(context, layoutId, parent, parent != null);
    }

    public static View mergeInflate(Context context, int layoutId, ViewGroup parent) {
        return X2CUtils.inflate(LayoutInflater.from((Context)context), layoutId, parent, parent != null, true);
    }

    public static View inflate(Context context, int layoutId, ViewGroup parent, boolean attach) {
        return X2CUtils.inflate(LayoutInflater.from((Context)context), layoutId, parent, attach);
    }

    public static View inflate(LayoutInflater inflater, int layoutId, ViewGroup parent) {
        return X2CUtils.inflate(inflater, layoutId, parent, parent != null);
    }

    public static View inflate(LayoutInflater inflater, int layoutId, ViewGroup parent, boolean attach) {
        return X2CUtils.inflate(inflater, layoutId, parent, attach, false);
    }

    public static View inflate(LayoutInflater inflater, int layoutId, ViewGroup parent, boolean attach, boolean merge) {
        View view = X2CUtils.getView(inflater.getContext(), layoutId, (ViewGroup)(merge ? parent : null));
        if (view != null) {
            if (parent != null && attach && !merge) {
                parent.addView(view);
            }
            if (sDebug) {
                Trace.endSection();
            }
            return view;
        }
        if (sDebug && sEnable && Build.VERSION.SDK_INT >= 21) {
            MLog.error((Object)"X2C", (String)String.format("get view fail: %s", layoutId), (Object[])new Object[0]);
        }
        return inflater.inflate(layoutId, parent, attach);
    }

    public static View getView(Context context, int layoutId) {
        return X2CUtils.getView(context, layoutId, null);
    }

    public static View getView(Context context, int layoutId, ViewGroup mergeParent) {
        if (!sEnable) {
            return null;
        }
        IViewCreator creator = (IViewCreator)sSparseArray.get(layoutId);
        String layoutName = null;
        if (creator == null) {
            block9: {
                try {
                    layoutName = context.getResources().getResourceName(layoutId);
                    layoutName = layoutName.substring(layoutName.lastIndexOf("/") + 1);
                    String clzName = "com.yy.hiyo.x2c.X2C_" + layoutName;
                    creator = (IViewCreator)context.getClassLoader().loadClass(clzName).newInstance();
                }
                catch (Exception e) {
                    if (!sDebug || !sEnable) break block9;
                    MLog.error((Object)"X2C", (String)String.format("get view fail: %s, error: %s ", layoutName, e.getMessage()), (Throwable)e, (Object[])new Object[0]);
                }
            }
            if (creator == null) {
                creator = new DefaultCreator();
            }
            sSparseArray.put(layoutId, (Object)creator);
        }
        try {
            if (sDebug) {
                Trace.beginSection((String)("X2C#" + layoutName));
            }
            return creator.createView(context, mergeParent);
        }
        catch (Exception e) {
            if (sDebug && sEnable) {
                MLog.error((Object)"X2C", (String)String.format("createView fail: %s, error: %s ", layoutName, e.getMessage()), (Throwable)e, (Object[])new Object[0]);
            }
            return null;
        }
    }

    private static class DefaultCreator
    implements IViewCreator {
        private DefaultCreator() {
        }

        @Override
        public View createView(Context context, ViewGroup mergeRootParent) {
            return null;
        }
    }
}

