/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.highlight.util;

import android.content.res.Resources;
import android.graphics.RectF;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import com.yy.hiyo.highlight.parameter.HighlightParameter;
import com.yy.hiyo.highlight.shape.HighlightShape;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000f\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u000f\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0000\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\u0012"}, d2={"dp", "", "getDp", "(F)F", "", "(I)I", "sp", "getSp", "calculateHighLightViewRect", "", "Lcom/yy/hiyo/highlight/parameter/HighlightParameter;", "rootView", "Landroid/view/ViewGroup;", "getRectOnScreen", "Landroid/graphics/RectF;", "Landroid/view/View;", "isAttachToWindow", "", "highlight-view_debug"})
public final class ViewUtilsKt {
    public static final boolean isAttachToWindow(@NotNull View $this$isAttachToWindow) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAttachToWindow, (String)"$this$isAttachToWindow");
        return Build.VERSION.SDK_INT >= 19 ? $this$isAttachToWindow.isAttachedToWindow() : $this$isAttachToWindow.getWindowToken() != null;
    }

    @NotNull
    public static final RectF getRectOnScreen(@Nullable View $this$getRectOnScreen) {
        if ($this$getRectOnScreen == null) {
            return new RectF();
        }
        int[] pos = new int[]{0, 0};
        $this$getRectOnScreen.getLocationOnScreen(pos);
        RectF rectF = new RectF();
        boolean bl = false;
        boolean bl2 = false;
        RectF $this$apply = rectF;
        boolean bl3 = false;
        $this$apply.left = pos[0];
        $this$apply.top = pos[1];
        $this$apply.right = (float)pos[0] + (float)$this$getRectOnScreen.getWidth();
        $this$apply.bottom = (float)pos[1] + (float)$this$getRectOnScreen.getHeight();
        return rectF;
    }

    public static final void calculateHighLightViewRect(@NotNull HighlightParameter $this$calculateHighLightViewRect, @NotNull ViewGroup rootView) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$calculateHighLightViewRect, (String)"$this$calculateHighLightViewRect");
            Intrinsics.checkParameterIsNotNull((Object)rootView, (String)"rootView");
            RectF rectOnScreen = ViewUtilsKt.getRectOnScreen($this$calculateHighLightViewRect.getHighLightView$highlight_view_debug());
            int[] rootViewPos = new int[2];
            rootView.getLocationOnScreen(rootViewPos);
            rectOnScreen.left -= (float)rootViewPos[0];
            rectOnScreen.right -= (float)rootViewPos[0];
            rectOnScreen.top -= (float)rootViewPos[1];
            rectOnScreen.bottom -= (float)rootViewPos[1];
            rectOnScreen.left -= (float)rootView.getPaddingLeft();
            rectOnScreen.right -= (float)rootView.getPaddingLeft();
            rectOnScreen.top -= (float)rootView.getPaddingTop();
            rectOnScreen.bottom -= (float)rootView.getPaddingTop();
            $this$calculateHighLightViewRect.setRect$highlight_view_debug(rectOnScreen);
            RectF rectF = $this$calculateHighLightViewRect.getRect$highlight_view_debug();
            boolean bl = false;
            boolean bl2 = false;
            RectF $this$run = rectF;
            boolean bl3 = false;
            $this$run.left -= $this$calculateHighLightViewRect.getHorizontalPadding$highlight_view_debug();
            $this$run.top -= $this$calculateHighLightViewRect.getVerticalPadding$highlight_view_debug();
            $this$run.right += $this$calculateHighLightViewRect.getHorizontalPadding$highlight_view_debug();
            $this$run.bottom += $this$calculateHighLightViewRect.getVerticalPadding$highlight_view_debug();
            HighlightShape highlightShape = $this$calculateHighLightViewRect.getHighlightShape$highlight_view_debug();
            if (highlightShape == null) break block0;
            highlightShape.initRect($this$run);
        }
    }

    public static final float getDp(float $this$dp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return TypedValue.applyDimension((int)1, (float)$this$dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final float getSp(float $this$sp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return TypedValue.applyDimension((int)2, (float)$this$sp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final int getDp(int $this$dp) {
        float f = $this$dp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public static final int getSp(int $this$sp) {
        float f = $this$sp;
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return (int)TypedValue.applyDimension((int)2, (float)f, (DisplayMetrics)resources.getDisplayMetrics());
    }
}

